/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.viewport;

import net.caffeinemc.mods.sodium.client.render.viewport.CameraTransform;
import net.caffeinemc.mods.sodium.client.render.viewport.frustum.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import org.joml.Vector3d;

public final class Viewport {
    private final Frustum frustum;
    private final CameraTransform transform;
    private final SectionPos sectionCoords;
    private final BlockPos blockCoords;

    public Viewport(Frustum frustum, Vector3d position) {
        this.frustum = frustum;
        this.transform = new CameraTransform(position.x, position.y, position.z);
        this.sectionCoords = SectionPos.of((int)SectionPos.posToSectionCoord((double)position.x), (int)SectionPos.posToSectionCoord((double)position.y), (int)SectionPos.posToSectionCoord((double)position.z));
        this.blockCoords = BlockPos.containing((double)position.x, (double)position.y, (double)position.z);
    }

    public boolean isBoxVisible(int intOriginX, int intOriginY, int intOriginZ, float floatSizeX, float floatSizeY, float floatSizeZ) {
        float floatOriginX = (float)(intOriginX - this.transform.intX) - this.transform.fracX;
        float floatOriginY = (float)(intOriginY - this.transform.intY) - this.transform.fracY;
        float floatOriginZ = (float)(intOriginZ - this.transform.intZ) - this.transform.fracZ;
        return this.frustum.testAab(floatOriginX - floatSizeX, floatOriginY - floatSizeY, floatOriginZ - floatSizeZ, floatOriginX + floatSizeX, floatOriginY + floatSizeY, floatOriginZ + floatSizeZ);
    }

    public CameraTransform getTransform() {
        return this.transform;
    }

    public SectionPos getChunkCoord() {
        return this.sectionCoords;
    }

    public BlockPos getBlockCoord() {
        return this.blockCoords;
    }
}

