/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.core;

import dev.latvian.mods.kubejs.core.InventoryKJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RemapPrefixForJS(value="kjs$")
public interface ContainerKJS
extends InventoryKJS {
    default public Container kjs$self() {
        return (Container)this;
    }

    @Override
    default public boolean kjs$isMutable() {
        return true;
    }

    @Override
    default public int kjs$getSlots() {
        return this.kjs$self().getContainerSize();
    }

    @Override
    @NotNull
    default public ItemStack kjs$getStackInSlot(int slot) {
        return this.kjs$self().getItem(slot);
    }

    @Override
    @NotNull
    default public ItemStack kjs$insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.kjs$self().getItem(slot);
        if (!stackInSlot.isEmpty()) {
            if (stackInSlot.getCount() >= Math.min(stackInSlot.getMaxStackSize(), this.kjs$getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.kjs$self().canPlaceItem(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.getMaxStackSize(), this.kjs$getSlotLimit(slot)) - stackInSlot.getCount();
            if (stack.getCount() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.copy();
                    copy.grow(stackInSlot.getCount());
                    this.kjs$self().setItem(slot, copy);
                    this.kjs$self().setChanged();
                }
                return ItemStack.EMPTY;
            }
            stack = stack.copy();
            if (!simulate) {
                ItemStack copy = stack.split(m);
                copy.grow(stackInSlot.getCount());
                this.kjs$self().setItem(slot, copy);
                this.kjs$self().setChanged();
            } else {
                stack.shrink(m);
            }
            return stack;
        }
        if (!this.kjs$self().canPlaceItem(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.getMaxStackSize(), this.kjs$getSlotLimit(slot));
        if (m < stack.getCount()) {
            stack = stack.copy();
            if (!simulate) {
                this.kjs$self().setItem(slot, stack.split(m));
                this.kjs$self().setChanged();
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!simulate) {
            this.kjs$self().setItem(slot, stack);
            this.kjs$self().setChanged();
        }
        return ItemStack.EMPTY;
    }

    @Override
    @NotNull
    default public ItemStack kjs$extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.kjs$self().getItem(slot);
        if (stackInSlot.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (simulate) {
            if (stackInSlot.getCount() < amount) {
                return stackInSlot.copy();
            }
            ItemStack copy = stackInSlot.copy();
            copy.setCount(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.getCount(), amount);
        ItemStack decrStackSize = this.kjs$self().removeItem(slot, m);
        this.kjs$self().setChanged();
        return decrStackSize;
    }

    @Override
    default public void kjs$setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.kjs$self().setItem(slot, stack);
    }

    @Override
    default public int kjs$getSlotLimit(int slot) {
        return this.kjs$self().getMaxStackSize();
    }

    @Override
    default public boolean kjs$isItemValid(int slot, @NotNull ItemStack stack) {
        return this.kjs$self().canPlaceItem(slot, stack);
    }

    @Override
    default public int kjs$getWidth() {
        int n;
        Container container = this.kjs$self();
        if (container instanceof CraftingContainer) {
            CraftingContainer crafter = (CraftingContainer)container;
            n = crafter.getWidth();
        } else {
            n = InventoryKJS.super.kjs$getWidth();
        }
        return n;
    }

    @Override
    default public int kjs$getHeight() {
        int n;
        Container container = this.kjs$self();
        if (container instanceof CraftingContainer) {
            CraftingContainer crafter = (CraftingContainer)container;
            n = crafter.getHeight();
        } else {
            n = InventoryKJS.super.kjs$getHeight();
        }
        return n;
    }

    @Override
    default public void kjs$clear() {
        this.kjs$self().clearContent();
    }

    @Override
    default public void kjs$setChanged() {
        this.kjs$self().setChanged();
        Container container = this.kjs$self();
        if (container instanceof Inventory) {
            Inventory inv = (Inventory)container;
            inv.player.kjs$sendInventoryUpdate();
        }
    }

    @Override
    @Nullable
    default public BlockContainerJS kjs$getBlock(Level level) {
        Container container = this.kjs$self();
        if (container instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)container;
            return level.kjs$getBlock(be);
        }
        return null;
    }

    @Override
    default public Container kjs$asContainer() {
        return this.kjs$self();
    }
}

