/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.client;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.GatherSkippedAttributeTooltipsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import net.neoforged.neoforge.common.util.AttributeUtil;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.client.KeyRegistry;
import top.theillusivec4.curios.common.network.client.CPacketOpenCurios;

public class ClientEventHandler {
    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Post evt) {
        if (KeyRegistry.openCurios.consumeClick() && Minecraft.getInstance().isWindowActive()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new CPacketOpenCurios(ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public void onAttributeTooltip(AddAttributeTooltipsEvent evt) {
        AttributeTooltipContext context = evt.getContext();
        ItemStack stack = evt.getStack();
        GatherSkippedAttributeTooltipsEvent skipped = (GatherSkippedAttributeTooltipsEvent)NeoForge.EVENT_BUS.post((Event)new GatherSkippedAttributeTooltipsEvent(stack, context));
        if (skipped.isSkippingAll()) {
            return;
        }
        ArrayList<MutableComponent> attributesTooltip = new ArrayList<MutableComponent>();
        Player player = context.player();
        List<String> slots = ClientEventHandler.getItemStackSlots(stack, player);
        for (String identifier : slots) {
            SlotContext slotContext = new SlotContext(identifier, (LivingEntity)player, 0, false, true);
            Multimap<Holder<Attribute>, AttributeModifier> attributes = CuriosApi.getAttributeModifiers(slotContext, CuriosApi.getSlotId(slotContext), stack);
            attributes.values().removeIf(modifier -> skipped.isSkipped(modifier.id()));
            if (attributes.isEmpty()) continue;
            attributesTooltip.add(Component.empty());
            attributesTooltip.add(Component.translatable((String)("curios.modifiers." + identifier)).withStyle(ChatFormatting.GOLD));
            if (player == null) continue;
            AttributeUtil.applyTextFor((ItemStack)stack, attributesTooltip::add, attributes, (AttributeTooltipContext)AttributeTooltipContext.of((Player)player, (Item.TooltipContext)context, (TooltipFlag)context.flag()));
        }
        evt.addTooltipLines(((List)CuriosApi.getCurio(stack).map(curio -> curio.getAttributesTooltip(attributesTooltip, (Item.TooltipContext)context)).orElse(attributesTooltip)).toArray(new Component[0]));
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent evt) {
        ItemStack stack = evt.getItemStack();
        Player player = evt.getEntity();
        if (stack.isEmpty()) {
            return;
        }
        List<String> slots = ClientEventHandler.getItemStackSlots(stack, player);
        if (slots.isEmpty()) {
            return;
        }
        MutableComponent slotsTooltip = Component.translatable((String)"curios.tooltip.slot").append(" ").withStyle(ChatFormatting.GOLD);
        for (int j = 0; j < slots.size(); ++j) {
            String id = slots.get(j);
            String key = "curios.identifier." + id;
            MutableComponent type = Component.translatableWithFallback((String)key, (String)(Character.toUpperCase(id.charAt(0)) + id.substring(1).toLowerCase()));
            if (j < slots.size() - 1) {
                type = type.append(", ");
            }
            type = type.withStyle(ChatFormatting.YELLOW);
            slotsTooltip.append((Component)type);
        }
        Item.TooltipContext context = evt.getContext();
        List<MutableComponent> toAdd = List.of(slotsTooltip);
        evt.getToolTip().addAll(1, (Collection)CuriosApi.getCurio(stack).map(curio -> curio.getSlotsTooltip(toAdd, context)).orElse(toAdd));
    }

    private static List<String> getItemStackSlots(ItemStack stack, Player player) {
        Set<String> slots = Set.copyOf((player != null ? CuriosApi.getItemStackSlots(stack, (LivingEntity)player) : CuriosApi.getItemStackSlots(stack, FMLLoader.getDist() == Dist.CLIENT)).keySet());
        if (slots.contains("curio")) {
            slots = Set.of("curio");
        }
        return new ArrayList<String>(slots);
    }
}

