/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.mixin.copycat.step;

import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.foundation.copycat.CopycatExternalContext;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.utility.BlockUtils;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.decoration.copycat.CopycatBlockEntity;
import com.simibubi.create.content.decoration.copycat.CopycatStepBlock;
import com.simibubi.create.content.decoration.copycat.WaterloggedCopycatBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={CopycatStepBlock.class})
public abstract class CopycatStepBlockMixin
extends WaterloggedCopycatBlock
implements ICopycatBlock {
    public CopycatStepBlockMixin(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        if (!this.isCTEnabled(state, level, queryPos)) {
            return state;
        }
        return super.getAppearance(state, level, pos, side, queryState, queryPos);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.toggleCT(state, level, pos, player, hitResult);
    }

    @Override
    @Unique
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Unique
    @Nullable
    public CopycatBlockEntity getBlockEntity(BlockGetter worldIn, BlockPos pos) {
        return (CopycatBlockEntity)super.getBlockEntity(worldIn, pos);
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rotation) {
        return this.transform(state, new StructureTransform(BlockPos.ZERO, Direction.Axis.Y, rotation, Mirror.NONE));
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirror) {
        return this.transform(state, new StructureTransform(BlockPos.ZERO, null, Rotation.NONE, mirror));
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        return BlockUtils.transformStepLikeHorizontal(state, transform, CCBlocks.COPYCAT_VERTICAL_STEP.getDefaultState());
    }

    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, @Nullable BlockPos toPos) {
        if (CopycatExternalContext.isForBlockingLogic()) {
            return false;
        }
        if (toPos == null) {
            return true;
        }
        return !this.checkConnection(reader, toPos, fromPos, reader.getBlockState(toPos));
    }

    @Override
    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState fromState) {
        BlockState toState = reader.getBlockState(toPos);
        if (toState.getBlock() instanceof ICopycatBlock) {
            return true;
        }
        return this.checkConnection(reader, fromPos, toPos, fromState);
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    @Override
    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return ICopycatBlock.hidesNeighborFace(level, pos, state, neighborState, dir);
    }
}

