/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.blocks;

import com.blackgear.vanillabackport.common.level.blocks.CreakingHeartBlock;
import com.blackgear.vanillabackport.common.level.blocks.EyeblossomBlock;
import com.blackgear.vanillabackport.common.registries.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class EyeblossomFlowerPotBlock
extends FlowerPotBlock {
    public EyeblossomFlowerPotBlock(Block content, BlockBehaviour.Properties properties) {
        super(content, properties);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean isNaturalNight;
        boolean hasOpenEyeblossom;
        if (this.isRandomlyTicking(state) && level.dimensionType().natural() && (hasOpenEyeblossom = this.getPotted() == ModBlocks.OPEN_EYEBLOSSOM.get()) != (isNaturalNight = CreakingHeartBlock.isNaturalNight((Level)level))) {
            level.setBlock(pos, this.opposite(state), 3);
            EyeblossomBlock.Type type = EyeblossomBlock.Type.fromBoolean(hasOpenEyeblossom).transform();
            type.spawnTransformParticle(level, pos, random);
            level.playSound(null, pos, type.longSwitchSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        super.randomTick(state, level, pos, random);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return state.is(ModBlocks.POTTED_OPEN_EYEBLOSSOM.get()) || state.is(ModBlocks.POTTED_CLOSED_EYEBLOSSOM.get());
    }

    private BlockState opposite(BlockState state) {
        if (state.is(ModBlocks.POTTED_OPEN_EYEBLOSSOM.get())) {
            return ModBlocks.POTTED_CLOSED_EYEBLOSSOM.get().defaultBlockState();
        }
        return state.is(ModBlocks.POTTED_CLOSED_EYEBLOSSOM.get()) ? ModBlocks.POTTED_OPEN_EYEBLOSSOM.get().defaultBlockState() : state;
    }
}

