/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.api.leash;

import com.blackgear.vanillabackport.common.api.leash.LeashDataExtension;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface LeashExtension {
    public static final Map<Predicate<Entity>, Function<Entity, Vec3[]>> QUAD_LEASH_OFFSETS = (Map)Util.make(() -> {
        ImmutableMap.Builder offsets = new ImmutableMap.Builder();
        offsets.put(entity -> entity instanceof Boat, entity -> LeashExtension.createQuadLeashOffsets(entity, 0.0, 0.64, 0.382, 0.88));
        offsets.put(entity -> entity instanceof Camel, entity -> LeashExtension.createQuadLeashOffsets(entity, 0.02, 0.48, 0.25, 0.82));
        offsets.put(entity -> entity instanceof AbstractHorse, entity -> LeashExtension.createQuadLeashOffsets(entity, 0.04, 0.52, 0.23, 0.87));
        offsets.put(entity -> entity instanceof AbstractChestedHorse, entity -> LeashExtension.createQuadLeashOffsets(entity, 0.04, 0.41, 0.18, 0.73));
        offsets.put(entity -> entity instanceof Sniffer, entity -> LeashExtension.createQuadLeashOffsets(entity, -0.01, 0.63, 0.38, 1.15));
        return offsets.build();
    });
    public static final Vec3 AXIS_SPECIFIC_ELASTICITY = new Vec3(0.8, 0.2, 0.8);
    public static final List<Vec3> ENTITY_ATTACHMENT_POINT = ImmutableList.of((Object)new Vec3(0.0, 0.5, 0.5));
    public static final List<Vec3> LEASHER_ATTACHMENT_POINT = ImmutableList.of((Object)new Vec3(0.0, 0.5, 0.0));
    public static final List<Vec3> SHARED_QUAD_ATTACHMENT_POINTS = ImmutableList.of((Object)new Vec3(-0.5, 0.5, 0.5), (Object)new Vec3(-0.5, 0.5, -0.5), (Object)new Vec3(0.5, 0.5, -0.5), (Object)new Vec3(0.5, 0.5, 0.5));

    default public boolean canHaveALeashAttachedTo(Entity target) {
        if (this == target) {
            return false;
        }
        return this.leashDistanceTo(target) <= this.leashSnapDistance() && ((Leashable)this).canBeLeashed();
    }

    default public double leashDistanceTo(Entity entity) {
        return entity.getBoundingBox().getCenter().distanceTo(((Entity)this).getBoundingBox().getCenter());
    }

    default public void onElasticLeashPull() {
        ((Entity)this).checkSlowFallDistance();
    }

    default public double leashSnapDistance() {
        return 12.0;
    }

    default public double leashElasticDistance() {
        return 6.0;
    }

    public static <E extends Entity> float angularFriction(E entity) {
        if (entity.onGround()) {
            return entity.level().getBlockState(entity.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction() * 0.91f;
        }
        return entity.isInLiquid() ? 0.8f : 0.91f;
    }

    default public void whenLeashedTo(Entity entity) {
        if (entity instanceof LeashExtension) {
            LeashExtension extension = (LeashExtension)entity;
            extension.notifyLeashHolder((Leashable)this);
        }
    }

    default public void notifyLeashHolder(Leashable leashable) {
    }

    default public void resetAngularMomentum() {
        Leashable.LeashData leashData;
        Leashable.LeashData data = ((Leashable)this).getLeashData();
        if (data != null && (leashData = data) instanceof LeashDataExtension) {
            LeashDataExtension extension = (LeashDataExtension)leashData;
            extension.setAngularMomentum(0.0);
        }
    }

    default public boolean checkElasticInteractions(Entity entity, Leashable.LeashData data) {
        LeashExtension holder;
        if (((Entity)this).getControllingPassenger() instanceof Player) {
            return false;
        }
        boolean supportQuadLeash = entity instanceof LeashExtension && (holder = (LeashExtension)entity).supportQuadLeashAsHolder() && this.supportQuadLeash();
        List<Wrench> wrenches = LeashExtension.computeElasticInteraction((Entity)((LeashExtension)((Leashable)this)), entity, supportQuadLeash ? SHARED_QUAD_ATTACHMENT_POINTS : ENTITY_ATTACHMENT_POINT, supportQuadLeash ? SHARED_QUAD_ATTACHMENT_POINTS : LEASHER_ATTACHMENT_POINT);
        if (wrenches.isEmpty()) {
            return false;
        }
        Wrench wrench = Wrench.accumulate(wrenches).scale(supportQuadLeash ? 0.25 : 1.0);
        LeashDataExtension extension = (LeashDataExtension)data;
        extension.setAngularMomentum(extension.angularMomentum() + 10.0 * wrench.torque());
        Vec3 offset = LeashExtension.getHolderMovement(entity).subtract(LeashExtension.getKnownMovement((Entity)this));
        ((Entity)this).addDeltaMovement(wrench.force().multiply(AXIS_SPECIFIC_ELASTICITY).add(offset.scale(0.11)));
        return true;
    }

    public static Vec3 getHolderMovement(Entity entity) {
        Mob mob;
        return entity instanceof Mob && (mob = (Mob)entity).isNoAi() ? Vec3.ZERO : LeashExtension.getKnownMovement(entity);
    }

    public static Vec3 getKnownMovement(Entity entity) {
        LivingEntity passenger = entity.getControllingPassenger();
        if (passenger instanceof Player) {
            Player player = (Player)passenger;
            if (entity.isAlive()) {
                return player.getDeltaMovement();
            }
        }
        return entity.getDeltaMovement();
    }

    public static <E extends Entity & LeashExtension> List<Wrench> computeElasticInteraction(E entity, Entity holder, List<Vec3> attachmentPoints, List<Vec3> holderAttachmentPoints) {
        double elasticDistance = ((LeashExtension)entity).leashElasticDistance();
        Vec3 entityMovement = LeashExtension.getHolderMovement(entity);
        float entityYaw = entity.getYRot() * ((float)Math.PI / 180);
        Vec3 entityDimensions = new Vec3((double)entity.getBbWidth(), (double)entity.getBbHeight(), (double)entity.getBbWidth());
        float holderYaw = holder.getYRot() * ((float)Math.PI / 180);
        Vec3 holderDimensions = new Vec3((double)holder.getBbWidth(), (double)holder.getBbHeight(), (double)holder.getBbWidth());
        ArrayList<Wrench> wrenches = new ArrayList<Wrench>();
        for (int i = 0; i < attachmentPoints.size(); ++i) {
            Vec3 entityOffset = attachmentPoints.get(i).multiply(entityDimensions).yRot(-entityYaw);
            Vec3 entityPosition = entity.position().add(entityOffset);
            Vec3 holderOffset = holderAttachmentPoints.get(i).multiply(holderDimensions).yRot(-holderYaw);
            Vec3 holderPosition = holder.position().add(holderOffset);
            LeashExtension.computeDampenedSpringInteraction(holderPosition, entityPosition, elasticDistance, entityMovement, entityOffset).ifPresent(wrenches::add);
        }
        return wrenches;
    }

    private static Optional<Wrench> computeDampenedSpringInteraction(Vec3 holderPos, Vec3 entityPos, double threshold, Vec3 movement, Vec3 offset) {
        boolean movingWithForce;
        double distance = entityPos.distanceTo(holderPos);
        if (distance < threshold) {
            return Optional.empty();
        }
        Vec3 force = holderPos.subtract(entityPos).normalize().scale(distance - threshold);
        double torque = Wrench.torqueFromForce(offset, force);
        boolean bl = movingWithForce = movement.dot(force) >= 0.0;
        if (movingWithForce) {
            force = force.scale((double)0.3f);
        }
        return Optional.of(new Wrench(force, torque));
    }

    default public boolean supportQuadLeash() {
        Entity entity = (Entity)this;
        for (Predicate<Entity> filter : QUAD_LEASH_OFFSETS.keySet()) {
            if (!filter.test(entity)) continue;
            return true;
        }
        return false;
    }

    default public boolean supportQuadLeashAsHolder() {
        return false;
    }

    default public Vec3[] getQuadLeashOffsets() {
        Entity entity = (Entity)this;
        for (Predicate<Entity> filter : QUAD_LEASH_OFFSETS.keySet()) {
            if (!filter.test(entity)) continue;
            return QUAD_LEASH_OFFSETS.get(filter).apply(entity);
        }
        return LeashExtension.createQuadLeashOffsets((Entity)this, 0.0, 0.5, 0.5, 0.5);
    }

    default public Vec3[] getQuadLeashHolderOffsets() {
        return LeashExtension.createQuadLeashOffsets((Entity)this, 0.0, 0.5, 0.5, 0.0);
    }

    public static Vec3[] createQuadLeashOffsets(Entity entity, double forwardOffset, double sideOffset, double widthOffset, double heightOffset) {
        float entityWidth = entity.getBbWidth();
        double forward = forwardOffset * (double)entityWidth;
        double side = sideOffset * (double)entityWidth;
        double width = widthOffset * (double)entityWidth;
        double height = heightOffset * (double)entity.getBbHeight();
        return new Vec3[]{new Vec3(-width, height, side + forward), new Vec3(-width, height, -side + forward), new Vec3(width, height, -side + forward), new Vec3(width, height, side + forward)};
    }

    public static List<Leashable> leashableLeashedTo(Entity entity) {
        return LeashExtension.leashableInArea(entity, leashable -> leashable.getLeashHolder() == entity);
    }

    public static List<Leashable> leashableInArea(Entity entity, Predicate<Leashable> filter) {
        return LeashExtension.leashableInArea(entity.level(), entity.getBoundingBox().getCenter(), filter);
    }

    public static List<Leashable> leashableInArea(Level level, Vec3 pos, Predicate<Leashable> filter) {
        AABB area = AABB.ofSize((Vec3)pos, (double)32.0, (double)32.0, (double)32.0);
        return level.getEntitiesOfClass(Entity.class, area, entity -> {
            Leashable leashable;
            return entity instanceof Leashable && filter.test(leashable = (Leashable)entity);
        }).stream().map(Leashable.class::cast).toList();
    }

    public static float getPreciseBodyRotation(Entity entity, float partialTicks) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return Mth.lerp((float)partialTicks, (float)living.yBodyRotO, (float)living.yBodyRot);
        }
        return Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot());
    }

    public record Wrench(Vec3 force, double torque) {
        static final Wrench ZERO = new Wrench(Vec3.ZERO, 0.0);

        static double torqueFromForce(Vec3 position, Vec3 force) {
            return position.z * force.x - position.x * force.z;
        }

        public static Wrench accumulate(List<Wrench> wrenches) {
            if (wrenches.isEmpty()) {
                return ZERO;
            }
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            double torque = 0.0;
            for (Wrench wrench : wrenches) {
                Vec3 force = wrench.force;
                x += force.x;
                y += force.y;
                z += force.z;
                torque += wrench.torque;
            }
            return new Wrench(new Vec3(x, y, z), torque);
        }

        public Wrench scale(double factor) {
            return new Wrench(this.force.scale(factor), this.torque * factor);
        }
    }
}

