/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.registries;

import com.blackgear.platform.core.helper.ParticleRegistry;
import com.blackgear.vanillabackport.client.level.particles.particleoptions.TrailParticleOption;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class ModParticles {
    public static final ParticleRegistry PARTICLES = ParticleRegistry.create((String)"vanillabackport");
    public static final Supplier<SimpleParticleType> PALE_OAK_LEAVES = PARTICLES.register("pale_oak_leaves", false);
    public static final Supplier<ParticleType<TrailParticleOption>> TRAIL = PARTICLES.register("trail", false, particle -> TrailParticleOption.CODEC, particle -> TrailParticleOption.STREAM_CODEC);

    public static <T extends ParticleOptions> int sendParticles(ServerLevel level, T particle, double x, double y, double z, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        return ModParticles.sendParticles(level, particle, false, false, x, y, z, particleCount, xOffset, yOffset, zOffset, speed);
    }

    public static <T extends ParticleOptions> int sendParticles(ServerLevel level, T particle, boolean longDistance, boolean overrideLimiter, double x, double y, double z, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket(particle, overrideLimiter, x, y, z, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, particleCount);
        int sent = 0;
        for (int i = 0; i < level.players().size(); ++i) {
            ServerPlayer player = (ServerPlayer)level.players().get(i);
            if (!ModParticles.sendParticles(level, player, longDistance, x, y, z, packet)) continue;
            ++sent;
        }
        return sent;
    }

    public static <T extends ParticleOptions> boolean sendParticles(ServerLevel level, ServerPlayer player, T particle, boolean longDistance, boolean overrideLimiter, double x, double y, double z, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket(particle, overrideLimiter, x, y, z, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, particleCount);
        return ModParticles.sendParticles(level, player, longDistance, x, y, z, packet);
    }

    private static boolean sendParticles(ServerLevel level, ServerPlayer player, boolean longDistance, double x, double y, double z, Packet<?> packet) {
        if (player.level() != level) {
            return false;
        }
        BlockPos pos = player.blockPosition();
        if (pos.closerToCenterThan((Position)new Vec3(x, y, z), longDistance ? 512.0 : 32.0)) {
            player.connection.send(packet);
            return true;
        }
        return false;
    }
}

