/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.level.entities.model;

import com.blackgear.vanillabackport.common.level.entities.happyghast.HappyGhast;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HappyGhastModel<T extends HappyGhast>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart[] tentacles = new ModelPart[9];

    public HappyGhastModel(ModelPart root) {
        this.root = root;
        this.body = root.getChild("body");
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i] = this.body.getChild(HappyGhastModel.createTentacleName(i));
        }
    }

    private static String createTentacleName(int index) {
        return "tentacle" + index;
    }

    public static LayerDefinition createBodyLayer(boolean isBaby, CubeDeformation deformation) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f, deformation), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        if (isBaby) {
            body.addOrReplaceChild("inner_body", CubeListBuilder.create().texOffs(0, 32).addBox(-8.0f, -16.0f, -8.0f, 16.0f, 16.0f, 16.0f, deformation.extend(-0.5f)), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        }
        body.addOrReplaceChild(HappyGhastModel.createTentacleName(0), CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, deformation), PartPose.offset((float)-3.75f, (float)7.0f, (float)-5.0f));
        body.addOrReplaceChild(HappyGhastModel.createTentacleName(1), CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, deformation), PartPose.offset((float)1.25f, (float)7.0f, (float)-5.0f));
        body.addOrReplaceChild(HappyGhastModel.createTentacleName(2), CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, deformation), PartPose.offset((float)6.25f, (float)7.0f, (float)-5.0f));
        body.addOrReplaceChild(HappyGhastModel.createTentacleName(3), CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, deformation), PartPose.offset((float)-6.25f, (float)7.0f, (float)0.0f));
        body.addOrReplaceChild(HappyGhastModel.createTentacleName(4), CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, deformation), PartPose.offset((float)-1.25f, (float)7.0f, (float)0.0f));
        body.addOrReplaceChild(HappyGhastModel.createTentacleName(5), CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, deformation), PartPose.offset((float)3.75f, (float)7.0f, (float)0.0f));
        body.addOrReplaceChild(HappyGhastModel.createTentacleName(6), CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, deformation), PartPose.offset((float)-3.75f, (float)7.0f, (float)5.0f));
        body.addOrReplaceChild(HappyGhastModel.createTentacleName(7), CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, deformation), PartPose.offset((float)1.25f, (float)7.0f, (float)5.0f));
        body.addOrReplaceChild(HappyGhastModel.createTentacleName(8), CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, deformation), PartPose.offset((float)6.25f, (float)7.0f, (float)5.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.hasItemInSlot(EquipmentSlot.CHEST)) {
            this.body.xScale = 0.9375f;
            this.body.yScale = 0.9375f;
            this.body.zScale = 0.9375f;
        }
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i].xRot = 0.2f * Mth.sin((float)(ageInTicks * 0.3f + (float)i)) + 0.4f;
        }
    }

    public ModelPart root() {
        return this.root;
    }
}

