/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.toomanyrecipeviewers.impl.jei.api.runtime;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.FluidEmiStack;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.data.EmiAlias;
import dev.emi.emi.jemi.JemiStack;
import dev.emi.emi.jemi.JemiUtil;
import dev.emi.emi.registry.EmiStackList;
import dev.emi.emi.runtime.EmiReloadManager;
import dev.nolij.toomanyrecipeviewers.TooManyRecipeViewers;
import dev.nolij.toomanyrecipeviewers.TooManyRecipeViewersMod;
import dev.nolij.toomanyrecipeviewers.impl.ingredient.ErrorEmiStack;
import dev.nolij.toomanyrecipeviewers.impl.ingredient.ErrorIngredient;
import dev.nolij.toomanyrecipeviewers.util.IItemStackish;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.IExtraIngredientRegistration;
import mezz.jei.api.registration.IIngredientAliasRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.input.ClickableIngredient;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.core.util.WeakList;
import mezz.jei.library.ingredients.IngredientInfo;
import mezz.jei.library.ingredients.TypedIngredient;
import mezz.jei.library.plugins.vanilla.ingredients.ItemStackHelper;
import mezz.jei.library.plugins.vanilla.ingredients.fluid.FluidIngredientHelper;
import mezz.jei.library.render.FluidTankRenderer;
import mezz.jei.library.render.ItemStackRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class IngredientManager
implements IIngredientManager,
IModIngredientRegistration,
IExtraIngredientRegistration,
IIngredientAliasRegistration,
TooManyRecipeViewers.ILockable {
    private final TooManyRecipeViewers runtime;
    private final Map<IIngredientType<?>, IngredientInfo<?>> typeInfoMap = Collections.synchronizedMap(new HashMap());
    private final Map<Class<?>, IIngredientType<?>> classTypeMap = Collections.synchronizedMap(new HashMap());
    private final Map<Class<?>, IIngredientTypeWithSubtypes<?, ?>> baseClassTypeMap = Collections.synchronizedMap(new HashMap());
    private final WeakList<IIngredientManager.IIngredientListener> listeners = new WeakList();
    @Nullable
    private Collection<ItemStack> itemStacks = new ArrayList<ItemStack>();
    @Nullable
    private Collection<Object> fluidStacks = new ArrayList<Object>();
    private final Map<TypedIngredientUID, ITypedIngredient<?>> uidLookup = new ConcurrentHashMap();
    private volatile boolean locked = false;
    private final Set<EmiStack> removedStacks = Collections.synchronizedSet(new HashSet());

    public IngredientManager(TooManyRecipeViewers runtime) {
        runtime.lockAfterRegistration(this);
        this.runtime = runtime;
        this.registerIngredientType(new IngredientInfo<ErrorIngredient>(ErrorIngredient.INSTANCE, Collections.emptyList(), ErrorIngredient.INSTANCE, ErrorIngredient.INSTANCE, null), Collections.emptyList());
        this.registerIngredientType(new IngredientInfo<ItemStack>(VanillaTypes.ITEM_STACK, Collections.emptyList(), new ItemStackHelper(runtime.stackHelper, runtime.colorHelper), new ItemStackRenderer(), ItemStack.STRICT_SINGLE_ITEM_CODEC), Collections.emptyList());
        EmiStackList.stacks.stream().filter(ItemEmiStack.class::isInstance).map(ITypedIngredient.class::cast).forEach(x -> {
            ItemStack itemStack = (ItemStack)x.getIngredient();
            this.itemStacks.add(itemStack);
            try {
                this.uidLookup.put(this.getUid(VanillaTypes.ITEM_STACK, itemStack), (ITypedIngredient<?>)x);
                this.uidLookup.put(this.getLegacyUid(VanillaTypes.ITEM_STACK, itemStack), (ITypedIngredient<?>)x);
            }
            catch (Throwable t) {
                TooManyRecipeViewersMod.LOGGER.error("Broken ItemStack {}", (Object)itemStack.toString(), (Object)t);
            }
        });
        this.registerIngredientType(new IngredientInfo(TooManyRecipeViewers.fluidHelper.getFluidIngredientType(), Collections.emptyList(), new FluidIngredientHelper(runtime.subtypeManager, runtime.colorHelper, TooManyRecipeViewers.fluidHelper), new FluidTankRenderer(TooManyRecipeViewers.fluidHelper), TooManyRecipeViewers.fluidHelper.getCodec()), Collections.emptyList());
        EmiStackList.stacks.stream().filter(FluidEmiStack.class::isInstance).map(ITypedIngredient.class::cast).forEach(x -> {
            IIngredientTypeWithSubtypes fluidType = TooManyRecipeViewers.fluidHelper.getFluidIngredientType();
            FluidStack fluidStack = (FluidStack)x.getIngredient();
            this.fluidStacks.add(fluidStack);
            try {
                this.uidLookup.put(this.getUid(fluidType, fluidStack), (ITypedIngredient<?>)x);
                this.uidLookup.put(this.getLegacyUid(fluidType, fluidStack), (ITypedIngredient<?>)x);
            }
            catch (Throwable t) {
                TooManyRecipeViewersMod.LOGGER.error("Broken FluidStack {}", (Object)fluidStack.toString(), (Object)t);
            }
        });
    }

    public EmiIngredient getEMIIngredient(Stream<ItemStack> itemStackStream) {
        return EmiIngredient.of(itemStackStream.map(EmiStack::of).toList());
    }

    public EmiStack getEMIStack(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return ItemEmiStack.EMPTY;
        }
        return ItemEmiStack.of((ItemStack)stack);
    }

    public EmiStack getEMIStack(FluidStack stack) {
        if (stack == null || stack.isEmpty()) {
            return FluidEmiStack.EMPTY;
        }
        return FluidEmiStack.of((Fluid)stack.getFluid(), (DataComponentPatch)stack.getComponentsPatch(), (long)stack.getAmount());
    }

    public <T> EmiStack getEMIStack(IIngredientType<T> ingredientType, T ingredient) {
        if (ingredient == null) {
            return EmiStack.EMPTY;
        }
        if (ingredientType == null || ingredient == ErrorIngredient.INSTANCE) {
            return ErrorEmiStack.INSTANCE;
        }
        if (ingredient instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)ingredient;
            return this.getEMIStack(itemStack);
        }
        if (ingredient instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)ingredient;
            return this.getEMIStack(fluidStack);
        }
        IngredientInfo<?> ingredientInfo = this.typeInfoMap.get(ingredientType);
        if (ingredientInfo == null) {
            return ErrorEmiStack.INSTANCE;
        }
        return new JemiStack(ingredientType, ingredientInfo.getIngredientHelper(), ingredientInfo.getIngredientRenderer(), ingredient);
    }

    public <T> EmiStack getEMIStack(@Nullable ITypedIngredient<T> typedIngredient) {
        ITypedIngredient<T> iTypedIngredient = typedIngredient;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EmiStack.class, IItemStackish.class}, iTypedIngredient, n)) {
            case -1 -> EmiStack.EMPTY;
            case 0 -> {
                EmiStack emiStack;
                yield emiStack = (EmiStack)iTypedIngredient;
            }
            case 1 -> {
                IItemStackish typedItemStack = (IItemStackish)((Object)iTypedIngredient);
                yield ItemEmiStack.of((ItemLike)typedItemStack.tmrv$getItem(), (DataComponentPatch)typedItemStack.tmrv$getDataComponentPatch(), (long)typedItemStack.tmrv$getAmount());
            }
            default -> this.getEMIStack(typedIngredient.getType(), typedIngredient.getIngredient());
        };
    }

    public Optional<ITypedIngredient<?>> getTypedIngredient(EmiStack emiStack) {
        if (emiStack instanceof ITypedIngredient) {
            ITypedIngredient typedIngredient = (ITypedIngredient)emiStack;
            return Optional.of(typedIngredient);
        }
        return Optional.empty();
    }

    private <V> @Unmodifiable Collection<ITypedIngredient<V>> getAllTypedIngredients(IIngredientType<V> ingredientType) {
        return EmiStackList.stacks.stream().filter(ITypedIngredient.class::isInstance).map(ITypedIngredient.class::cast).filter(x -> x.getType() == ingredientType).map(x -> x).toList();
    }

    @Override
    public <V> @Unmodifiable Collection<V> getAllIngredients(IIngredientType<V> ingredientType) {
        if (ingredientType == VanillaTypes.ITEM_STACK && this.itemStacks != null) {
            return this.itemStacks;
        }
        if (ingredientType == TooManyRecipeViewers.fluidHelper.getFluidIngredientType() && this.fluidStacks != null) {
            return this.fluidStacks;
        }
        return this.getAllTypedIngredients(ingredientType).stream().map(ITypedIngredient::getIngredient).toList();
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(V ingredient) {
        return this.getIngredientHelper(this.getIngredientType(ingredient));
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(IIngredientType<V> ingredientType) {
        return this.typeInfoMap.get(ingredientType).getIngredientHelper();
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(V ingredient) {
        return this.getIngredientRenderer(this.getIngredientType(ingredient));
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(IIngredientType<V> ingredientType) {
        return this.typeInfoMap.get(ingredientType).getIngredientRenderer();
    }

    @Override
    public <V> Codec<V> getIngredientCodec(IIngredientType<V> ingredientType) {
        return this.typeInfoMap.get(ingredientType).getIngredientCodec();
    }

    @Override
    public @Unmodifiable Collection<IIngredientType<?>> getRegisteredIngredientTypes() {
        return this.classTypeMap.values();
    }

    @Override
    public Optional<IIngredientType<?>> getIngredientTypeForUid(String uid) {
        return this.getRegisteredIngredientTypes().stream().filter(x -> uid.equals(x.getUid())).findFirst();
    }

    @Override
    public <V> void addIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        if (this.locked) {
            TooManyRecipeViewersMod.LOGGER.error((Object)new IllegalStateException("Tried to add ingredients after registry is locked"));
            return;
        }
        IngredientInfo<?> ingredientInfo = this.typeInfoMap.get(ingredientType);
        IIngredientHelper<?> ingredientHelper = ingredientInfo.getIngredientHelper();
        List<Object> validIngredients = ingredients.stream().filter(ingredient -> {
            if (!ingredientHelper.isValidIngredient(ingredient)) {
                TooManyRecipeViewersMod.LOGGER.error("Attempted to add an invalid Ingredient: {}", (Object)ingredientHelper.getErrorInfo(ingredient));
                return false;
            }
            if (!ingredientHelper.isIngredientOnServer(ingredient)) {
                TooManyRecipeViewersMod.LOGGER.error("Attempted to add an Ingredient that is not on the server: {}", (Object)ingredientHelper.getErrorInfo(ingredient));
                return false;
            }
            return true;
        }).toList();
        this.registerIngredients(ingredientType, ingredients);
        if (!this.listeners.isEmpty()) {
            List<ITypedIngredient> typedIngredients = validIngredients.stream().map(i -> TypedIngredient.createUnvalidated(ingredientType, i)).toList();
            this.listeners.forEach(listener -> listener.onIngredientsAdded(ingredientHelper, typedIngredients));
        }
    }

    @Override
    public <V> void removeIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        if (this.locked) {
            TooManyRecipeViewersMod.LOGGER.error((Object)new IllegalStateException("Tried to remove ingredients after registry is locked"));
            return;
        }
        IngredientInfo<?> ingredientInfo = this.typeInfoMap.get(ingredientType);
        IIngredientHelper<?> ingredientHelper = ingredientInfo.getIngredientHelper();
        for (V ingredient : ingredients) {
            EmiStack emiStack = this.getEMIStack(ingredientType, ingredient);
            if (emiStack.isEmpty()) continue;
            this.removedStacks.add(emiStack);
        }
        if (!this.listeners.isEmpty()) {
            List typedIngredients = TypedIngredient.createAndFilterInvalidNonnullList(this, ingredientType, ingredients, false);
            this.listeners.forEach(listener -> listener.onIngredientsRemoved(ingredientHelper, typedIngredients));
        }
    }

    @Override
    @Nullable
    public <V> IIngredientType<V> getIngredientType(V ingredient) {
        return this.classTypeMap.get(ingredient.getClass());
    }

    @Override
    public <V> Optional<IIngredientType<V>> getIngredientTypeChecked(V ingredient) {
        return Optional.ofNullable(this.getIngredientType(ingredient));
    }

    @Override
    public <B, I> Optional<IIngredientTypeWithSubtypes<B, I>> getIngredientTypeWithSubtypesFromBase(B baseIngredient) {
        return Optional.ofNullable(this.baseClassTypeMap.get(baseIngredient.getClass()));
    }

    @Override
    public <V> Optional<IIngredientType<V>> getIngredientTypeChecked(Class<? extends V> ingredientClass) {
        return Optional.ofNullable(this.classTypeMap.get(ingredientClass));
    }

    @Override
    public <V> Optional<ITypedIngredient<V>> createTypedIngredient(IIngredientType<V> ingredientType, V ingredient) {
        ITypedIngredient<V> result = TypedIngredient.createAndFilterInvalid(this, ingredientType, ingredient, false);
        return Optional.ofNullable(result);
    }

    @Override
    public <V> ITypedIngredient<V> normalizeTypedIngredient(ITypedIngredient<V> typedIngredient) {
        IIngredientType<V> type = typedIngredient.getType();
        IIngredientHelper<V> ingredientHelper = this.getIngredientHelper(type);
        return TypedIngredient.normalize(typedIngredient, ingredientHelper);
    }

    @Override
    public <V> Optional<IClickableIngredient<V>> createClickableIngredient(IIngredientType<V> ingredientType, V ingredient, Rect2i area, boolean normalize) {
        ITypedIngredient<V> typedIngredient = TypedIngredient.createAndFilterInvalid(this, ingredientType, ingredient, normalize);
        if (typedIngredient == null) {
            return Optional.empty();
        }
        ImmutableRect2i slotArea = new ImmutableRect2i(area);
        ClickableIngredient<V> clickableIngredient = new ClickableIngredient<V>(typedIngredient, slotArea);
        return Optional.of(clickableIngredient);
    }

    private <V> TypedIngredientUID getUid(IIngredientType<V> ingredientType, V ingredient) {
        IngredientInfo<?> ingredientInfo = this.typeInfoMap.get(ingredientType);
        IIngredientHelper<?> ingredientHelper = ingredientInfo.getIngredientHelper();
        String typeUid = ingredientType.getUid();
        try {
            return new TypedIngredientUID(typeUid, ingredientHelper.getUid(ingredient, UidContext.Ingredient));
        }
        catch (Throwable getUidException) {
            try {
                TooManyRecipeViewersMod.LOGGER.error("Failed to get UID for broken ingredient {}", (Object)ingredientHelper.getErrorInfo(ingredient), (Object)getUidException);
            }
            catch (Throwable getErrorInfoException) {
                TooManyRecipeViewersMod.LOGGER.error("Failed to get UID for broken ingredient", getErrorInfoException);
            }
            return null;
        }
    }

    private <V> TypedIngredientUID getLegacyUid(IIngredientType<V> ingredientType, V ingredient) {
        IngredientInfo<?> ingredientInfo = this.typeInfoMap.get(ingredientType);
        IIngredientHelper<?> ingredientHelper = ingredientInfo.getIngredientHelper();
        String typeUid = ingredientType.getUid();
        try {
            return new TypedIngredientUID(typeUid, ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient), true);
        }
        catch (Throwable throwable) {
            TooManyRecipeViewersMod.LOGGER.error("Failed to get legacy UID for broken ingredient", throwable);
            return null;
        }
    }

    @Override
    public <V> Optional<V> getIngredientByUid(IIngredientType<V> ingredientType, String uid) {
        return this.getTypedIngredientByUid(ingredientType, uid).map(ITypedIngredient::getIngredient);
    }

    @Override
    public <V> Optional<ITypedIngredient<V>> getTypedIngredientByUid(IIngredientType<V> ingredientType, String uid) {
        return Optional.ofNullable(this.uidLookup.getOrDefault(new TypedIngredientUID(ingredientType.getUid(), uid), this.uidLookup.getOrDefault(new TypedIngredientUID(ingredientType.getUid(), uid, true), null)));
    }

    @Override
    public Collection<String> getIngredientAliases(ITypedIngredient<?> typedIngredient) {
        EmiStack emiStack = this.getEMIStack(typedIngredient);
        EmiStack normalizedEMIStack = (EmiStack)emiStack.getEmiStacks().getFirst();
        Optional<EmiAlias.Baked> registeredAlias = EmiStackList.registryAliases.stream().filter(x -> x.stacks().stream().anyMatch(arg_0 -> ((EmiStack)normalizedEMIStack).equals(arg_0))).findFirst();
        return registeredAlias.map(x -> x.text().stream().map(Component::getString).toList()).orElse(Collections.emptyList());
    }

    @Override
    public void registerIngredientListener(IIngredientManager.IIngredientListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public ISubtypeManager getSubtypeManager() {
        return this.runtime.subtypeManager;
    }

    @Override
    public IColorHelper getColorHelper() {
        return this.runtime.colorHelper;
    }

    @Override
    public <V> void register(IIngredientType<V> ingredientType, Collection<V> ingredients, IIngredientHelper<V> ingredientHelper, IIngredientRenderer<V> ingredientRenderer, Codec<V> codec) {
        this.registerIngredientType(new IngredientInfo<V>(ingredientType, Collections.emptyList(), ingredientHelper, ingredientRenderer, codec), ingredients);
    }

    @Override
    public <V> void register(IIngredientType<V> ingredientType, Collection<V> ingredients, IIngredientHelper<V> ingredientHelper, IIngredientRenderer<V> ingredientRenderer) {
        this.registerIngredientType(new IngredientInfo<V>(ingredientType, Collections.emptyList(), ingredientHelper, ingredientRenderer, null), ingredients);
    }

    @Override
    public <V> void addExtraIngredients(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        if (!this.typeInfoMap.containsKey(ingredientType)) {
            throw new IllegalArgumentException();
        }
        this.registerIngredients(ingredientType, ingredients);
        this.typeInfoMap.get(ingredientType).addIngredients(ingredients);
    }

    @Override
    public <I> void addAlias(IIngredientType<I> type, I ingredient, String alias) {
        if (this.locked) {
            throw new IllegalStateException("Tried to add ingredient alias after registry is locked");
        }
        EmiStack emiStack = this.getEMIStack(type, ingredient);
        EmiStack normalizedEMIStack = (EmiStack)emiStack.getEmiStacks().getFirst();
        this.runtime.emiRegistry.addAlias((EmiIngredient)normalizedEMIStack, (Component)Component.translatable((String)alias));
    }

    @Override
    public <I> void addAlias(ITypedIngredient<I> typedIngredient, String alias) {
        this.addAlias(typedIngredient.getType(), typedIngredient.getIngredient(), alias);
    }

    @Override
    public <I> void addAliases(Collection<ITypedIngredient<I>> typedIngredients, Collection<String> aliases) {
        for (ITypedIngredient<I> typedIngredient : typedIngredients) {
            for (String alias : aliases) {
                this.addAlias(typedIngredient, alias);
            }
        }
    }

    @Override
    public <I> void addAliases(Collection<ITypedIngredient<I>> typedIngredients, String alias) {
        for (ITypedIngredient<I> typedIngredient : typedIngredients) {
            this.addAlias(typedIngredient, alias);
        }
    }

    @Override
    public <I> void addAliases(IIngredientType<I> type, Collection<I> ingredients, Collection<String> aliases) {
        for (I ingredient : ingredients) {
            for (String alias : aliases) {
                this.addAlias(type, ingredient, alias);
            }
        }
    }

    @Override
    public <I> void addAliases(IIngredientType<I> type, Collection<I> ingredients, String alias) {
        for (I ingredient : ingredients) {
            this.addAlias(type, ingredient, alias);
        }
    }

    @Override
    public <I> void addAliases(IIngredientType<I> type, I ingredient, Collection<String> aliases) {
        for (String alias : aliases) {
            this.addAlias(type, ingredient, alias);
        }
    }

    @Override
    public <I> void addAliases(ITypedIngredient<I> typedIngredient, Collection<String> aliases) {
        for (String alias : aliases) {
            this.addAlias(typedIngredient, alias);
        }
    }

    private <V> void registerIngredients(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        if (this.locked) {
            throw new IllegalStateException("Tried to add ingredients after registry is locked");
        }
        if (this.itemStacks != null && ingredientType == VanillaTypes.ITEM_STACK) {
            this.itemStacks.addAll(ingredients);
        } else if (this.fluidStacks != null && ingredientType == TooManyRecipeViewers.fluidHelper.getFluidIngredientType()) {
            this.fluidStacks.addAll(ingredients);
        }
        for (V ingredient : ingredients) {
            EmiStack emiStack = this.getEMIStack(ingredientType, ingredient);
            ITypedIngredient typedIngredient = (ITypedIngredient)emiStack;
            this.uidLookup.put(this.getUid(ingredientType, ingredient), typedIngredient);
            this.uidLookup.put(this.getLegacyUid(ingredientType, ingredient), typedIngredient);
            if (emiStack.isEmpty()) continue;
            this.runtime.emiRegistry.addEmiStack(emiStack);
        }
    }

    private <V> void registerIngredientType(IngredientInfo<V> ingredientInfo, Collection<V> ingredients) {
        if (this.locked) {
            throw new IllegalStateException("Tried to add ingredient type after registry is locked");
        }
        IIngredientType<V> ingredientType = ingredientInfo.getIngredientType();
        if (this.typeInfoMap.containsKey(ingredientType)) {
            throw new IllegalStateException();
        }
        this.typeInfoMap.put(ingredientType, ingredientInfo);
        this.classTypeMap.put(ingredientType.getIngredientClass(), ingredientType);
        if (ingredientType instanceof IIngredientTypeWithSubtypes) {
            IIngredientTypeWithSubtypes ingredientTypeWithSubtypes = (IIngredientTypeWithSubtypes)ingredientType;
            this.baseClassTypeMap.put(ingredientTypeWithSubtypes.getIngredientBaseClass(), ingredientTypeWithSubtypes);
        }
        if (ingredientType == VanillaTypes.ITEM_STACK || ingredientType == TooManyRecipeViewers.fluidHelper.getFluidIngredientType()) {
            return;
        }
        this.registerIngredients(ingredientType, ingredients);
    }

    private void registerItemStackDefaultComparison() {
        for (Item item : EmiPort.getItemRegistry()) {
            if (!this.runtime.subtypeManager.hasSubtypes(VanillaTypes.ITEM_STACK, item.getDefaultInstance())) continue;
            this.runtime.emiRegistry.setDefaultComparison((Object)item, Comparison.compareData(stack -> this.runtime.subtypeManager.getSubtypeInfo(stack.getItemStack(), UidContext.Recipe)));
        }
    }

    private void registerFluidDefaultComparison() {
        for (Fluid fluid : EmiPort.getFluidRegistry()) {
            IIngredientTypeWithSubtypes type = (IIngredientTypeWithSubtypes)JemiUtil.getFluidType();
            if (!this.runtime.subtypeManager.hasSubtypes(type, TooManyRecipeViewers.fluidHelper.create((Holder<Fluid>)fluid.builtInRegistryHolder(), 1000L))) continue;
            this.runtime.emiRegistry.setDefaultComparison((Object)fluid, Comparison.compareData(stack -> {
                ITypedIngredient typed = this.getTypedIngredient((EmiStack)stack).orElse(null);
                if (typed != null) {
                    return this.runtime.subtypeManager.getSubtypeInfo(type, typed.getIngredient(), UidContext.Recipe);
                }
                return null;
            }));
        }
    }

    private void registerOtherJEIIngredientTypeComparisons() {
        ArrayList jeiIngredientTypes = Lists.newArrayList(this.getRegisteredIngredientTypes());
        for (IIngredientType _jeiIngredientType : jeiIngredientTypes) {
            if (_jeiIngredientType == VanillaTypes.ITEM_STACK || _jeiIngredientType == JemiUtil.getFluidType() || !(_jeiIngredientType instanceof IIngredientTypeWithSubtypes)) continue;
            IIngredientTypeWithSubtypes jeiIngredientType = (IIngredientTypeWithSubtypes)_jeiIngredientType;
            ArrayList jeiIngredients = Lists.newArrayList(this.getAllIngredients(_jeiIngredientType));
            for (Object jeiIngredient : jeiIngredients) {
                try {
                    if (!this.runtime.subtypeManager.hasSubtypes(jeiIngredientType, jeiIngredient)) continue;
                    this.runtime.emiRegistry.setDefaultComparison(jeiIngredientType.getBase(jeiIngredient), Comparison.compareData(stack -> {
                        if (stack instanceof JemiStack) {
                            JemiStack jemiStack = (JemiStack)stack;
                            return this.runtime.subtypeManager.getSubtypeInfo(jeiIngredientType, jemiStack.ingredient, UidContext.Recipe);
                        }
                        return null;
                    }));
                }
                catch (Throwable t) {
                    TooManyRecipeViewersMod.LOGGER.error("Exception adding default comparison for JEI ingredient: ", t);
                }
            }
        }
    }

    @Override
    public synchronized void lock() throws IllegalStateException {
        if (this.locked) {
            throw new IllegalStateException();
        }
        this.locked = true;
        EmiReloadManager.step((Component)Component.literal((String)"[TMRV] Locking JEI Ingredient Registry..."), (long)100L);
        if (!this.removedStacks.isEmpty()) {
            this.runtime.emiRegistry.removeEmiStacks(this.removedStacks::contains);
        }
        this.registerItemStackDefaultComparison();
        this.registerFluidDefaultComparison();
        this.registerOtherJEIIngredientTypeComparisons();
        this.removedStacks.clear();
        this.itemStacks = null;
        this.fluidStacks = null;
    }

    private record TypedIngredientUID(String typeUid, Object ingredientUid, boolean legacy) {
        private TypedIngredientUID(String typeUid, Object ingredientUid) {
            this(typeUid, ingredientUid, false);
        }
    }
}

