/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.neoforge;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonChargeHud;
import net.mehvahdjukaar.supplementaries.client.hud.SlimedOverlayHud;
import net.mehvahdjukaar.supplementaries.client.hud.neoforge.SelectableContainerItemHudImpl;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.funny.JarredHeadLayer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.layers.PartyHatLayer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.layers.QuiverLayer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.layers.SlimedLayer;
import net.mehvahdjukaar.supplementaries.common.block.blocks.EndermanSkullBlock;
import net.mehvahdjukaar.supplementaries.common.utils.VibeChecker;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@EventBusSubscriber(modid="supplementaries", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class SupplementariesForgeClient {
    @SubscribeEvent
    public static void setup(FMLClientSetupEvent event) {
        VibeChecker.checkVibe();
    }

    @SubscribeEvent
    public static void onRegisterSkullModels(EntityRenderersEvent.CreateSkullModels event) {
        event.registerSkullModel(EndermanSkullBlock.TYPE, (SkullModelBase)new SkullModel(event.getEntityModelSet().bakeLayer(ModelLayers.SKELETON_SKULL)));
        SkullBlockRenderer.SKIN_BY_TYPE.put(EndermanSkullBlock.TYPE, Supplementaries.res("textures/entity/enderman_head.png"));
    }

    @SubscribeEvent
    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        EntityRenderer creeperRenderer;
        EntityRenderer strayRenderer;
        LivingEntityRenderer le;
        for (PlayerSkin.Model skinType : event.getSkins()) {
            EntityRenderer renderer = event.getSkin(skinType);
            if (!(renderer instanceof LivingEntityRenderer)) continue;
            le = (LivingEntityRenderer)renderer;
            le.addLayer(new QuiverLayer(le, false));
            le.addLayer(new JarredHeadLayer(le, event.getEntityModels()));
            le.addLayer(new PartyHatLayer.Generic(le, event.getEntityModels()));
            le.addLayer(new SlimedLayer(le));
        }
        EntityRenderer skeletonRenderer = event.getRenderer(EntityType.SKELETON);
        if (skeletonRenderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer le2 = (LivingEntityRenderer)skeletonRenderer;
            le2.addLayer(new QuiverLayer(le2, true));
        }
        if ((strayRenderer = event.getRenderer(EntityType.STRAY)) instanceof LivingEntityRenderer) {
            LivingEntityRenderer le3 = (LivingEntityRenderer)strayRenderer;
            le3.addLayer(new QuiverLayer(le3, true));
        }
        if ((creeperRenderer = event.getRenderer(EntityType.CREEPER)) instanceof LivingEntityRenderer) {
            le = (LivingEntityRenderer)creeperRenderer;
            le.addLayer(new PartyHatLayer.Creeper(le, event.getEntityModels(), event.getContext().getItemInHandRenderer()));
        }
        ImmutableList entityTypes = ImmutableList.copyOf((Collection)BuiltInRegistries.ENTITY_TYPE.stream().filter(DefaultAttributes::hasSupplier).filter(e -> e != EntityType.ENDER_DRAGON).map(entityType -> entityType).collect(Collectors.toList()));
        try {
            entityTypes.forEach(entityType -> {
                EntityRenderer r = event.getRenderer(entityType);
                if (r instanceof LivingEntityRenderer) {
                    LivingEntityRenderer le = (LivingEntityRenderer)r;
                    le.addLayer(new SlimedLayer(le));
                }
            });
        }
        catch (Exception e2) {
            Supplementaries.LOGGER.error("Failed to add slimed layer to entities:   ", (Throwable)e2);
        }
    }

    @SubscribeEvent
    public static void onAddGuiLayers(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.HOTBAR, Supplementaries.res("selectable_container_item"), (LayeredDraw.Layer)SelectableContainerItemHudImpl.getInstance());
        event.registerAbove(VanillaGuiLayers.EXPERIENCE_BAR, Supplementaries.res("cannon_charge"), (LayeredDraw.Layer)CannonChargeHud.INSTANCE);
        event.registerBelow(VanillaGuiLayers.CAMERA_OVERLAYS, Supplementaries.res("slimed"), (LayeredDraw.Layer)SlimedOverlayHud.INSTANCE);
    }
}

