/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.tiles.ItemShelfBlockTile;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ItemShelfBlock
extends WaterBlock
implements EntityBlock {
    public static final List<Block> ITEM_SHELF_BLOCKS = new ArrayList<Block>();
    protected static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)1.0, (double)13.0, (double)16.0, (double)4.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.SOUTH);
    protected static final VoxelShape SHAPE_WEST = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.WEST);
    protected static final VoxelShape SHAPE_EAST = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.EAST);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public ItemShelfBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
        ITEM_SHELF_BLOCKS.add((Block)this);
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return CommonConfigs.Building.ITEM_SHELF_LADDER.get();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, FACING});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return !worldIn.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite())).isAir();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (context.getClickedFace() == Direction.UP || context.getClickedFace() == Direction.DOWN) {
            return (BlockState)state.setValue((Property)FACING, (Comparable)Direction.NORTH);
        }
        return (BlockState)state.setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return facing == ((Direction)stateIn.getValue((Property)FACING)).getOpposite() && !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        ItemShelfBlockTile tile;
        ItemStack i;
        BlockEntity blockEntity;
        if (target.getLocation().y() >= (double)pos.getY() + 0.25 && (blockEntity = world.getBlockEntity(pos)) instanceof ItemShelfBlockTile && !(i = (tile = (ItemShelfBlockTile)blockEntity).getItem(0)).isEmpty()) {
            return i;
        }
        return super.getCloneItemStack(world, pos, state);
    }

    public boolean isPossibleToRespawnInThis(BlockState state) {
        return true;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ItemDisplayTile) {
            ItemDisplayTile tile = (ItemDisplayTile)blockEntity;
            return tile.interactWithPlayerItem(player, hand, stack);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        return blockEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)blockEntity) : null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new ItemShelfBlockTile(pPos, pState);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Container tile = (Container)blockEntity;
            return tile.isEmpty() ? 0 : 15;
        }
        return 0;
    }
}

