/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.sliceanddice.block.slicer;

import com.possible_triangle.sliceanddice.SlicerPartials;
import com.possible_triangle.sliceanddice.block.slicer.SlicerBlockEntity;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.kinetics.base.SingleAxisRotatingVisual;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u001b\u001a\u00020\u0013H\u0014J\u0018\u0010\u001c\u001a\u00020\u00132\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0018\u0010\u000f\u001a\n \r*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/possible_triangle/sliceanddice/block/slicer/SlicerVisual;", "Lcom/simibubi/create/content/kinetics/base/SingleAxisRotatingVisual;", "Lcom/possible_triangle/sliceanddice/block/slicer/SlicerBlockEntity;", "Ldev/engine_room/flywheel/lib/visual/SimpleDynamicVisual;", "context", "Ldev/engine_room/flywheel/api/visualization/VisualizationContext;", "mixer", "partialTick", "", "<init>", "(Ldev/engine_room/flywheel/api/visualization/VisualizationContext;Lcom/possible_triangle/sliceanddice/block/slicer/SlicerBlockEntity;F)V", "mixerPole", "Ldev/engine_room/flywheel/lib/instance/OrientedInstance;", "kotlin.jvm.PlatformType", "Ldev/engine_room/flywheel/lib/instance/OrientedInstance;", "mixerHead", "Lcom/simibubi/create/content/kinetics/base/RotatingInstance;", "Lcom/simibubi/create/content/kinetics/base/RotatingInstance;", "beginFrame", "", "ctx", "Ldev/engine_room/flywheel/api/visual/DynamicVisual$Context;", "animate", "transformHead", "renderedHeadOffset", "transformPole", "updateLight", "_delete", "collectCrumblingInstances", "consumer", "Ljava/util/function/Consumer;", "Ldev/engine_room/flywheel/api/instance/Instance;", "sliceanddice-forge-4.1.2"})
public final class SlicerVisual
extends SingleAxisRotatingVisual<SlicerBlockEntity>
implements SimpleDynamicVisual {
    @NotNull
    private final SlicerBlockEntity mixer;
    private final OrientedInstance mixerPole;
    private final RotatingInstance mixerHead;

    public SlicerVisual(@NotNull VisualizationContext context, @NotNull SlicerBlockEntity mixer, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mixer), (String)"mixer");
        super(context, (KineticBlockEntity)mixer, partialTick, Models.partial((PartialModel)AllPartialModels.SHAFTLESS_COGWHEEL));
        this.mixer = mixer;
        this.mixerPole = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)AllPartialModels.MECHANICAL_MIXER_POLE)).createInstance();
        this.mixerHead = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)SlicerPartials.INSTANCE.getSLICER_HEAD())).createInstance();
        this.animate(partialTick);
    }

    public void beginFrame(@NotNull DynamicVisual.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.animate(ctx.partialTick());
    }

    private final void animate(float partialTick) {
        float renderedHeadOffset = this.mixer.getRenderedHeadOffset(partialTick);
        this.transformPole(renderedHeadOffset);
        this.transformHead(renderedHeadOffset);
    }

    private final void transformHead(float renderedHeadOffset) {
        float speed = this.mixer.getRenderedHeadRotationSpeed();
        this.mixerHead.setPosition((Vec3i)this.getVisualPosition()).nudge(0.0f, -renderedHeadOffset, 0.0f).setRotationalSpeed(speed * 2.0f * 6.0f).setChanged();
    }

    private final void transformPole(float renderedHeadOffset) {
        this.mixerPole.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, -renderedHeadOffset, 0.0f).setChanged();
    }

    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        FlatLit[] flatLitArray = new FlatLit[]{this.mixerHead};
        this.relight(this.pos.below(), flatLitArray);
        flatLitArray = new FlatLit[]{this.mixerPole};
        this.relight(flatLitArray);
    }

    protected void _delete() {
        super._delete();
        this.mixerHead.delete();
        this.mixerPole.delete();
    }

    public void collectCrumblingInstances(@NotNull Consumer<Instance> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        super.collectCrumblingInstances(consumer);
        consumer.accept((Instance)this.mixerHead);
        consumer.accept((Instance)this.mixerPole);
    }
}

