/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.tabs;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.tabs.CreativeTabModifier;
import net.mehvahdjukaar.polytone.tabs.ItemToTabEvent;
import net.mehvahdjukaar.polytone.utils.CsvUtils;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;

public class CreativeTabsModifiersManager
extends PartialReloader<Resources> {
    private final MapRegistry<CreativeModeTab> customTabs = new MapRegistry("Custom Creative Tabs");
    private final Map<ResourceKey<CreativeModeTab>, CreativeTabModifier> modifiers = new HashMap<ResourceKey<CreativeModeTab>, CreativeTabModifier>();
    private final Set<ResourceKey<CreativeModeTab>> needsRefresh = new HashSet<ResourceKey<CreativeModeTab>>();
    private final Map<ResourceKey<CreativeModeTab>, CreativeTabModifier> vanillaTabs = new HashMap<ResourceKey<CreativeModeTab>, CreativeTabModifier>();

    public CreativeTabsModifiersManager() {
        super("creative_tab_modifiers");
    }

    @Override
    public Resources prepare(ResourceManager resourceManager) {
        Map<ResourceLocation, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        Map<ResourceLocation, List<String>> types = CsvUtils.parseCsv(resourceManager, "creative_tabs");
        return new Resources((Map<ResourceLocation, JsonElement>)ImmutableMap.copyOf(jsons), (Map<ResourceLocation, List<String>>)ImmutableMap.copyOf(types));
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        for (ResourceLocation resourceLocation : this.customTabs.keySet()) {
            PlatStuff.unregisterDynamic(BuiltInRegistries.CREATIVE_MODE_TAB, resourceLocation);
            if (!logOff) continue;
            PlatStuff.sortTabs();
        }
        this.customTabs.clear();
        for (Map.Entry entry : this.vanillaTabs.entrySet()) {
            ((CreativeTabModifier)entry.getValue()).applyAttributes((ResourceKey<CreativeModeTab>)((ResourceKey)entry.getKey()));
        }
        this.vanillaTabs.clear();
        this.needsRefresh.addAll(this.modifiers.keySet());
        this.modifiers.clear();
    }

    @Override
    protected void parseWithLevel(Resources resources, RegistryOps<JsonElement> ops, RegistryAccess access) {
        for (Map.Entry<ResourceLocation, List<String>> entry : resources.extraTabs.entrySet()) {
            for (String s : entry.getValue()) {
                ResourceLocation id = entry.getKey().withPath(s);
                ResourceKey key = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)id);
                if (!this.customTabs.containsKey(id) && !BuiltInRegistries.CREATIVE_MODE_TAB.containsKey(key)) {
                    CreativeModeTab tab = PlatStuff.createCreativeTab(id);
                    this.customTabs.register(id, tab);
                    continue;
                }
                Polytone.LOGGER.error("Creative Tab with id {} already exists! Ignoring.", (Object)id);
            }
        }
        for (Map.Entry<ResourceLocation, List<String>> entry : this.customTabs.getEntries()) {
            PlatStuff.registerDynamic(BuiltInRegistries.CREATIVE_MODE_TAB, entry.getKey(), (CreativeModeTab)entry.getValue());
        }
        if (!this.customTabs.isEmpty()) {
            Polytone.LOGGER.info("Registered {} custom Creative Tabs from Resource Packs: {}", (Object)this.customTabs.size(), (Object)(String.valueOf(this.customTabs) + ". Remember to add items to them!"));
            PlatStuff.sortTabs();
        }
        for (Map.Entry<ResourceLocation, Object> entry : Parsed.batchParseOnlyEnabled(resources.tabsModifiers, CreativeTabModifier.CODEC, ops, "creative tab modifier")) {
            this.addModifier(entry.getKey(), (CreativeTabModifier)entry.getValue());
        }
    }

    @Override
    protected void applyWithLevel(RegistryAccess access, boolean isLogIn) {
        if (!this.modifiers.isEmpty()) {
            this.needsRefresh.addAll(this.modifiers.keySet());
        }
        if (!this.needsRefresh.isEmpty()) {
            CreativeModeTabs.CACHED_PARAMETERS = null;
            this.needsRefresh.clear();
        }
    }

    private void addModifier(ResourceLocation fileId, CreativeTabModifier mod) {
        for (Holder tab : mod.targets().compute(fileId, BuiltInRegistries.CREATIVE_MODE_TAB)) {
            ResourceKey key = (ResourceKey)tab.unwrapKey().get();
            this.modifiers.merge((ResourceKey<CreativeModeTab>)key, mod, CreativeTabModifier::merge);
            PlatStuff.addTabEventForTab((ResourceKey<CreativeModeTab>)key);
        }
    }

    public void modifyTab(ItemToTabEvent event) {
        RegistryAccess access;
        ResourceKey<CreativeModeTab> tab = event.getTab();
        CreativeTabModifier mod = this.modifiers.get(tab);
        if (mod != null && (access = PlatStuff.hackyGetRegistryAccess()) != null) {
            CreativeTabModifier v = mod.applyItemsAndAttributes(event, access);
            if (!this.customTabs.containsKey(tab.location())) {
                this.vanillaTabs.put(tab, v);
            }
        }
    }

    public boolean isDynamicTab(ResourceLocation entryId) {
        return this.customTabs.containsKey(entryId);
    }

    public record Resources(Map<ResourceLocation, JsonElement> tabsModifiers, Map<ResourceLocation, List<String>> extraTabs) {
    }
}

