/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.mehvahdjukaar.polytone.colormap.ColormapExpressionProvider;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ModelResHelper;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemModelOverride {
    @Nullable
    protected final Integer stackCount;
    @Nullable
    protected final Pattern pattern;
    @Nullable
    protected final CompoundTag entityTag;
    @Nullable
    protected final ColormapExpressionProvider expression;
    protected final DataComponentMap components;
    protected ModelResourceLocation model;
    protected Map<DataComponentType<?>, CompoundTag> nbtMatchers;
    protected static final Codec<Map<ResourceLocation, Float>> ITEM_PREDICATE_CODEC = Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.FLOAT);
    protected static final UnboundedMapCodec<DataComponentType<?>, CompoundTag> NBT_COMPONENTS_CODEC = Codec.unboundedMap((Codec)DataComponentType.CODEC, (Codec)CompoundTag.CODEC);
    public static final Codec<ItemModelOverride> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DataComponentMap.CODEC.optionalFieldOf("components", (Object)DataComponentMap.EMPTY).forGetter(o -> o.components), (App)ModelResHelper.MODEL_RES_CODEC.fieldOf("model").forGetter(ItemModelOverride::model), (App)Codec.INT.optionalFieldOf("stack_count").forGetter(i -> Optional.ofNullable(i.stackCount())), (App)ExtraCodecs.PATTERN.optionalFieldOf("name_pattern").forGetter(i -> Optional.ofNullable(i.namePattern())), (App)CompoundTag.CODEC.optionalFieldOf("entity_nbt").forGetter(i -> Optional.ofNullable(i.entityTag)), (App)ColormapExpressionProvider.CODEC.optionalFieldOf("expression").forGetter(i -> Optional.ofNullable(i.expression)), (App)NBT_COMPONENTS_CODEC.optionalFieldOf("item_nbt_components", Map.of()).forGetter(i -> i.nbtMatchers)).apply((Applicative)instance, ItemModelOverride::new));
    public static final Codec<Partial> CODEC_MODEL_ONLY = RecordCodecBuilder.create(instance -> instance.group((App)ModelResHelper.MODEL_RES_CODEC.fieldOf("model").forGetter(Partial::model)).apply((Applicative)instance, Partial::new));

    public ItemModelOverride(DataComponentMap components, ModelResourceLocation model, Optional<Integer> stackCount, Optional<Pattern> pattern, Optional<CompoundTag> entityTag, Optional<ColormapExpressionProvider> expression, Map<DataComponentType<?>, CompoundTag> nbtMatchers) {
        this.components = components;
        this.model = model;
        this.stackCount = stackCount.orElse(null);
        this.pattern = pattern.orElse(null);
        this.entityTag = entityTag.orElse(null);
        this.expression = expression.orElse(null);
        this.nbtMatchers = nbtMatchers;
    }

    public ItemModelOverride(DataComponentMap map, ModelResourceLocation model) {
        this.model = model;
        this.stackCount = null;
        this.pattern = null;
        this.components = map;
        this.entityTag = null;
        this.expression = null;
    }

    public DataComponentMap components() {
        return this.components;
    }

    public ModelResourceLocation model() {
        return this.model;
    }

    @Nullable
    public Integer stackCount() {
        return this.stackCount;
    }

    @Nullable
    public Pattern namePattern() {
        return this.pattern;
    }

    @Nullable
    public CompoundTag entityTag() {
        return this.entityTag;
    }

    public boolean matchesPredicate(ItemStack stack, @Nullable Level level, @Nullable Supplier<CompoundTag> entityTagGetter, @Nullable Component customName) {
        BlockPos pos;
        CompoundTag tag;
        if (this.pattern != null && customName != null && !this.pattern.matcher(customName.getString()).matches()) {
            return false;
        }
        if (this.entityTag != null && entityTagGetter != null && !ItemModelOverride.containsTag(tag = entityTagGetter.get(), this.entityTag)) {
            return false;
        }
        if (this.expression != null && this.expression.getValue(null, pos = ClientFrameTicker.getCameraPos(), null, null, stack) == 0.0f) {
            return false;
        }
        for (Map.Entry<DataComponentType<?>, CompoundTag> m : this.nbtMatchers.entrySet()) {
            CustomData d;
            DataComponentType<?> type = m.getKey();
            Object c = stack.get(type);
            if (!(c instanceof CustomData) || ItemModelOverride.containsTag((d = (CustomData)c).getUnsafe(), m.getValue())) continue;
            return false;
        }
        return true;
    }

    private static boolean containsTag(CompoundTag entityTag, CompoundTag tagToMatch) {
        for (String key : tagToMatch.getAllKeys()) {
            Tag t = entityTag.get(key);
            if (t == null) {
                return false;
            }
            if (t instanceof CompoundTag) {
                CompoundTag ct = (CompoundTag)t;
                CompoundTag compound = tagToMatch.getCompound(key);
                if (compound.isEmpty()) {
                    return false;
                }
                if (ItemModelOverride.containsTag(compound, ct)) continue;
                return false;
            }
            if (t.equals((Object)entityTag.get(key))) continue;
            return false;
        }
        return true;
    }

    public record Partial(ModelResourceLocation model) {
    }
}

