/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.neoforge;

import com.blackgear.platform.core.Environment;
import com.blackgear.platform.core.util.config.ConfigBuilder;
import com.blackgear.platform.core.util.config.ModConfig;
import com.blackgear.platform.core.util.config.neoforge.ForgeConfigBuilder;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.thread.BlockableEventLoop;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;

public class EnvironmentImpl {
    public static boolean isClientSide() {
        return FMLLoader.getDist() == Dist.CLIENT;
    }

    public static boolean isProduction() {
        return !FMLLoader.isProduction();
    }

    public static boolean hasModLoaded(String modId) {
        Objects.requireNonNull(modId, "Mod ID cannot be null");
        return ModList.get().isLoaded(modId);
    }

    public static String getModVersion(String modId) {
        Objects.requireNonNull(modId, "Mod ID cannot be null");
        return ModList.get().getModContainerById(modId).map(container -> container.getModInfo().getVersion().toString()).orElse(null);
    }

    public static Optional<MinecraftServer> getCurrentServer() {
        return Optional.ofNullable(ServerLifecycleHooks.getCurrentServer());
    }

    public static BlockableEventLoop<?> getGameExecutor() {
        try {
            return (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(EffectiveSide.get());
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to get game executor", exception);
        }
    }

    public static Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    public static Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static <T> T registerSafeConfig(String modId, ModConfig.Type type, Function<ConfigBuilder, T> spec) {
        ModLoadingContext context = ModLoadingContext.get();
        if (context == null || context.getActiveContainer() == null) {
            throw new IllegalStateException("Cannot register config outside of mod loading context");
        }
        String fileName = String.format("%s-%s.toml", modId, type.name().toLowerCase(Locale.ROOT));
        Pair<T, ModConfigSpec> pair = new ForgeConfigBuilder(new ModConfigSpec.Builder()).configure(spec);
        context.getActiveContainer().registerConfig(EnvironmentImpl.forge(type), (IConfigSpec)pair.getRight(), fileName);
        return (T)pair.getLeft();
    }

    public static <T> T registerSafeConfig(String modId, ModConfig.Type type, String fileName, Function<ConfigBuilder, T> spec) {
        ModLoadingContext context = ModLoadingContext.get();
        if (context == null || context.getActiveContainer() == null) {
            throw new IllegalStateException("Cannot register config outside of mod loading context");
        }
        Pair<T, ModConfigSpec> pair = new ForgeConfigBuilder(new ModConfigSpec.Builder()).configure(spec);
        context.getActiveContainer().registerConfig(EnvironmentImpl.forge(type), (IConfigSpec)pair.getRight(), fileName);
        return (T)pair.getLeft();
    }

    private static ModConfig.Type forge(ModConfig.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ModConfig.Type.COMMON -> ModConfig.Type.COMMON;
            case ModConfig.Type.CLIENT -> ModConfig.Type.CLIENT;
            case ModConfig.Type.SERVER -> ModConfig.Type.SERVER;
        };
    }

    public static Environment.Loader getLoader() {
        return Environment.Loader.FORGE;
    }
}

