/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4d;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.mixin.access.ParticleEngineAccessor;
import pigcart.particlerain.particle.WeatherParticle;

public class RippleParticle
extends WeatherParticle {
    private RippleParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        ParticleEngineAccessor particleEngine = (ParticleEngineAccessor)Minecraft.getInstance().particleEngine;
        this.setSprite(particleEngine.getTextureAtlas().getSprite(VersionUtil.getId("particlerain", "ripple_0")));
        this.x = (float)Math.round((double)(this.x / 0.0625)) * 0.0625f;
        this.z = (float)Math.round((double)(this.z / 0.0625)) * 0.0625f;
        this.quadSize = ConfigManager.config.ripple.size;
        this.alpha = ConfigManager.config.ripple.opacity;
    }

    @Override
    public void tickDistanceFade() {
    }

    @Override
    public void tick() {
        super.tick();
        this.alpha = Mth.lerp((float)((float)this.age / 9.0f), (float)ConfigManager.config.ripple.opacity, (float)0.0f);
        if (this.age > 8) {
            this.remove();
        }
        ParticleEngineAccessor particleEngine = (ParticleEngineAccessor)Minecraft.getInstance().particleEngine;
        this.setSprite(particleEngine.getTextureAtlas().getSprite(VersionUtil.getId("particlerain", "ripple_" + (this.age - 1))));
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float f) {
        Vec3 camPos = camera.getPosition();
        float x = (float)(Mth.lerp((double)f, (double)this.xo, (double)this.x) - camPos.x());
        float y = (float)(Mth.lerp((double)f, (double)this.yo, (double)this.y) - camPos.y());
        float z = (float)(Mth.lerp((double)f, (double)this.zo, (double)this.z) - camPos.z());
        Quaternionf quaternion = new Quaternionf(new AxisAngle4d(1.5707963705062866, -1.0, 0.0, 0.0));
        this.turnBackfaceFlipways(quaternion, new Vector3f(x, y, z));
        this.renderRotatedQuad(vertexConsumer, quaternion, x, y, z, f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        public DefaultFactory(SpriteSet provider) {
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new RippleParticle(level, x, y, z);
        }
    }
}

