/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4d;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import pigcart.particlerain.config.ConfigData;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.particle.WeatherParticle;

public class MistParticle
extends WeatherParticle {
    private MistParticle(ClientLevel level, double x, double y, double z, SpriteSet provider) {
        super(level, x, y, z);
        this.y = (float)((int)y) + this.random.nextFloat();
        this.setSprite(ConfigManager.config.mist.renderStyle.getSprite());
        this.quadSize = ConfigManager.config.mist.size;
        this.setSize(this.quadSize, 0.2f);
        this.targetOpacity = ConfigManager.config.mist.opacity;
        this.lifetime = ConfigManager.config.mist.lifetime;
        this.alpha = 0.0f;
        Color color = new Color(((Biome)this.level.getBiome((BlockPos)this.pos).value()).getFogColor());
        this.rCol = (float)color.getRed() / 255.0f;
        this.gCol = (float)color.getGreen() / 255.0f;
        this.bCol = (float)color.getBlue() / 255.0f;
        this.oRoll = this.roll = 1.5707964f * (float)level.random.nextInt(4);
    }

    @Override
    public void tick() {
        super.tick();
        int halfLife = this.lifetime / 2;
        this.alpha = (this.age < halfLife ? (float)this.age / (float)halfLife : (float)(-this.age + this.lifetime) / (float)halfLife) * ConfigManager.config.mist.opacity;
        if (ConfigManager.config.mist.renderStyle == ConfigData.MistOptions.RenderStyle.DITHERED) {
            this.quadSize = this.distance * 0.1f * ConfigManager.config.mist.size;
        }
        if (this.distance > (float)ConfigManager.config.perf.surfaceRange) {
            this.remove();
        }
    }

    @Override
    public void tickDistanceFade() {
    }

    public Optional<ParticleGroup> getParticleGroup() {
        return Optional.empty();
    }

    public ParticleRenderType getRenderType() {
        return ConfigManager.config.mist.renderStyle.getRenderType();
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float tickPercent) {
        Vec3 camPos = camera.getPosition();
        float x = (float)(Mth.lerp((double)tickPercent, (double)this.xo, (double)this.x) - camPos.x());
        float y = (float)(Mth.lerp((double)tickPercent, (double)this.yo, (double)this.y) - camPos.y());
        float z = (float)(Mth.lerp((double)tickPercent, (double)this.zo, (double)this.z) - camPos.z());
        Quaternionf quaternion = new Quaternionf(new AxisAngle4d(1.5707963705062866, -1.0, 0.0, 0.0));
        quaternion.rotateZ(Mth.lerp((float)tickPercent, (float)this.oRoll, (float)this.roll));
        this.turnBackfaceFlipways(quaternion, new Vector3f(x, y, z));
        this.renderRotatedQuad(vertexConsumer, quaternion, x, y, z, tickPercent);
    }

    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public DefaultFactory(SpriteSet provider) {
            this.provider = provider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new MistParticle(level, x, y, z, this.provider);
        }
    }
}

