/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigData;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.mixin.access.ParticleEngineAccessor;
import pigcart.particlerain.particle.CustomParticle;
import pigcart.particlerain.particle.StreakParticle;

public final class WeatherParticleManager {
    private static final RandomSource random = RandomSource.create();
    public static ParticleGroup particleGroup = new ParticleGroup(ConfigManager.config.perf.maxParticleAmount);
    private static final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    private static final BlockPos.MutableBlockPos heightmapPos = new BlockPos.MutableBlockPos();
    public static int afterWeatherTicksLeft = 0;
    private static int spawnAttemptsUntilBlockFXIdle = 0;
    private static int ticksUntilSurfaceFXIdle = 0;
    private static int ticksUntilSkyFXIdle = 0;

    public static int getParticleCount() {
        ParticleEngineAccessor particleEngine = (ParticleEngineAccessor)Minecraft.getInstance().particleEngine;
        return particleEngine.getTrackedParticleCounts().getInt((Object)particleGroup);
    }

    public static void tick(ClientLevel level, Vec3 cameraPos) {
        WeatherParticleManager.tickSkyFX(level, cameraPos);
        WeatherParticleManager.tickSurfaceFX(level, cameraPos);
        if (afterWeatherTicksLeft > 0) {
            --afterWeatherTicksLeft;
        }
    }

    public static void onWeatherChange(boolean isRaining, boolean wasRaining) {
        afterWeatherTicksLeft = !isRaining && wasRaining ? 6000 : 0;
    }

    public static void tickBlockFX(BlockPos.MutableBlockPos sourcePos, BlockState state) {
        ClientLevel level = Minecraft.getInstance().level;
        if (spawnAttemptsUntilBlockFXIdle <= 0 && random.nextFloat() < 0.9f) {
            return;
        }
        --spawnAttemptsUntilBlockFXIdle;
        if (!state.getCollisionShape((BlockGetter)level, (BlockPos)sourcePos).isEmpty()) {
            return;
        }
        for (ConfigData.ParticleData opts : ConfigManager.config.particles) {
            Vector3f relativePos;
            Direction direction;
            if (!opts.enabled || !opts.weather.isCurrent(level)) continue;
            Holder biome = level.getBiome((BlockPos)sourcePos);
            switch (opts.spawnPos) {
                case BLOCK_SIDES: {
                    Direction direction2 = Direction.Plane.HORIZONTAL.getRandomDirection(random);
                    break;
                }
                case BLOCK_BOTTOM: {
                    Direction direction2 = Direction.DOWN;
                    break;
                }
                case BLOCK_TOP: {
                    Direction direction2 = Direction.UP;
                    break;
                }
                default: {
                    Direction direction2 = direction = null;
                }
            }
            if (direction == null) continue;
            Direction opposite = direction.getOpposite();
            pos.set(sourcePos.getX() + opposite.getStepX(), sourcePos.getY() + opposite.getStepY(), sourcePos.getZ() + opposite.getStepZ());
            BlockState blockState = level.getBlockState((BlockPos)pos);
            FluidState fluidState = blockState.getFluidState();
            if (blockState.getCollisionShape((BlockGetter)level, (BlockPos)pos).isEmpty() && fluidState.isEmpty() || opts.spawnPos != ConfigData.SpawnPos.BLOCK_BOTTOM && opts.spawnPos != ConfigData.SpawnPos.BLOCK_SIDES && opts.spawnPos != ConfigData.SpawnPos.BLOCK_TOP || !opts.precipitation.contains(VersionUtil.getPrecipitationAt((Level)level, (Holder<Biome>)biome, (BlockPos)sourcePos)) || !(opts.density > random.nextFloat()) || !opts.biomeList.contains(biome) || !opts.blockList.contains(level.getBlockState((BlockPos)pos).getBlockHolder()) || opts.needsSkyAccess && sourcePos.getY() < level.getHeight(Heightmap.Types.MOTION_BLOCKING, sourcePos.getX(), sourcePos.getZ())) continue;
            float p1 = random.nextFloat();
            float p2 = random.nextFloat();
            if (direction.getAxisDirection().equals((Object)Direction.AxisDirection.POSITIVE)) {
                double max = blockState.getCollisionShape((BlockGetter)level, (BlockPos)pos).max(direction.getAxis(), (double)p1, (double)p2);
                if (direction == Direction.UP) {
                    max = Math.max(max, (double)fluidState.getHeight((BlockGetter)level, (BlockPos)pos));
                }
                if (max == Double.NEGATIVE_INFINITY) continue;
                relativePos = new Vector3f(p2 - 0.5f, (float)(max += 0.01) - 0.5f, p1 - 0.5f);
            } else {
                double min = blockState.getCollisionShape((BlockGetter)level, (BlockPos)pos).min(direction.getAxis(), (double)p1, (double)p2);
                if (min == Double.POSITIVE_INFINITY) continue;
                relativePos = new Vector3f(p2 - 0.5f, (float)(min -= 0.01) - 0.5f, p1 - 0.5f);
            }
            relativePos.rotate((Quaternionfc)(switch (direction) {
                default -> throw new MatchException(null, null);
                case Direction.UP, Direction.DOWN -> new Quaternionf();
                case Direction.SOUTH, Direction.NORTH -> new Quaternionf().rotationXYZ(1.5707964f, 1.5707964f, 0.0f);
                case Direction.EAST, Direction.WEST -> new Quaternionf().rotationXYZ(-1.5707964f, 0.0f, -1.5707964f);
            }));
            float x = (float)pos.getX() + relativePos.x + 0.5f;
            float y = (float)pos.getY() + relativePos.y + 0.5f;
            float z = (float)pos.getZ() + relativePos.z + 0.5f;
            if (opts.usePresetParticle) {
                if (opts.presetParticleId.equals("particlerain:streak")) {
                    Minecraft.getInstance().particleEngine.add((Particle)new StreakParticle(level, x, y, z, direction, opts.blockList));
                } else {
                    level.addParticle(opts.presetParticle, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
                }
            } else {
                Minecraft.getInstance().particleEngine.add((Particle)new CustomParticle(level, x, y, z, opts));
            }
            spawnAttemptsUntilBlockFXIdle = 10000;
        }
    }

    public static void tickSkyFX(ClientLevel level, Vec3 cameraPos) {
        float speed;
        int density;
        ParticleEngineAccessor particleEngine = (ParticleEngineAccessor)Minecraft.getInstance().particleEngine;
        if (!particleEngine.callHasSpaceInParticleLimit(particleGroup)) {
            return;
        }
        if (ticksUntilSkyFXIdle <= 0) {
            density = 4;
            speed = 0.0f;
        } else {
            --ticksUntilSkyFXIdle;
            density = (int)((float)Mth.lerpInt((float)level.getThunderLevel(1.0f), (int)ConfigManager.config.perf.particleDensity, (int)ConfigManager.config.perf.particleStormDensity) * level.getRainLevel(1.0f));
            speed = (float)Minecraft.getInstance().getCameraEntity().getDeltaMovement().length();
            density = (int)((float)density * (1.0f + speed));
        }
        for (int i = 0; i < density; ++i) {
            float height;
            if ((double)speed < 0.8) {
                height = Mth.abs((float)(Mth.square((float)random.nextFloat()) - Mth.square((float)random.nextFloat()))) * -1.0f + 1.0f;
                height *= 1.0f;
            } else {
                height = random.nextFloat();
            }
            float theta = (float)Math.PI * 2 * random.nextFloat();
            float phi = (float)Math.acos(2.0f * height - 1.0f);
            float x = (float)ConfigManager.config.perf.particleDistance * Mth.sin((float)phi) * Mth.cos((float)theta) + (float)cameraPos.x;
            float y = (float)ConfigManager.config.perf.particleDistance * Mth.cos((float)phi) + (float)cameraPos.y;
            float z = (float)ConfigManager.config.perf.particleDistance * Mth.sin((float)phi) * Mth.sin((float)theta) + (float)cameraPos.z;
            if (ConfigManager.config.compat.doSpawnHeightLimit) {
                int cloudHeight;
                int n = cloudHeight = ConfigManager.config.compat.spawnHeightLimit == 0 ? VersionUtil.getCloudHeight(level) : ConfigManager.config.compat.spawnHeightLimit;
                if (cloudHeight != 0 && y > (float)cloudHeight) {
                    y = cloudHeight;
                }
            }
            pos.set((double)x, (double)y, (double)z);
            int heightmapY = level.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX(), pos.getZ());
            heightmapPos.set((double)x, (double)(heightmapY - 1), (double)z);
            if (heightmapY > pos.getY()) continue;
            Holder biome = level.getBiome((BlockPos)pos);
            Biome.Precipitation precipitation = VersionUtil.getPrecipitationAt((Level)level, (Holder<Biome>)biome, (BlockPos)(ConfigManager.config.compat.useHeightmapTemp ? heightmapPos : pos));
            for (ConfigData.ParticleData data : ConfigManager.config.particles) {
                if (!data.enabled || !data.spawnPos.equals((Object)ConfigData.SpawnPos.SKY) || !data.weather.isCurrent(level) || !data.precipitation.contains(precipitation) || !(data.density > random.nextFloat()) || !data.biomeList.contains(biome) || !data.blockList.contains(level.getBlockState((BlockPos)heightmapPos).getBlockHolder())) continue;
                if (data.usePresetParticle) {
                    level.addParticle(data.presetParticle, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
                } else {
                    Minecraft.getInstance().particleEngine.add((Particle)new CustomParticle(level, x, y, z, data));
                }
                ticksUntilSkyFXIdle = 100;
            }
        }
    }

    public static void tickSurfaceFX(ClientLevel level, Vec3 cameraPos) {
        int density;
        if (ticksUntilSurfaceFXIdle <= 0) {
            density = 1;
        } else {
            density = ConfigManager.config.perf.particleDensity;
            --ticksUntilSurfaceFXIdle;
        }
        for (int i = 0; i < density; ++i) {
            double x = random.triangle(cameraPos.x, (double)ConfigManager.config.perf.surfaceRange);
            double z = random.triangle(cameraPos.z, (double)ConfigManager.config.perf.surfaceRange);
            int y = level.getHeight(Heightmap.Types.MOTION_BLOCKING, (int)x, (int)z);
            pos.set(x, (double)(y - 1), z);
            BlockState blockState = level.getBlockState((BlockPos)pos);
            Holder biome = level.getBiome((BlockPos)pos);
            Biome.Precipitation precipitation = VersionUtil.getPrecipitationAt((Level)level, (Holder<Biome>)biome, (BlockPos)pos);
            for (ConfigData.ParticleData data : ConfigManager.config.particles) {
                if (!data.enabled || !data.spawnPos.equals((Object)ConfigData.SpawnPos.WORLD_SURFACE) || !data.weather.isCurrent(level) || !data.precipitation.contains(precipitation) || !(data.density > random.nextFloat()) || !data.biomeList.contains(biome) || !data.blockList.contains(blockState.getBlockHolder())) continue;
                if (data.usePresetParticle) {
                    level.addParticle(data.presetParticle, x, (double)y, z, 0.0, 0.0, 0.0);
                } else {
                    Minecraft.getInstance().particleEngine.add((Particle)new CustomParticle(level, x, y, z, data));
                }
                ticksUntilSurfaceFXIdle = 100;
            }
        }
    }
}

