/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.WeatherParticleManager;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.config.ConfigScreens;

public class ParticleRain {
    public static int clientTicks = 0;
    public static final String MOD_ID = "particlerain";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"particlerain");
    public static SimpleParticleType MIST;
    public static SimpleParticleType SHRUB;
    public static SimpleParticleType RIPPLE;
    public static SimpleParticleType STREAK;
    public static Set<String> particleConfigIds;
    public static SoundEvent WEATHER_SNOW;
    public static SoundEvent WEATHER_SNOW_ABOVE;
    public static SoundEvent WEATHER_SANDSTORM;
    public static SoundEvent WEATHER_SANDSTORM_ABOVE;

    public static void onInitializeClient() {
        ConfigManager.load();
        WEATHER_SNOW = ParticleRain.createSoundEvent("weather.snow");
        WEATHER_SNOW_ABOVE = ParticleRain.createSoundEvent("weather.snow.above");
        WEATHER_SANDSTORM = ParticleRain.createSoundEvent("weather.sandstorm");
        WEATHER_SANDSTORM_ABOVE = ParticleRain.createSoundEvent("weather.sandstorm.above");
    }

    public static void onTick(Minecraft client) {
        Camera camera = client.gameRenderer.getMainCamera();
        if (!client.isPaused() && client.level != null && camera.isInitialized()) {
            ++clientTicks;
            WeatherParticleManager.tick(client.level, camera.getPosition());
        }
    }

    private static SoundEvent createSoundEvent(String name) {
        ResourceLocation id = VersionUtil.getId(MOD_ID, name);
        return SoundEvent.createVariableRangeEvent((ResourceLocation)id);
    }

    public static <S> LiteralArgumentBuilder<S> getCommands() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)MOD_ID).executes(ctx -> {
            VersionUtil.schedule(() -> Minecraft.getInstance().setScreen(ConfigScreens.generateMainConfigScreen(null)));
            return 0;
        })).then(LiteralArgumentBuilder.literal((String)"debug").executes(ctx -> {
            ClientLevel level = Minecraft.getInstance().level;
            ParticleRain.addChatMsg(String.format("Particle count: %d/%d", WeatherParticleManager.getParticleCount(), WeatherParticleManager.particleGroup.getLimit()));
            BlockPos blockPos = BlockPos.containing((Position)Minecraft.getInstance().player.position());
            Holder holder = level.getBiome(blockPos);
            String biomeStr = (String)holder.unwrap().map(resourceKey -> resourceKey.location().toString(), biome -> "[unregistered " + String.valueOf(biome) + "]");
            ParticleRain.addChatMsg("Biome: " + biomeStr);
            Biome.Precipitation precipitation = VersionUtil.getPrecipitationAt((Level)level, (Holder<Biome>)holder, blockPos);
            ParticleRain.addChatMsg("Precipitation: " + String.valueOf(precipitation));
            ParticleRain.addChatMsg("Base Temp: " + ((Biome)holder.value()).getBaseTemperature());
            ParticleRain.addChatMsg("Cloud height: " + VersionUtil.getCloudHeight(level));
            ParticleRain.addChatMsg("sea level: " + Minecraft.getInstance().level.getSeaLevel());
            ParticleRain.addChatMsg(ConfigManager.config.particles.toString());
            return 0;
        }));
    }

    private static void addChatMsg(String message) {
        Minecraft.getInstance().gui.getChat().addMessage((Component)Component.literal((String)message));
    }

    public static void doAdditionalWeatherSounds(ClientLevel level, BlockPos cameraPos, BlockPos rainPos, CallbackInfo ci) {
        BlockState state;
        SoundType soundType;
        if (ConfigManager.config.compat.doSpawnHeightLimit) {
            int cloudHeight;
            int n = cloudHeight = ConfigManager.config.compat.spawnHeightLimit == 0 ? VersionUtil.getCloudHeight(level) : ConfigManager.config.compat.spawnHeightLimit;
            if (rainPos.getY() > cloudHeight) {
                ci.cancel();
                return;
            }
        }
        boolean above = rainPos.getY() > cameraPos.getY() + 1 && level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, cameraPos).getY() > Mth.floor((float)cameraPos.getY());
        Holder biome = level.getBiome(rainPos);
        Biome.Precipitation precipitation = VersionUtil.getPrecipitationAt((Level)level, (Holder<Biome>)biome, rainPos);
        if (precipitation == Biome.Precipitation.SNOW && ConfigManager.config.sound.snowVolume > 0.0f) {
            SoundEvent sound = above ? WEATHER_SNOW_ABOVE : WEATHER_SNOW;
            level.playLocalSound(rainPos, sound, SoundSource.WEATHER, ConfigManager.config.sound.snowVolume, above ? 0.5f : 1.0f, false);
        } else if (precipitation == Biome.Precipitation.NONE && (double)((Biome)biome.value()).getBaseTemperature() > 0.25 && ConfigManager.config.sound.windVolume > 0.0f) {
            SoundEvent sound = above ? WEATHER_SANDSTORM_ABOVE : WEATHER_SANDSTORM;
            level.playLocalSound(rainPos, sound, SoundSource.WEATHER, ConfigManager.config.sound.windVolume, above ? 0.5f : 1.0f, false);
        } else if (ConfigManager.config.sound.blockVolume > 0.0f && !(soundType = (state = level.getBlockState(rainPos)).getSoundType()).equals(SoundType.STONE)) {
            if (state.is(Blocks.NOTE_BLOCK)) {
                SoundEvent sound = (SoundEvent)((NoteBlockInstrument)state.getValue((Property)NoteBlock.INSTRUMENT)).getSoundEvent().value();
                float pitch = NoteBlock.getPitchFromNote((int)level.random.nextInt(24));
                level.playLocalSound(rainPos, sound, SoundSource.WEATHER, ConfigManager.config.sound.blockVolume, above ? pitch / 2.0f : pitch, false);
            } else {
                SoundEvent sound = soundType.getHitSound();
                level.playLocalSound(rainPos, sound, SoundSource.WEATHER, ConfigManager.config.sound.blockVolume, above ? 0.5f : 1.5f, false);
            }
        }
        if (ConfigManager.config.sound.rainVolume == 0.0f || !precipitation.equals((Object)Biome.Precipitation.RAIN)) {
            ci.cancel();
        }
    }

    static {
        particleConfigIds = Set.of("shrub", "ripple", "streak", "mist");
    }
}

