/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.config.cloth;

import ca.fxco.moreculling.api.config.ConfigAdditions;
import ca.fxco.moreculling.api.config.OptionOverride;
import ca.fxco.moreculling.config.cloth.AbstractDynamicEntry;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDynamicBuilder<T, A extends AbstractConfigListEntry<T>, SELF extends FieldBuilder<T, A, SELF>>
extends FieldBuilder<T, A, SELF> {
    @Nullable
    protected Consumer<T> saveConsumer = null;
    @Nullable
    protected BiConsumer<AbstractDynamicEntry<T>, T> changeConsumer = null;
    @NotNull
    protected Function<T, Optional<Component[]>> tooltipSupplier = bool -> Optional.empty();
    private T value = null;
    private boolean locked = false;
    private final String translationKey;

    protected AbstractDynamicBuilder(String translationKey) {
        this(translationKey, (Component)Component.translatable((String)"text.cloth-config.reset_value"));
    }

    protected AbstractDynamicBuilder(String translationKey, Component resetButtonKey) {
        super(resetButtonKey, (Component)Component.translatable((String)translationKey));
        this.translationKey = translationKey;
    }

    protected final T getValue() {
        return this.value;
    }

    protected final boolean getLocked() {
        return this.locked;
    }

    protected final void setLocked(boolean locked) {
        this.locked = locked;
    }

    public AbstractDynamicBuilder<T, A, ?> setModIncompatibility(boolean isLoaded, String modId) {
        if (isLoaded) {
            this.setTooltip(new Component[]{Component.translatable((String)"moreculling.config.optionDisabled", (Object[])new Object[]{modId})});
            if (this.defaultValue != null && this.value != null && this.defaultValue.get() != this.value) {
                this.value = this.defaultValue.get();
            }
            this.locked = true;
            this.saveConsumer = null;
            this.changeConsumer = null;
            this.requireRestart(false);
        }
        return this;
    }

    public AbstractDynamicBuilder<T, A, ?> setModLimited(boolean isLoaded, Component limitedMessage) {
        if (isLoaded) {
            Optional<Component[]> currentTooltips = this.tooltipSupplier.apply(this.value);
            if (currentTooltips.isEmpty()) {
                this.setTooltip(limitedMessage);
            } else {
                Component[] tooltips = currentTooltips.get();
                Component[] newArray = new Component[tooltips.length + 1];
                System.arraycopy(tooltips, 0, newArray, 0, tooltips.length);
                newArray[tooltips.length] = limitedMessage;
                this.setTooltip(newArray);
            }
        }
        return this;
    }

    public AbstractDynamicBuilder<T, A, ?> setValue(T value) {
        Objects.requireNonNull(value);
        this.value = value;
        return this;
    }

    public AbstractDynamicBuilder<T, A, ?> setErrorSupplier(@Nullable Function<T, Optional<Component>> errorSupplier) {
        this.errorSupplier = errorSupplier;
        return this;
    }

    public AbstractDynamicBuilder<T, A, ?> requireRestart() {
        if (!this.locked) {
            this.requireRestart(true);
        }
        return this;
    }

    public AbstractDynamicBuilder<T, A, ?> setSaveConsumer(Consumer<T> saveConsumer) {
        if (!this.locked) {
            this.saveConsumer = saveConsumer;
        }
        return this;
    }

    public AbstractDynamicBuilder<T, A, ?> setChangeConsumer(BiConsumer<AbstractDynamicEntry<T>, T> changeConsumer) {
        if (!this.locked) {
            this.changeConsumer = changeConsumer;
        }
        return this;
    }

    public AbstractDynamicBuilder<T, A, ?> setDefaultValue(Supplier<T> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public AbstractDynamicBuilder<T, A, ?> setDefaultValue(T defaultValue) {
        this.defaultValue = () -> defaultValue;
        return this;
    }

    public AbstractDynamicBuilder<T, A, ?> setTooltip(Component ... tooltip) {
        if (!this.locked) {
            this.tooltipSupplier = val -> Optional.ofNullable(tooltip);
        }
        return this;
    }

    public AbstractDynamicBuilder<T, A, ?> setTooltipSupplier(@NotNull Function<T, Optional<Component[]>> tooltipSupplier) {
        if (!this.locked) {
            this.tooltipSupplier = tooltipSupplier;
        }
        return this;
    }

    public AbstractDynamicBuilder<T, A, ?> setTooltipSupplier(@NotNull Supplier<Optional<Component[]>> tooltipSupplier) {
        if (!this.locked) {
            this.tooltipSupplier = val -> (Optional)tooltipSupplier.get();
        }
        return this;
    }

    @NotNull
    public final A build() {
        Objects.requireNonNull(this.value);
        OptionOverride optionOverride = ConfigAdditions.getDisabledOptions().get(this.translationKey);
        if (optionOverride != null && !optionOverride.canChange().getAsBoolean()) {
            this.setTooltip(new Component[]{Component.literal((String)optionOverride.reason())});
            if (this.defaultValue != null && this.value != null && this.defaultValue.get() != this.value) {
                this.value = this.defaultValue.get();
            }
            this.locked = true;
            this.requireRestart(false);
        }
        return this.runBuild();
    }

    public abstract A runBuild();
}

