/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.misc;

import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.events.EarlyPackReloadEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.misc.IProgressTracker;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import org.jetbrains.annotations.Nullable;

public class ReloadInstanceWrapper
implements ReloadInstance {
    private final Supplier<ReloadInstance> lazyInstance;
    private final CompletableFuture<Unit> beforeTask;
    private final IProgressTracker.Tree progressTracker = IProgressTracker.createTree(1);

    public static ReloadInstance wrap(Supplier<ReloadInstance> factory, PackType type, ResourceManager manager, Executor backgroundExecutor, Collection<PackResources> selectedPacks) {
        return new ReloadInstanceWrapper(factory, type, manager, backgroundExecutor, selectedPacks);
    }

    public static void executeEarlyReloadBlocking(PackType type, ResourceManager manager, IProgressTracker progressTracker, Collection<PackResources> selectedPacks) {
        MoonlightEventsHelper.postEvent(new EarlyPackReloadEvent(selectedPacks, manager, type, progressTracker), EarlyPackReloadEvent.class);
    }

    public ReloadInstanceWrapper(Supplier<ReloadInstance> factory, PackType type, ResourceManager manager, Executor executor, Collection<PackResources> selectedPacks) {
        this.lazyInstance = Suppliers.memoize(factory::get);
        this.beforeTask = CompletableFuture.supplyAsync(() -> {
            ReloadInstanceWrapper.executeEarlyReloadBlocking(type, manager, this.progressTracker, selectedPacks);
            return Unit.INSTANCE;
        }, executor);
    }

    @Nullable
    private ReloadInstance allErrorsInPackReloadWillHaveThisLineOnTheirStackTrace_DoesntMeanItsTheCause() {
        if (this.beforeTask.isDone() && !this.beforeTask.isCompletedExceptionally()) {
            return this.lazyInstance.get();
        }
        return null;
    }

    public CompletableFuture<?> done() {
        return this.beforeTask.thenCompose(unused -> {
            ReloadInstance actual = this.allErrorsInPackReloadWillHaveThisLineOnTheirStackTrace_DoesntMeanItsTheCause();
            return actual.done();
        });
    }

    public float getActualProgress() {
        float maxAmount = Mth.clamp((float)0.2f, (float)0.0f, (float)0.5f);
        float progress = this.progressTracker.getProgress();
        if (!this.beforeTask.isDone()) {
            return progress;
        }
        ReloadInstance actual = this.allErrorsInPackReloadWillHaveThisLineOnTheirStackTrace_DoesntMeanItsTheCause();
        if (actual != null) {
            return actual.getActualProgress() * 1.0f;
        }
        return 1.0f;
    }

    public void checkExceptions() {
        ReloadInstance actual;
        if (!this.beforeTask.isDone()) {
            return;
        }
        if (this.beforeTask.isCompletedExceptionally()) {
            this.beforeTask.join();
        }
        if ((actual = this.allErrorsInPackReloadWillHaveThisLineOnTheirStackTrace_DoesntMeanItsTheCause()) != null) {
            actual.checkExceptions();
        }
    }
}

