/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.block;

import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public interface ILightable {
    public static final TagKey<Item> FLINT_AND_STEELS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"tools/igniter"));

    public boolean isLitUp(BlockState var1, BlockGetter var2, BlockPos var3);

    default public void setLitUp(BlockState state, LevelAccessor world, BlockPos pos, boolean lit) {
        this.setLitUp(state, world, pos, null, lit);
    }

    public void setLitUp(BlockState var1, LevelAccessor var2, BlockPos var3, @Nullable Entity var4, boolean var5);

    @Deprecated(forRemoval=true)
    default public boolean lightUp(@Nullable Entity player, BlockState state, BlockPos pos, LevelAccessor world, FireSoundType fireSourceType) {
        return this.tryLightUp(player, state, pos, world, fireSourceType);
    }

    default public boolean tryLightUp(@Nullable Entity player, BlockState state, BlockPos pos, LevelAccessor world, FireSoundType fireSourceType) {
        if (!this.isLitUp(state, (BlockGetter)world, pos)) {
            if (!world.isClientSide()) {
                this.setLitUp(state, world, pos, true);
                this.playLightUpSound(world, pos, fireSourceType);
            }
            world.gameEvent(player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval=true)
    default public boolean extinguish(@Nullable Entity player, BlockState state, BlockPos pos, LevelAccessor world) {
        return this.tryExtinguish(player, state, pos, world);
    }

    default public boolean tryExtinguish(@Nullable Entity player, BlockState state, BlockPos pos, LevelAccessor world) {
        if (this.isLitUp(state, (BlockGetter)world, pos)) {
            if (!world.isClientSide()) {
                this.playExtinguishSound(world, pos);
                this.setLitUp(state, world, pos, false);
            } else {
                this.spawnSmokeParticles(state, pos, world);
            }
            world.gameEvent(player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval=true)
    default public boolean interactWithEntity(Level level, BlockState state, Entity projectile, BlockPos pos) {
        return this.lightableInteractWithEntity(level, state, projectile, pos);
    }

    default public boolean lightableInteractWithEntity(Level level, BlockState state, Entity projectile, BlockPos pos) {
        if (projectile.isOnFire()) {
            Entity owner;
            if (projectile instanceof TraceableEntity) {
                TraceableEntity te = (TraceableEntity)projectile;
                v0 = te.getOwner();
            } else {
                v0 = owner = null;
            }
            if (owner == null || owner instanceof Player || PlatHelper.isMobGriefingOn(level, owner)) {
                return this.tryLightUp(projectile, state, pos, (LevelAccessor)level, FireSoundType.FLAMING_ARROW);
            }
        }
        return false;
    }

    @Deprecated(forRemoval=true)
    default public ItemInteractionResult interactWithPlayerItem(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        return this.lightableInteractWithPlayerItem(state, level, pos, player, hand, stack);
    }

    default public ItemInteractionResult lightableInteractWithPlayerItem(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        if (Utils.mayPerformBlockAction(player, pos, stack)) {
            if (!this.isLitUp(state, (BlockGetter)level, pos)) {
                Item item = stack.getItem();
                if (item instanceof FlintAndSteelItem || stack.is(FLINT_AND_STEELS)) {
                    if (this.tryLightUp((Entity)player, state, pos, (LevelAccessor)level, FireSoundType.FLINT_AND_STEEL)) {
                        stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                    }
                } else if (item instanceof FireChargeItem && this.tryLightUp((Entity)player, state, pos, (LevelAccessor)level, FireSoundType.FIRE_CHANGE)) {
                    stack.consume(1, (LivingEntity)player);
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            } else if (this.canBeExtinguishedBy(stack) && this.tryExtinguish((Entity)player, state, pos, (LevelAccessor)level) && !(stack.getItem() instanceof BrushItem)) {
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    default public boolean canBeExtinguishedBy(ItemStack item) {
        return item.getItem() instanceof ShovelItem || item.getItem() instanceof BrushItem;
    }

    default public void playLightUpSound(LevelAccessor world, BlockPos pos, FireSoundType type) {
        type.play(world, pos);
    }

    default public void playExtinguishSound(LevelAccessor world, BlockPos pos) {
        world.playSound(null, pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 0.5f, 1.5f);
    }

    default public void spawnSmokeParticles(BlockState state, BlockPos pos, LevelAccessor world) {
        RandomSource random = world.getRandom();
        for (int i = 0; i < 10; ++i) {
            world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)pos.getX() + 0.25f + random.nextFloat() * 0.5f), (double)((float)pos.getY() + 0.35f + random.nextFloat() * 0.5f), (double)((float)pos.getZ() + 0.25f + random.nextFloat() * 0.5f), 0.0, 0.005, 0.0);
        }
    }

    @FunctionalInterface
    public static interface FireSoundType {
        public static final FireSoundType FLINT_AND_STEEL = (level, pos) -> level.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
        public static final FireSoundType FIRE_CHANGE = (level, pos) -> level.playSound(null, pos, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, (level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.2f + 1.0f);
        public static final FireSoundType FLAMING_ARROW = (level, pos) -> level.playSound(null, pos, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 0.5f, 1.4f);

        public void play(LevelAccessor var1, BlockPos var2);
    }
}

