/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.neoforge.core.world;

import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.satisfy.wildernature.core.registry.EntityTypeRegistry;
import net.satisfy.wildernature.core.registry.TagsRegistry;
import net.satisfy.wildernature.neoforge.core.registry.WilderNatureBiomeModifiers;

public class AddAnimalsBiomeModifier
implements BiomeModifier {
    private static final Set<EntityType<?>> registeredEntities = new HashSet();

    private static <T extends Mob> void registerEntity(EntityType<T> type, Heightmap.Types heightmapType, SpawnPlacements.SpawnPredicate<T> predicate) {
        if (!registeredEntities.contains(type)) {
            SpawnPlacements.register(type, (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)heightmapType, predicate);
            registeredEntities.add(type);
        }
    }

    public static void registerEntities() {
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityTypeRegistry.SQUIRREL.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityTypeRegistry.OWL.get(), Heightmap.Types.MOTION_BLOCKING, Mob::checkMobSpawnRules);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityTypeRegistry.TURKEY.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityTypeRegistry.RACCOON.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityTypeRegistry.PELICAN.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityTypeRegistry.DEER.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityTypeRegistry.RED_WOLF.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityTypeRegistry.BOAR.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityTypeRegistry.BISON.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityTypeRegistry.DOG.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityTypeRegistry.MINISHEEP.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityTypeRegistry.PENGUIN.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityTypeRegistry.CASSOWARY.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityTypeRegistry.HEDGEHOG.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules);
        AddAnimalsBiomeModifier.registerEntity((EntityType)EntityTypeRegistry.FLAMINGO.get(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules);
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase.equals((Object)BiomeModifier.Phase.ADD)) {
            AddAnimalsBiomeModifier.registerEntities();
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_DEER, (EntityType)EntityTypeRegistry.DEER.get(), 12, 2, 4);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_RACCOON, (EntityType)EntityTypeRegistry.RACCOON.get(), 8, 2, 3);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_SQUIRREL, (EntityType)EntityTypeRegistry.SQUIRREL.get(), 8, 2, 2);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_RED_WOLF, (EntityType)EntityTypeRegistry.RED_WOLF.get(), 10, 3, 4);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_OWL, (EntityType)EntityTypeRegistry.OWL.get(), 12, 3, 3);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_BOAR, (EntityType)EntityTypeRegistry.BOAR.get(), 14, 5, 5);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_BISON, (EntityType)EntityTypeRegistry.BISON.get(), 10, 3, 5);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_TURKEY, (EntityType)EntityTypeRegistry.TURKEY.get(), 12, 3, 5);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_PELICAN, (EntityType)EntityTypeRegistry.PELICAN.get(), 5, 3, 4);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_DOG, (EntityType)EntityTypeRegistry.DOG.get(), 4, 1, 1);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_MINISHEEP, (EntityType)EntityTypeRegistry.MINISHEEP.get(), 8, 2, 4);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_PENGUIN, (EntityType)EntityTypeRegistry.PENGUIN.get(), 10, 2, 5);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_CASSOWARY, (EntityType)EntityTypeRegistry.CASSOWARY.get(), 12, 3, 4);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_HEDGEHOG, (EntityType)EntityTypeRegistry.HEDGEHOG.get(), 9, 2, 3);
            this.addMobSpawn(builder, biome, TagsRegistry.SPAWNS_FLAMINGO, (EntityType)EntityTypeRegistry.FLAMINGO.get(), 10, 4, 6);
            this.addMobSpawn(builder, biome, (TagKey<Biome>)BiomeTags.IS_JUNGLE, EntityType.FROG, 8, 3, 4);
        }
    }

    void addMobSpawn(ModifiableBiomeInfo.BiomeInfo.Builder builder, Holder<Biome> biome, TagKey<Biome> tag, EntityType<?> entityType, int weight, int minGroupSize, int maxGroupSize) {
        if (biome.is(tag)) {
            builder.getMobSpawnSettings().addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(entityType, weight, minGroupSize, maxGroupSize));
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return (MapCodec)WilderNatureBiomeModifiers.ADD_ANIMALS_CODEC.get();
    }
}

