/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.neoforge.client;

import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.satisfy.wildernature.client.WilderNatureClient;
import net.satisfy.wildernature.core.registry.ObjectRegistry;
import net.satisfy.wildernature.neoforge.client.extensions.WilderNatureHatExtensions;
import net.satisfy.wildernature.neoforge.core.player.layer.WolfFurChestplateLayer;
import net.satisfy.wildernature.neoforge.core.player.model.WolfFurChestplateModel;

@EventBusSubscriber(modid="wildernature", value={Dist.CLIENT})
public class WilderNatureClientNeoForge {
    @SubscribeEvent
    public static void onClientSetup(RegisterEvent event) {
        WilderNatureClient.preInitClient();
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        WilderNatureClient.onInitializeClient();
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(WilderNatureClient.WOLF_FUR_CHESTPLATE_LAYER, WolfFurChestplateModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void constructLayers(EntityRenderersEvent.AddLayers event) {
        WilderNatureClientNeoForge.addLayerToPlayerSkin(event, "default", WolfFurChestplateLayer::new);
        WilderNatureClientNeoForge.addLayerToPlayerSkin(event, "slim", WolfFurChestplateLayer::new);
    }

    private static <E extends Player, M extends HumanoidModel<E>> void addLayerToPlayerSkin(EntityRenderersEvent.AddLayers event, String skinName, Function<LivingEntityRenderer<E, M>, ? extends RenderLayer<E, M>> factory) {
        LivingEntityRenderer renderer = (LivingEntityRenderer)event.getSkin(PlayerSkin.Model.byName((String)skinName));
        if (renderer != null) {
            renderer.addLayer(factory.apply(renderer));
        }
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem((IClientItemExtensions)new WilderNatureHatExtensions(), new Item[]{(Item)ObjectRegistry.STYLIN_PURPLE_HAT.get()});
    }
}

