/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.neoforge;

import dev.architectury.platform.hooks.EventBusesHooks;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.core.registry.ObjectRegistry;
import net.satisfy.wildernature.core.util.Truffling;
import net.satisfy.wildernature.neoforge.core.registry.WilderNatureBiomeModifiers;
import net.satisfy.wildernature.neoforge.core.registry.WilderNatureConfig;

@Mod(value="wildernature")
public class WilderNatureNeoForge {
    public WilderNatureNeoForge(IEventBus modEventBus, ModContainer modContainer) {
        EventBusesHooks.whenAvailable((String)"wildernature", IEventBus::start);
        WilderNature.init();
        WilderNatureBiomeModifiers.BIOME_MODIFIER_SERIALIZERS.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)WilderNatureConfig.COMMON_CONFIG);
        modEventBus.addListener(WilderNatureConfig::onLoad);
        modEventBus.addListener(WilderNatureConfig::onReload);
        NeoForge.EVENT_BUS.addListener(this::registerFuel);
        NeoForge.EVENT_BUS.addListener(this::onFoodEating);
    }

    private void registerFuel(FurnaceFuelBurnTimeEvent event) {
        if (event.getItemStack().getItem() == ObjectRegistry.FISH_OIL.get()) {
            event.setBurnTime(1600);
        }
    }

    private void onFoodEating(LivingEntityUseItemEvent event) {
        LivingEntity player = event.getEntity();
        if (!Truffling.isTruffled(player.getItemInHand(player.getUsedItemHand()))) {
            return;
        }
        Truffling.FoodValue add = Truffling.getAdditionalFoodValue();
        FoodProperties props = (FoodProperties)player.getItemInHand(player.getUsedItemHand()).get(DataComponents.FOOD);
        if (props != null) {
            props.nutrition = props.nutrition() + (int)((float)props.nutrition() * 0.2f) + add.nutrition();
            props.saturation = props.saturation() + props.saturation() * 0.2f + add.saturationModifier();
        }
    }
}

