/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.item;

import java.util.ArrayList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.satisfy.wildernature.core.registry.ObjectRegistry;
import net.satisfy.wildernature.core.registry.TagsRegistry;
import org.jetbrains.annotations.NotNull;

public class LootBagItem
extends Item {
    public LootBagItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack spawnedItem;
        if (world.isClientSide || user.isCrouching()) {
            return super.use(world, user, hand);
        }
        ItemStack itemStack = user.getItemInHand(hand);
        int randomNumber = world.random.nextInt(10000);
        if (randomNumber < 5) {
            spawnedItem = new ItemStack((ItemLike)Items.DIAMOND);
        } else if (randomNumber < 105) {
            spawnedItem = new ItemStack((ItemLike)Items.EMERALD);
        } else if (randomNumber < 2105) {
            spawnedItem = new ItemStack((ItemLike)ObjectRegistry.HAZELNUT.get());
        } else {
            ArrayList<Item> edibleItems = new ArrayList<Item>();
            for (Item item : BuiltInRegistries.ITEM) {
                if (!item.getDefaultInstance().has(DataComponents.FOOD) || item.builtInRegistryHolder().is(TagsRegistry.LOOT_BAG_BLACKLIST)) continue;
                edibleItems.add(item);
            }
            spawnedItem = !edibleItems.isEmpty() ? new ItemStack((ItemLike)edibleItems.get(world.random.nextInt(edibleItems.size()))) : new ItemStack((ItemLike)Items.APPLE);
        }
        world.addFreshEntity((Entity)new ItemEntity(world, user.getX(), user.getY(), user.getZ(), spawnedItem));
        if (!user.isCreative()) {
            itemStack.shrink(1);
        }
        world.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.BUNDLE_INSERT, SoundSource.PLAYERS, 1.0f, 1.0f);
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
    }
}

