/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.entity.ai;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.satisfy.wildernature.core.entity.ai.BetterFollowOwnerGoal;

public class FlyingFollowOwnerGoal
extends BetterFollowOwnerGoal {
    public FlyingFollowOwnerGoal(TamableAnimal tameable, double speed, float minDistance, float maxDistance, boolean leavesAllowed) {
        super(tameable, speed, minDistance, maxDistance, leavesAllowed);
    }

    @Override
    protected void startFollowing() {
        this.navigation.moveTo((Entity)this.owner, this.owner.isFallFlying() ? (double)1.2f : this.speed);
    }

    @Override
    protected boolean canTeleportTo(BlockPos pos) {
        PathType pathNodeType = WalkNodeEvaluator.getPathTypeStatic((Mob)this.tameable, (BlockPos)pos.mutable());
        if (pathNodeType != PathType.WALKABLE && pathNodeType != PathType.OPEN) {
            return false;
        }
        BlockState blockState = this.level.getBlockState(pos.below());
        if (!this.leavesAllowed && blockState.getBlock() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockPos = pos.subtract((Vec3i)this.tameable.getOnPos());
        return this.level.noCollision((Entity)this.tameable, this.tameable.getBoundingBox().move(blockPos));
    }
}

