/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.entity;

import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.DoorInteractGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.satisfy.wildernature.core.entity.ai.RandomAction;
import net.satisfy.wildernature.core.entity.ai.RandomActionGoal;
import net.satisfy.wildernature.core.entity.animation.ServerAnimationDurations;
import net.satisfy.wildernature.core.registry.EntityTypeRegistry;
import net.satisfy.wildernature.core.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RaccoonEntity
extends Animal {
    private static final Ingredient FOOD_ITEMS;
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID;
    private static final EntityDataAccessor<Integer> DATA_FLAGS_ID;
    private static final int FLAG_WASHING = 2;
    private static final int FLAG_RUNNING = 256;
    private static final int FLAG_OPENDOOR = 4096;
    public final AnimationState walkState = new AnimationState();
    public final AnimationState runState = new AnimationState();
    public final AnimationState washingState = new AnimationState();
    public final AnimationState openDoorState = new AnimationState();
    public int openDoorAnimationTimeout = 0;
    private int ticksSinceEaten;
    private int washTicks;

    public RaccoonEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.getBoundingBox().deflate(1.0);
        this.getNavigation().setCanFloat(true);
        this.getNavigation().getNodeEvaluator().setCanOpenDoors(true);
        this.getNavigation().getNodeEvaluator().setCanPassDoors(true);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.20000001192092895).add(Attributes.MAX_HEALTH, 6.0).add(Attributes.ATTACK_DAMAGE, 1.5);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_TYPE_ID, (Object)0);
        builder.define(DATA_FLAGS_ID, (Object)0);
    }

    protected void registerGoals() {
        int i = 0;
        this.goalSelector.addGoal(++i, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(++i, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.goalSelector.addGoal(++i, (Goal)new RaccoonDoorInteractGoal(this));
        this.goalSelector.addGoal(++i, new RaccoonAvoidEntityGoal<Player>(this, Player.class));
        this.goalSelector.addGoal(++i, new RaccoonAvoidEntityGoal<Villager>(this, Villager.class));
        this.goalSelector.addGoal(++i, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(++i, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)FOOD_ITEMS, false));
        this.goalSelector.addGoal(++i, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(++i, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(++i, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(++i, (Goal)new RandomActionGoal(new RandomAction(){

            @Override
            public boolean isInterruptable() {
                return true;
            }

            @Override
            public void onStop() {
                RaccoonEntity.this.stopWash();
            }

            @Override
            public void onStart() {
                RaccoonEntity.this.startWash();
            }

            @Override
            public boolean isPossible() {
                return !RaccoonEntity.this.isRaccoonRunning();
            }

            @Override
            public int duration() {
                return 48;
            }

            @Override
            public float chance() {
                return 0.01f;
            }

            @Override
            public AttributeInstance getAttribute(Attribute movementSpeed) {
                return RaccoonEntity.this.getAttribute(BuiltInRegistries.ATTRIBUTE.wrapAsHolder((Object)movementSpeed));
            }
        }));
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.openDoorState.animateWhen(this.isOpeningDoor(), this.tickCount);
            this.washingState.animateWhen(this.isWashing(), this.tickCount);
        }
    }

    private boolean isOpeningDoor() {
        return this.getFlag(4096);
    }

    public void aiStep() {
        if (!this.level().isClientSide && this.isAlive() && this.isEffectiveAi()) {
            ++this.ticksSinceEaten;
            ItemStack itemStack = this.getItemBySlot(EquipmentSlot.MAINHAND);
            if (this.isFood(itemStack)) {
                if (this.ticksSinceEaten > 600) {
                    ItemStack itemStack2 = itemStack.finishUsingItem(this.level(), (LivingEntity)this);
                    if (!itemStack2.isEmpty()) {
                        this.setItemSlot(EquipmentSlot.MAINHAND, itemStack2);
                    }
                    this.ticksSinceEaten = 0;
                } else if (this.ticksSinceEaten > 560 && this.random.nextFloat() < 0.1f) {
                    this.playSound(this.getEatingSound(itemStack), 1.0f, 1.0f);
                    this.level().broadcastEntityEvent((Entity)this, (byte)45);
                }
            }
        }
        if (this.isSleeping() || this.isImmobile()) {
            this.jumping = false;
            this.xxa = 0.0f;
            this.zza = 0.0f;
        }
        super.aiStep();
        if (this.isDefending() && this.random.nextFloat() < 0.05f) {
            this.playSound((SoundEvent)SoundRegistry.RACCOON_AMBIENT.get(), 1.0f, 1.0f);
        } else {
            this.washTicks = 0;
        }
    }

    public void refreshDimensions() {
        super.refreshDimensions();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.RACCOON_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.RACCOON_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.RACCOON_DEATH.get();
    }

    @Nullable
    public RaccoonEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (RaccoonEntity)((EntityType)EntityTypeRegistry.RACCOON.get()).create((Level)serverLevel);
    }

    boolean isDefending() {
        return this.getFlag(128);
    }

    public boolean isSleeping() {
        return this.getFlag(32);
    }

    private void setFlag(int i, boolean bl) {
        if (bl) {
            this.entityData.set(DATA_FLAGS_ID, (Object)((Integer)this.entityData.get(DATA_FLAGS_ID) | i));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (Object)((Integer)this.entityData.get(DATA_FLAGS_ID) & ~i));
        }
    }

    private boolean getFlag(int i) {
        return ((Integer)this.entityData.get(DATA_FLAGS_ID) & i) != 0;
    }

    public boolean isFood(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    public void startWash() {
        this.setFlag(2, true);
    }

    public void stopWash() {
        this.setFlag(2, false);
    }

    public boolean isWashing() {
        return this.getFlag(2);
    }

    public boolean isRaccoonRunning() {
        return this.getFlag(256);
    }

    public void startRunningAnim() {
        this.setFlag(256, true);
    }

    public void stopRunningAnim() {
        this.setFlag(256, false);
    }

    public void startOpenDoorAnim() {
        this.setFlag(4096, true);
    }

    public void stopOpenDoorAnim() {
        this.setFlag(4096, false);
    }

    static {
        DATA_TYPE_ID = SynchedEntityData.defineId(RaccoonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        DATA_FLAGS_ID = SynchedEntityData.defineId(RaccoonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        FOOD_ITEMS = Ingredient.of((ItemLike[])new ItemLike[]{Items.APPLE, Items.BEETROOT, Items.SWEET_BERRIES, Items.POTATO, Items.COOKED_COD, Items.COOKED_SALMON, Items.CARROT});
    }

    public static class RaccoonDoorInteractGoal
    extends DoorInteractGoal {
        private final RaccoonEntity raccoon;
        public static final AttributeModifier modifier = new AttributeModifier(ResourceLocation.parse((String)"racoon_door_do_not_move"), -1000.0, AttributeModifier.Operation.ADD_VALUE);
        int counter = 0;

        public RaccoonDoorInteractGoal(RaccoonEntity raccoon) {
            super((Mob)raccoon);
            this.raccoon = raccoon;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean canUse() {
            return super.canUse();
        }

        public void start() {
            this.counter = 0;
            Objects.requireNonNull(this.raccoon.getAttribute(Attributes.MOVEMENT_SPEED)).addTransientModifier(modifier);
            super.start();
            this.raccoon.startOpenDoorAnim();
        }

        public boolean canContinueToUse() {
            return this.counter > 0 && this.counter < ServerAnimationDurations.raccoon_opening_door_length && (!this.isOpen() || this.counter >= ServerAnimationDurations.raccoon_opening_door_tick);
        }

        public void tick() {
            this.raccoon.level().getBlockState(this.doorPos).getShape((BlockGetter)this.raccoon.level().getChunk(this.doorPos), this.doorPos).bounds().getCenter();
            if (this.canContinueToUse()) {
                this.raccoon.startOpenDoorAnim();
            } else {
                this.raccoon.stopOpenDoorAnim();
            }
            if (this.counter < ServerAnimationDurations.raccoon_opening_door_length) {
                ++this.counter;
            }
            if (this.counter == ServerAnimationDurations.raccoon_opening_door_tick) {
                this.setOpen(true);
            }
            if (this.counter == ServerAnimationDurations.raccoon_opening_door_length) {
                super.tick();
            }
        }

        public void stop() {
            Objects.requireNonNull(this.raccoon.getAttribute(Attributes.MOVEMENT_SPEED)).removeModifier(modifier);
            this.counter = 0;
            super.stop();
            this.setOpen(true);
            this.raccoon.stopOpenDoorAnim();
        }
    }

    public static class RaccoonAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final RaccoonEntity raccoon;

        public RaccoonAvoidEntityGoal(RaccoonEntity raccoon, Class<T> tClass) {
            super((PathfinderMob)raccoon, tClass, 16.0f, 2.0, 2.0);
            this.raccoon = raccoon;
        }

        public void start() {
            this.raccoon.startRunningAnim();
            super.start();
        }

        public void stop() {
            this.raccoon.stopRunningAnim();
            super.stop();
        }
    }
}

