/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.entity;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.satisfy.wildernature.core.entity.ai.AnimationAttackGoal;
import net.satisfy.wildernature.core.entity.ai.EntityWithAttackAnimation;
import net.satisfy.wildernature.core.entity.animation.ServerAnimationDurations;
import net.satisfy.wildernature.core.registry.EntityTypeRegistry;
import net.satisfy.wildernature.core.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PelicanEntity
extends Animal
implements EntityWithAttackAnimation {
    private static final Ingredient FOOD_ITEMS;
    private static final EntityDataAccessor<Boolean> ATTACKING;
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.random.nextInt(40) + 80;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
        this.attackAnimationState.animateWhen(this.isAttacking(), this.tickCount);
    }

    protected void updateWalkAnimation(float pPartialTick) {
        float f = this.getPose() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f, 0.2f);
    }

    @Override
    public void setAttacking_(boolean attacking) {
        this.entityData.set(ATTACKING, (Object)attacking);
    }

    @Override
    public Vec3 getPosition_(int i) {
        return super.getPosition((float)i);
    }

    @Override
    public void doHurtTarget_(LivingEntity targetEntity) {
        super.doHurtTarget((Entity)targetEntity);
    }

    public boolean isAttacking() {
        return (Boolean)this.entityData.get(ATTACKING);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTACKING, (Object)false);
    }

    @Override
    public LivingEntity getTarget_() {
        return this.getTarget();
    }

    @Override
    public double getMeleeAttackRangeSqr_(LivingEntity entity) {
        return this.distanceToSqr((Entity)entity);
    }

    public PelicanEntity(EntityType<? extends PelicanEntity> entityType, Level level) {
        super(entityType, level);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.MOVEMENT_SPEED, 0.22).add(Attributes.ATTACK_DAMAGE, 0.5).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_SPEED, 1.0);
    }

    protected void registerGoals() {
        int i = 0;
        this.goalSelector.addGoal(++i, (Goal)new AnimationAttackGoal(this, 1.0, true, (int)(ServerAnimationDurations.turkey_attack + 2.0f), 8));
        this.goalSelector.addGoal(++i, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(++i, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(++i, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)FOOD_ITEMS, false));
        this.goalSelector.addGoal(++i, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(++i, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(++i, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(++i, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.PELICAN_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.PELICAN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.PELICAN_DEATH.get();
    }

    protected void playStepSound(BlockPos blockPos, BlockState blockState) {
        this.playSound(SoundEvents.CHICKEN_STEP, 0.15f, 1.0f);
    }

    @Nullable
    public PelicanEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (PelicanEntity)((EntityType)EntityTypeRegistry.PELICAN.get()).create((Level)serverLevel);
    }

    public boolean isFood(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    static {
        ATTACKING = SynchedEntityData.defineId(PelicanEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        FOOD_ITEMS = Ingredient.of((ItemLike[])new ItemLike[]{Items.COD, Items.SALMON, Items.PUFFERFISH, Items.COOKED_COD, Items.COOKED_SALMON});
    }
}

