/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.entity;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.satisfy.wildernature.core.entity.ai.AnimationAttackGoal;
import net.satisfy.wildernature.core.entity.ai.EntityWithAttackAnimation;
import net.satisfy.wildernature.core.entity.ai.FlyingFollowOwnerGoal;
import net.satisfy.wildernature.core.entity.ai.PredicateTemptGoal;
import net.satisfy.wildernature.core.entity.ai.RandomAction;
import net.satisfy.wildernature.core.entity.ai.RandomActionGoal;
import net.satisfy.wildernature.core.entity.animation.ServerAnimationDurations;
import net.satisfy.wildernature.core.registry.EntityTypeRegistry;
import net.satisfy.wildernature.core.registry.SoundRegistry;
import net.satisfy.wildernature.core.registry.TagsRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OwlEntity
extends ShoulderRidingEntity
implements EntityWithAttackAnimation {
    private static final EntityDataAccessor<Integer> STANDING_STATE = SynchedEntityData.defineId(OwlEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> OWL_STATE = SynchedEntityData.defineId(OwlEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(OwlEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HOOTING = SynchedEntityData.defineId(OwlEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.defineId(OwlEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDimensions FLYING_DIMENSION = EntityDimensions.fixed((float)0.7f, (float)1.4f);
    private static final Predicate<LivingEntity> IS_OWL_TARGET = e -> e.getType().is(TagsRegistry.OWL_TARGETS);
    private float leaningPitch;
    private float lastLeaningPitch;
    public AnimationState flyingState = new AnimationState();
    public AnimationState hootState = new AnimationState();
    public AnimationState attackState = new AnimationState();
    public AnimationState sleepState = new AnimationState();

    public OwlEntity(EntityType<? extends ShoulderRidingEntity> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 0, false);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Mob.createMobAttributes().add(Attributes.FLYING_SPEED, 0.8).add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        int i = 0;
        this.goalSelector.addGoal(++i, (Goal)new AvoidEntityGoal<Player>((PathfinderMob)this, Player.class, 32.0f, 2.0, 2.0){

            public boolean canUse() {
                return super.canUse() && OwlEntity.this.isInPanicRightNow();
            }
        });
        this.goalSelector.addGoal(++i, (Goal)new PanicGoal(this, (PathfinderMob)this, 1.75){

            protected boolean findRandomPosition() {
                Vec3 vec3 = DefaultRandomPos.getPos((PathfinderMob)this.mob, (int)20, (int)20);
                if (vec3 == null) {
                    return false;
                }
                this.posX = vec3.x;
                this.posY = vec3.y;
                this.posZ = vec3.z;
                return true;
            }
        });
        this.goalSelector.addGoal(++i, (Goal)new SleepGoal(this));
        this.goalSelector.addGoal(++i, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(++i, (Goal)new FloatGoal((Mob)this){

            public boolean canUse() {
                return super.canUse() && !OwlEntity.this.isSleeping();
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && !OwlEntity.this.isSleeping();
            }
        });
        this.goalSelector.addGoal(++i, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(++i, (Goal)new AnimationAttackGoal(this, 1.0, true, (int)ServerAnimationDurations.owl_attack * 20, 15){

            public boolean canUse() {
                return super.canUse() && !OwlEntity.this.isSleeping();
            }

            @Override
            public boolean canContinueToUse() {
                return super.canContinueToUse() && !OwlEntity.this.isSleeping();
            }
        });
        this.goalSelector.addGoal(++i, (Goal)new FlyingFollowOwnerGoal((TamableAnimal)this, 1.2, 10.0f, 2.0f, true){

            @Override
            public boolean canUse() {
                return super.canUse() && !OwlEntity.this.isSleeping();
            }

            @Override
            public boolean canContinueToUse() {
                return super.canContinueToUse() && !OwlEntity.this.isSleeping();
            }
        });
        this.goalSelector.addGoal(++i, (Goal)new PredicateTemptGoal((PathfinderMob)this, 1.2, this::isFood, false){

            @Override
            public boolean canUse() {
                return super.canUse() && !OwlEntity.this.isSleeping();
            }

            @Override
            public boolean canContinueToUse() {
                return super.canContinueToUse() && !OwlEntity.this.isSleeping();
            }
        });
        this.goalSelector.addGoal(++i, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(++i, (Goal)new ExtendedFlyOntoTree((PathfinderMob)this, 1.0, 0.5f));
        this.goalSelector.addGoal(++i, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(++i, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(++i, (Goal)new RandomActionGoal(new RandomAction(){

            @Override
            public boolean isInterruptable() {
                return false;
            }

            @Override
            public void onStop() {
                OwlEntity.this.setHooting(false);
            }

            @Override
            public void onStart() {
                if (OwlEntity.this.onGround()) {
                    OwlEntity.this.setHooting(true);
                }
                SoundEvent owlSound = (SoundEvent)SoundRegistry.OWL_AMBIENT.get();
                OwlEntity.this.level().playSound(null, (Entity)OwlEntity.this, owlSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }

            @Override
            public boolean isPossible() {
                return !OwlEntity.this.isAttacking() && !OwlEntity.this.isSleeping();
            }

            @Override
            public int duration() {
                return (int)(ServerAnimationDurations.owl_hoot * 20.0f);
            }

            @Override
            public float chance() {
                return 0.01f;
            }

            @Override
            public AttributeInstance getAttribute(Attribute movementSpeed) {
                return OwlEntity.this.getAttribute(BuiltInRegistries.ATTRIBUTE.wrapAsHolder((Object)movementSpeed));
            }
        }));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, LivingEntity.class, false, IS_OWL_TARGET));
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        OwlEntity owl = (OwlEntity)((EntityType)EntityTypeRegistry.OWL.get()).create((Level)serverLevel);
        UUID uUID = this.getOwnerUUID();
        if (uUID != null) {
            assert (owl != null);
            owl.setOwnerUUID(uUID);
            owl.setTame(true, true);
        }
        return owl;
    }

    @NotNull
    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, level);
        birdNavigation.setCanPassDoors(true);
        birdNavigation.setCanFloat(false);
        birdNavigation.setCanOpenDoors(false);
        return birdNavigation;
    }

    public float getSwimAmount(float f) {
        return Mth.rotLerp((float)f, (float)this.lastLeaningPitch, (float)this.leaningPitch);
    }

    public void tick() {
        super.tick();
        this.setStandingState(this.onGround() || this.isInWater() || this.isOrderedToSit() ? StandingState.STANDING : StandingState.FLYING);
        this.lastLeaningPitch = this.leaningPitch;
        switch (this.getStandingState().ordinal()) {
            case 0: {
                this.leaningPitch = Math.max(0.0f, this.leaningPitch - 2.0f);
                break;
            }
            case 1: {
                this.leaningPitch = Math.min(7.0f, this.leaningPitch + 1.5f);
            }
        }
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        StandingState standingState = this.getStandingState();
        OwlState owlState = this.getOwlState();
        this.flyingState.animateWhen(standingState == StandingState.FLYING, this.tickCount);
        this.attackState.animateWhen(this.isAttacking(), this.tickCount);
        this.hootState.animateWhen(this.isHooting(), this.tickCount);
        this.sleepState.animateWhen(this.isSleeping(), this.tickCount);
    }

    private boolean isHooting() {
        return (Boolean)this.entityData.get(HOOTING);
    }

    private void setHooting(boolean hooting) {
        this.entityData.set(HOOTING, (Object)hooting);
    }

    public void aiStep() {
        super.aiStep();
        Vec3 velocity = this.getDeltaMovement();
        if (!this.onGround() && velocity.y < 0.0) {
            this.setDeltaMovement(velocity.multiply(1.0, 0.75, 1.0));
        }
    }

    public void setTame(boolean tamed, boolean flag) {
        super.setTame(tamed, flag);
        if (tamed) {
            Objects.requireNonNull(this.getAttribute(Attributes.MAX_HEALTH)).setBaseValue(20.0);
            Objects.requireNonNull(this.getAttribute(Attributes.ATTACK_DAMAGE)).setBaseValue(4.0);
            this.setHealth(20.0f);
        } else {
            Objects.requireNonNull(this.getAttribute(Attributes.MAX_HEALTH)).setBaseValue(6.0);
            Objects.requireNonNull(this.getAttribute(Attributes.ATTACK_DAMAGE)).setBaseValue(2.0);
        }
    }

    @NotNull
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (this.isTame()) {
            if (this.isFood(stack) && this.getHealth() < this.getMaxHealth()) {
                if (!this.level().isClientSide()) {
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    this.heal(((FoodProperties)item.getDefaultInstance().getOrDefault(DataComponents.FOOD, (Object)Foods.CARROT)).nutrition());
                }
                return InteractionResult.SUCCESS;
            }
            InteractionResult actionResult = super.mobInteract(player, hand);
            if ((!actionResult.consumesAction() || this.isBaby()) && this.isOwnedBy((LivingEntity)player)) {
                if (!this.level().isClientSide()) {
                    this.setOrderedToSit(!this.isOrderedToSit());
                    this.jumping = false;
                    this.navigation.stop();
                    this.setTarget(null);
                }
                return InteractionResult.SUCCESS;
            }
            return actionResult;
        }
        if (this.isFood(stack) && this.getTarget() == null) {
            if (!this.level().isClientSide()) {
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                if (this.random.nextInt(3) == 0) {
                    this.tame(player);
                    this.navigation.stop();
                    this.setTarget(null);
                    this.setOrderedToSit(true);
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public boolean isFood(ItemStack stack) {
        return stack.has(DataComponents.FOOD) && stack.get(DataComponents.FOOD) != null && stack.is(ItemTags.MEAT);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("OwlState", ((Integer)this.getEntityData().get(OWL_STATE)).intValue());
        tag.putInt("StandingState", ((Integer)this.getEntityData().get(STANDING_STATE)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setOwlState(OwlState.values()[tag.getInt("OwlState")]);
        this.setStandingState(StandingState.values()[tag.getInt("StandingState")]);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STANDING_STATE, (Object)0);
        builder.define(OWL_STATE, (Object)0);
        builder.define(ATTACKING, (Object)false);
        builder.define(HOOTING, (Object)false);
        builder.define(SLEEPING, (Object)false);
    }

    public boolean causeFallDamage(float f, float g, DamageSource damageSource) {
        return false;
    }

    protected void checkFallDamage(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
    }

    public StandingState getStandingState() {
        return StandingState.values()[(Integer)this.getEntityData().get(STANDING_STATE)];
    }

    public void setStandingState(StandingState standingState) {
        this.getEntityData().set(STANDING_STATE, (Object)standingState.ordinal());
    }

    public OwlState getOwlState() {
        return OwlState.values()[(Integer)this.getEntityData().get(OWL_STATE)];
    }

    public void setOwlState(OwlState owlState) {
        this.getEntityData().set(OWL_STATE, (Object)owlState.ordinal());
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.OWL_DEATH.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return null;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.OWL_HURT.get();
    }

    @Override
    public LivingEntity getTarget_() {
        return this.getTarget();
    }

    @Override
    public double getMeleeAttackRangeSqr_(LivingEntity target) {
        return this.distanceToSqr((Entity)target);
    }

    @Override
    public void setAttacking_(boolean b) {
        this.entityData.set(ATTACKING, (Object)b);
    }

    public boolean isAttacking() {
        return (Boolean)this.entityData.get(ATTACKING);
    }

    @Override
    public Vec3 getPosition_(int i) {
        return super.getPosition((float)i);
    }

    @Override
    public void doHurtTarget_(LivingEntity targetEntity) {
        super.doHurtTarget((Entity)targetEntity);
    }

    private void setSleeping(boolean b) {
        this.entityData.set(SLEEPING, (Object)b);
    }

    public boolean isInPanicRightNow() {
        return this.getLastHurtByMob() != null || this.isOnFire();
    }

    public boolean isSleeping() {
        return (Boolean)this.entityData.get(SLEEPING);
    }

    private static class SleepGoal
    extends Goal {
        private final OwlEntity owl;

        public SleepGoal(OwlEntity owlEntity) {
            this.owl = owlEntity;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean canUse() {
            return this.owl.level().isDay() && !this.owl.isInPanicRightNow();
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }

        public boolean isInterruptable() {
            return false;
        }

        public void start() {
            super.start();
            this.owl.setSleeping(true);
        }

        public void tick() {
            super.tick();
        }

        public void stop() {
            super.stop();
            this.owl.setSleeping(false);
        }
    }

    private static class ExtendedFlyOntoTree
    extends WaterAvoidingRandomStrollGoal {
        public ExtendedFlyOntoTree(PathfinderMob pathAwareEntity, double speed, float probability) {
            super(pathAwareEntity, speed, probability);
        }

        protected Vec3 getPosition() {
            Vec3 vec3d = null;
            if (this.mob.isInWaterOrBubble()) {
                vec3d = LandRandomPos.getPos((PathfinderMob)this.mob, (int)15, (int)7);
            }
            if (this.mob.getRandom().nextFloat() >= this.probability) {
                vec3d = this.getTreeTarget();
            }
            return vec3d == null ? super.getPosition() : vec3d;
        }

        private Vec3 getTreeTarget() {
            BlockState blockState;
            boolean bl;
            BlockPos blockPos2;
            BlockPos blockPos = this.mob.getOnPos();
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos mutable2 = new BlockPos.MutableBlockPos();
            Iterable iterable = BlockPos.betweenClosed((int)Mth.floor((double)(this.mob.getX() - 3.0)), (int)Mth.floor((double)(this.mob.getY() - 6.0)), (int)Mth.floor((double)(this.mob.getZ() - 3.0)), (int)Mth.floor((double)(this.mob.getX() + 3.0)), (int)Mth.floor((double)(this.mob.getY() + 6.0)), (int)Mth.floor((double)(this.mob.getZ() + 3.0)));
            Iterator var5 = iterable.iterator();
            do {
                if (var5.hasNext()) continue;
                return null;
            } while (blockPos.equals((Object)(blockPos2 = (BlockPos)var5.next())) || !(bl = (blockState = this.mob.level().getBlockState((BlockPos)mutable2.setWithOffset((Vec3i)blockPos2, Direction.DOWN))).getBlock() instanceof LeavesBlock || blockState.is(BlockTags.LOGS)) || !this.mob.level().isEmptyBlock(blockPos2) || !this.mob.level().isEmptyBlock((BlockPos)mutable.setWithOffset((Vec3i)blockPos2, Direction.UP)));
            return Vec3.atBottomCenterOf((Vec3i)blockPos2);
        }
    }

    public static enum StandingState {
        STANDING,
        FLYING;

    }

    public static enum OwlState {
        IDLE,
        ATTACKING;

    }
}

