/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.entity;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.satisfy.wildernature.core.entity.ai.AnimationAttackGoal;
import net.satisfy.wildernature.core.entity.ai.EntityWithAttackAnimation;
import net.satisfy.wildernature.core.entity.animation.ServerAnimationDurations;
import net.satisfy.wildernature.core.registry.EntityTypeRegistry;
import net.satisfy.wildernature.core.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BisonEntity
extends Animal
implements EntityWithAttackAnimation {
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.defineId(BisonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(BisonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ROLLING = SynchedEntityData.defineId(BisonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.defineId(BisonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Long> LAST_HURT_TIME = SynchedEntityData.defineId(BisonEntity.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public AnimationState rollingAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;

    public BisonEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.SHORT_GRASS);
    }

    @NotNull
    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 28.0).add(Attributes.ATTACK_DAMAGE, 1.5).add(Attributes.ATTACK_SPEED, 1.25).add(Attributes.MOVEMENT_SPEED, 0.18000099062919617).add(Attributes.ARMOR_TOUGHNESS, 0.01777747832238674).add(Attributes.ATTACK_KNOCKBACK, 2.0);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
        if (this.isAngry() && this.level().getGameTime() - this.getLastHurtTime() > 300L) {
            this.setAngry(false);
        }
        if (!this.level().isClientSide()) {
            Vec3 dv = this.getDeltaMovement();
            if (this.isSprinting() && dv.horizontalDistanceSqr() > 0.003) {
                ServerLevel server = (ServerLevel)this.level();
                BlockState state = this.level().getBlockState(this.getOnPos());
                double len = Math.sqrt(dv.x * dv.x + dv.z * dv.z);
                if (len > 1.0E-4) {
                    double nx = dv.x / len;
                    double nz = dv.z / len;
                    double bx = this.getX() - nx * 0.6;
                    double by = this.getY() + 0.1;
                    double bz = this.getZ() - nz * 0.6;
                    server.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), bx, by, bz, 40, (double)this.getBbWidth() * 0.4, 0.05, (double)this.getBbWidth() * 0.4, 0.12);
                    server.sendParticles((ParticleOptions)ParticleTypes.CLOUD, bx, by + 0.05, bz, 12, 0.25, 0.01, 0.25, 0.01);
                }
            }
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.random.nextInt(40) + 80;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
        this.attackAnimationState.animateWhen(this.isAttacking(), this.tickCount);
        this.rollingAnimationState.animateWhen(this.isRolling(), this.tickCount);
    }

    private boolean isRolling() {
        return (Boolean)this.entityData.get(ROLLING);
    }

    protected void updateWalkAnimation(float pPartialTick) {
        float f = this.getPose() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f, 0.2f);
    }

    public boolean isAttacking() {
        return (Boolean)this.entityData.get(ATTACKING);
    }

    @Override
    public LivingEntity getTarget_() {
        return this.getTarget();
    }

    @Override
    public double getMeleeAttackRangeSqr_(LivingEntity target) {
        return this.distanceToSqr((Entity)target);
    }

    @Override
    public void setAttacking_(boolean attacking) {
        this.entityData.set(ATTACKING, (Object)attacking);
    }

    @Override
    public Vec3 getPosition_(int i) {
        return super.getPosition((float)i);
    }

    @Override
    public void doHurtTarget_(LivingEntity targetEntity) {
        super.doHurtTarget((Entity)targetEntity);
    }

    public boolean isAngry() {
        return (Boolean)this.entityData.get(ANGRY);
    }

    public void setAngry(boolean angry) {
        this.entityData.set(ANGRY, (Object)angry);
    }

    public long getLastHurtTime() {
        return (Long)this.entityData.get(LAST_HURT_TIME);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTACKING, (Object)false);
        builder.define(ROLLING, (Object)false);
        builder.define(ANGER_TIME, (Object)0);
        builder.define(ANGRY, (Object)false);
        builder.define(LAST_HURT_TIME, (Object)0L);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AnimationAttackGoal(this, 1.0, true, (int)(ServerAnimationDurations.bison_attack * 20.0f), 5));
        this.goalSelector.addGoal(1, (Goal)new BisonPanicGoal(this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 12.0f, 1.35, 1.6));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Creeper.class, 10.0f, 1.35, 1.6));
        this.goalSelector.addGoal(2, (Goal)new BisonHerdRunGoal(this));
        this.goalSelector.addGoal(2, (Goal)new BisonRollingGoal(this));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.SHORT_GRASS}), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(5, (Goal)new BisonHerdAwareStrollGoal(this, 1.0, 20, 16.0f));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(8, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
        this.goalSelector.addGoal(9, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, false));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)EntityTypeRegistry.BISON.get()).create((Level)pLevel);
    }

    protected SoundEvent getAmbientSound() {
        return this.isAngry() ? (SoundEvent)SoundRegistry.BISON_ANGRY.get() : (SoundEvent)SoundRegistry.BISON_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.BISON_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.BISON_DEATH.get();
    }

    public int getMaxHeadYRot() {
        return 35;
    }

    public void setRolling(boolean rolling) {
        this.entityData.set(ROLLING, (Object)rolling);
    }

    static class BisonPanicGoal
    extends PanicGoal {
        public BisonPanicGoal(BisonEntity bison) {
            super((PathfinderMob)bison, 1.2);
        }

        public boolean canUse() {
            return this.mob.isBaby() && super.canUse();
        }
    }

    public static class BisonHerdRunGoal
    extends Goal {
        private static final Map<ResourceKey<Level>, List<Wave>> WAVES = new HashMap<ResourceKey<Level>, List<Wave>>();
        private final BisonEntity target;
        private int duration;
        private int recalc;
        private int scanCooldown;
        private Vec3 heading;

        public BisonHerdRunGoal(BisonEntity mob) {
            this.target = mob;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.target.getTarget() != null) {
                return false;
            }
            if (this.target.isBaby()) {
                return false;
            }
            if (((Boolean)this.target.entityData.get(ROLLING)).booleanValue()) {
                return false;
            }
            if (!this.target.level().getBiome(this.target.blockPosition()).is(BiomeTags.IS_SAVANNA)) {
                return false;
            }
            if (this.consumeWave()) {
                return true;
            }
            if (this.scanCooldown > 0) {
                --this.scanCooldown;
                return false;
            }
            this.scanCooldown = 40 + this.target.getRandom().nextInt(40);
            boolean randomTrigger = this.target.getRandom().nextFloat() < 0.04f;
            AABB box = this.target.getBoundingBox().inflate(12.0, 4.0, 12.0);
            List herd = this.target.level().getEntitiesOfClass(BisonEntity.class, box, e -> e != this.target && !e.isAngry() && (Boolean)((BisonEntity)e).entityData.get(ROLLING) == false);
            boolean neighborFast = false;
            for (Object b : herd) {
                if (!(b.getDeltaMovement().horizontalDistanceSqr() > 0.03)) continue;
                neighborFast = true;
                break;
            }
            if (!neighborFast && !randomTrigger && herd.size() < 3) {
                return false;
            }
            Vec3 v = Vec3.ZERO;
            for (BisonEntity b : herd) {
                Vec3 dv = b.getDeltaMovement();
                v = v.add(dv.x, 0.0, dv.z);
            }
            if (v.lengthSqr() < 0.001) {
                float a = this.target.getRandom().nextFloat() * ((float)Math.PI * 2);
                v = new Vec3((double)Mth.cos((float)a), 0.0, (double)Mth.sin((float)a));
            } else {
                v = v.normalize();
            }
            long now = this.target.level().getGameTime();
            BisonHerdRunGoal.addWave((ResourceKey<Level>)this.target.level().dimension(), new Wave(this.target.position(), v, now + 2L, now + 140L, 12.0));
            return false;
        }

        private boolean consumeWave() {
            ResourceKey key = this.target.level().dimension();
            List<Wave> list = WAVES.get(key);
            if (list == null) {
                return false;
            }
            long now = this.target.level().getGameTime();
            Vec3 bestDir = null;
            double bestD2 = Double.MAX_VALUE;
            Iterator<Wave> it = list.iterator();
            while (it.hasNext()) {
                Wave w = it.next();
                if (w.until < now) {
                    it.remove();
                    continue;
                }
                double d2 = w.pos.distanceToSqr(this.target.position());
                if (!(d2 <= w.radius * w.radius) || now < w.start || !(d2 < bestD2)) continue;
                bestD2 = d2;
                bestDir = w.dir;
            }
            if (bestDir != null) {
                this.heading = bestDir;
                return true;
            }
            return false;
        }

        private static void addWave(ResourceKey<Level> key, Wave w) {
            List list = WAVES.computeIfAbsent(key, k -> new ArrayList());
            list.add(w);
        }

        public void start() {
            this.duration = 80 + this.target.getRandom().nextInt(60);
            this.recalc = 0;
            this.target.setSprinting(true);
        }

        public boolean canContinueToUse() {
            if (this.target.getTarget() != null) {
                return false;
            }
            if (((Boolean)this.target.entityData.get(ROLLING)).booleanValue()) {
                return false;
            }
            return this.duration > 0 && this.target.level().getBiome(this.target.blockPosition()).is(BiomeTags.IS_SAVANNA);
        }

        public void tick() {
            --this.duration;
            --this.recalc;
            if (this.recalc <= 0) {
                this.recalc = 10;
                Vec3 ahead = this.target.position().add(this.heading.scale(12.0));
                this.target.getNavigation().moveTo(ahead.x, ahead.y, ahead.z, 1.6);
            }
        }

        public void stop() {
            this.target.setSprinting(false);
            this.target.getNavigation().stop();
        }

        private static final class Wave {
            final Vec3 pos;
            final Vec3 dir;
            final long start;
            final long until;
            final double radius;

            Wave(Vec3 pos, Vec3 dir, long start, long until, double radius) {
                this.pos = pos;
                this.dir = dir;
                this.start = start;
                this.until = until;
                this.radius = radius;
            }
        }
    }

    public static class BisonRollingGoal
    extends Goal {
        private final BisonEntity target;
        int counter;
        private final List<BlockPos> toConvert = new ArrayList<BlockPos>();
        private boolean conversionDone;
        public static final AttributeModifier modifier = new AttributeModifier(ResourceLocation.parse((String)"bison_roll_do_not_move"), -1000.0, AttributeModifier.Operation.ADD_VALUE);

        public BisonRollingGoal(BisonEntity mob) {
            this.target = mob;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean isInterruptable() {
            return false;
        }

        public boolean canUse() {
            float r = this.target.getRandom().nextFloat();
            return r < 0.001f && !this.target.isAngry();
        }

        public boolean canContinueToUse() {
            return this.counter > 0 && (float)this.counter < ServerAnimationDurations.bison_roll * 20.0f;
        }

        public void tick() {
            ++this.counter;
            if (!this.target.level().isClientSide()) {
                if (!this.conversionDone && this.counter == 1) {
                    for (BlockPos p : this.toConvert) {
                        BlockState s = this.target.level().getBlockState(p);
                        if (s.is(Blocks.GRASS_BLOCK)) {
                            this.target.level().setBlock(p, Blocks.DIRT.defaultBlockState(), 3);
                            continue;
                        }
                        if (!s.is(Blocks.DIRT)) continue;
                        this.target.level().setBlock(p, Blocks.COARSE_DIRT.defaultBlockState(), 3);
                    }
                    this.conversionDone = true;
                }
                ServerLevel server = (ServerLevel)this.target.level();
                BlockState state = this.target.level().getBlockState(this.target.getOnPos());
                server.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), this.target.getX(), this.target.getY() + 0.2, this.target.getZ(), 40, (double)this.target.getBbWidth() * 0.6, 0.1, (double)this.target.getBbWidth() * 0.6, 0.15);
            }
        }

        public void start() {
            this.counter = 0;
            this.conversionDone = false;
            this.toConvert.clear();
            Level level = this.target.level();
            if (!level.isClientSide()) {
                BlockPos center = this.target.getOnPos();
                int r = Mth.ceil((float)(this.target.getBbWidth() * 0.5f)) + 1;
                RandomSource rand = this.target.getRandom();
                for (int dx = -r; dx <= r; ++dx) {
                    for (int dz = -r; dz <= r; ++dz) {
                        BlockPos p;
                        BlockState s;
                        if (!(rand.nextFloat() < 0.33333334f) || !(s = level.getBlockState(p = center.offset(dx, 0, dz))).is(Blocks.GRASS_BLOCK) && !s.is(Blocks.DIRT)) continue;
                        this.toConvert.add(p.immutable());
                    }
                }
            }
            Objects.requireNonNull(this.target.getAttribute(Attributes.MOVEMENT_SPEED)).addTransientModifier(modifier);
            this.target.setRolling(true);
            if (!this.target.level().isClientSide()) {
                ServerLevel server = (ServerLevel)this.target.level();
                BlockState state = this.target.level().getBlockState(this.target.getOnPos());
                server.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), this.target.getX(), this.target.getY() + 0.1, this.target.getZ(), 80, (double)this.target.getBbWidth(), 0.2, (double)this.target.getBbWidth(), 0.2);
                server.sendParticles((ParticleOptions)ParticleTypes.CLOUD, this.target.getX(), this.target.getY() + 0.3, this.target.getZ(), 24, 0.6, 0.03, 0.6, 0.02);
            }
            super.start();
        }

        public void stop() {
            Objects.requireNonNull(this.target.getAttribute(Attributes.MOVEMENT_SPEED)).removeModifier(modifier);
            this.target.setRolling(false);
            if (!this.target.level().isClientSide()) {
                ServerLevel server = (ServerLevel)this.target.level();
                server.sendParticles((ParticleOptions)ParticleTypes.CLOUD, this.target.getX(), this.target.getY() + 0.4, this.target.getZ(), 18, 0.25, 0.02, 0.25, 0.02);
            }
            super.stop();
        }
    }

    public static class BisonHerdAwareStrollGoal
    extends Goal {
        private final BisonEntity mob;
        private final double speed;
        private final int interval;
        private final float herdRadius;
        private Vec3 wanted;

        public BisonHerdAwareStrollGoal(BisonEntity mob, double speed, int interval, float herdRadius) {
            this.mob = mob;
            this.speed = speed;
            this.interval = interval;
            this.herdRadius = herdRadius;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            Vec3 dir;
            if (this.mob.getTarget() != null) {
                return false;
            }
            if (((Boolean)this.mob.entityData.get(ROLLING)).booleanValue()) {
                return false;
            }
            if (this.mob.isAngry()) {
                return false;
            }
            if (!this.mob.getNavigation().isDone()) {
                return false;
            }
            if (this.mob.getRandom().nextInt(this.interval) != 0) {
                return false;
            }
            AABB box = this.mob.getBoundingBox().inflate((double)this.herdRadius, 4.0, (double)this.herdRadius);
            List herd = this.mob.level().getEntitiesOfClass(BisonEntity.class, box, e -> e != this.mob && !e.isAngry() && (Boolean)((BisonEntity)e).entityData.get(ROLLING) == false);
            if (herd.size() >= 2) {
                double dz;
                double cx = 0.0;
                double cz = 0.0;
                for (BisonEntity b : herd) {
                    cx += b.getX();
                    cz += b.getZ();
                }
                cx /= (double)herd.size();
                cz /= (double)herd.size();
                double dx = cx - this.mob.getX();
                double d2 = dx * dx + (dz = cz - this.mob.getZ()) * dz;
                if (d2 > 100.0) {
                    double inv = Math.sqrt(d2);
                    dir = new Vec3(dx / inv, 0.0, dz / inv);
                } else {
                    float a = this.mob.getRandom().nextFloat() * ((float)Math.PI * 2);
                    Vec3 randDir = new Vec3((double)Mth.cos((float)a), 0.0, (double)Mth.sin((float)a));
                    double inv = Math.sqrt(d2);
                    Vec3 toCenter = inv > 1.0E-4 ? new Vec3(dx / inv, 0.0, dz / inv) : randDir;
                    dir = randDir.scale(0.4).add(toCenter.scale(0.6)).normalize();
                }
            } else {
                float a = this.mob.getRandom().nextFloat() * ((float)Math.PI * 2);
                dir = new Vec3((double)Mth.cos((float)a), 0.0, (double)Mth.sin((float)a));
            }
            double dist = 6.0 + (double)this.mob.getRandom().nextInt(7);
            this.wanted = this.mob.position().add(dir.scale(dist));
            return true;
        }

        public void start() {
            this.mob.getNavigation().moveTo(this.wanted.x, this.wanted.y, this.wanted.z, this.speed);
        }

        public boolean canContinueToUse() {
            return false;
        }
    }
}

