/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.core.entity.TermiteEntity;
import net.satisfy.wildernature.core.entity.animation.TermiteAnimation;
import org.jetbrains.annotations.NotNull;

public class TermiteModel
extends HierarchicalModel<TermiteEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WilderNature.identifier("termite"), "main");
    private final ModelPart termite;

    public TermiteModel(ModelPart root) {
        this.termite = root.getChild("termite");
        ModelPart torso = this.termite.getChild("torso");
        ModelPart antennae = torso.getChild("antennae");
        ModelPart rightArm = this.termite.getChild("rightArm");
        ModelPart leftArm = this.termite.getChild("leftArm");
        ModelPart rightLeg = this.termite.getChild("rightLeg");
        ModelPart leftLeg = this.termite.getChild("leftLeg");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition termite = partdefinition.addOrReplaceChild("termite", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)21.2f, (float)1.25f));
        PartDefinition torso = termite.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.5f, -1.55f, -2.25f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 6).addBox(-1.0f, -0.55f, -3.25f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)-1.0f));
        PartDefinition antennae = torso.addOrReplaceChild("antennae", CubeListBuilder.create().texOffs(-3, 11).addBox(-1.5f, -0.0924f, -3.0383f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.45f, (float)-3.25f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = termite.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(0, 10).mirror().addBox(-1.9826f, -0.0985f, -0.5f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(3, 6).addBox(-1.9826f, -0.0985f, 2.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)2.551f, (float)-2.75f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftArm = termite.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(0, 10).addBox(-1.0174f, -0.0985f, -0.5f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(3, 6).mirror().addBox(-1.0174f, -0.0985f, 2.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.5f, (float)2.551f, (float)-2.75f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition rightLeg = termite.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(1, 10).addBox(-2.0f, 0.0f, -0.5f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)2.451f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftLeg = termite.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(1, 10).mirror().addBox(-1.0174f, -0.0985f, 0.75f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.5f, (float)2.551f, (float)-2.75f, (float)0.0f, (float)0.0f, (float)0.1745f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    @NotNull
    public ModelPart root() {
        return this.termite;
    }

    public void setupAnim(TermiteEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        float move = (float)entity.getDeltaMovement().horizontalDistance();
        float amount = Math.min(1.0f, limbSwingAmount * 2.2f + move * 6.0f);
        this.animateWalk(TermiteAnimation.WALK, limbSwing, amount, 2.6f, 2.0f);
        this.animate(entity.idleAnimationState, TermiteAnimation.IDLE, ageInTicks, 1.0f);
    }
}

