/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.satisfy.meadow.client.gui.handler.CheeseFormGuiHandler;
import net.satisfy.meadow.client.gui.handler.CookingCauldronGuiHandler;
import net.satisfy.meadow.client.gui.handler.WoodcutterGuiHandler;

public class ScreenHandlerRegistry {
    public static final DeferredRegister<MenuType<?>> SCREEN_TYPES = DeferredRegister.create((String)"meadow", (ResourceKey)Registries.MENU);
    public static final RegistrySupplier<MenuType<CookingCauldronGuiHandler>> COOKING_CAULDRON_SCREEN_HANDLER = ScreenHandlerRegistry.create("cooking_cauldron", () -> new MenuType(CookingCauldronGuiHandler::new, FeatureFlags.VANILLA_SET));
    public static final RegistrySupplier<MenuType<CheeseFormGuiHandler>> CHEESE_FORM_SCREEN_HANDLER = ScreenHandlerRegistry.create("cheese_form", () -> new MenuType(CheeseFormGuiHandler::new, FeatureFlags.VANILLA_SET));
    public static final RegistrySupplier<MenuType<WoodcutterGuiHandler>> WOODCUTTER_SCREEN_HANDLER = ScreenHandlerRegistry.create("woodcutter", () -> new MenuType(WoodcutterGuiHandler::new, FeatureFlags.VANILLA_SET));

    public static void init() {
        SCREEN_TYPES.register();
    }

    private static <T extends MenuType<?>> RegistrySupplier<T> create(String name, Supplier<T> type) {
        return SCREEN_TYPES.register(name, type);
    }
}

