/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.core.block.LineConnectingBlock;
import net.satisfy.meadow.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class BenchBlock
extends LineConnectingBlock {
    public static final VoxelShape[] TOP_SHAPE = new VoxelShape[]{Block.box((double)2.0, (double)4.0, (double)0.0, (double)14.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)4.0, (double)2.0, (double)16.0, (double)8.0, (double)14.0)};
    public static final VoxelShape[] BOTTOM_SINGLE_SHAPE = new VoxelShape[]{Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)5.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)11.0, (double)15.0, (double)4.0, (double)15.0)), Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)5.0, (double)4.0, (double)15.0), (VoxelShape)Block.box((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0))};
    public static final VoxelShape[] BOTTOM_MULTI_SHAPE = new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)9.0, (double)4.0, (double)15.0), Block.box((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)7.0, (double)15.0, (double)4.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)9.0)};

    public BenchBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean isX = ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X;
        Direction direction = (Direction)state.getValue((Property)FACING);
        if (state.getValue((Property)TYPE) == GeneralUtil.LineConnectingType.NONE) {
            return Shapes.or((VoxelShape)(isX ? TOP_SHAPE[0] : TOP_SHAPE[1]), (VoxelShape)(isX ? BOTTOM_SINGLE_SHAPE[0] : BOTTOM_SINGLE_SHAPE[1]));
        }
        if (state.getValue((Property)TYPE) == GeneralUtil.LineConnectingType.MIDDLE) {
            return isX ? TOP_SHAPE[0] : TOP_SHAPE[1];
        }
        int i = 0;
        GeneralUtil.LineConnectingType type = (GeneralUtil.LineConnectingType)((Object)state.getValue((Property)TYPE));
        if (direction == Direction.NORTH && type == GeneralUtil.LineConnectingType.LEFT || direction == Direction.SOUTH && type == GeneralUtil.LineConnectingType.RIGHT) {
            i = 0;
        } else if (direction == Direction.NORTH && type == GeneralUtil.LineConnectingType.RIGHT || direction == Direction.SOUTH && type == GeneralUtil.LineConnectingType.LEFT) {
            i = 1;
        } else if (direction == Direction.EAST && type == GeneralUtil.LineConnectingType.RIGHT || direction == Direction.WEST && type == GeneralUtil.LineConnectingType.LEFT) {
            i = 2;
        } else if (direction == Direction.EAST && type == GeneralUtil.LineConnectingType.LEFT || direction == Direction.WEST && type == GeneralUtil.LineConnectingType.RIGHT) {
            i = 3;
        }
        return Shapes.or((VoxelShape)(isX ? TOP_SHAPE[0] : TOP_SHAPE[1]), (VoxelShape)BOTTOM_MULTI_SHAPE[i]);
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result = GeneralUtil.onUse(level, player, hand, hit, 0.2);
        if (result.consumesAction()) {
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        return GeneralUtil.onUse(level, player, InteractionHand.MAIN_HAND, hit, 0.2);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        GeneralUtil.onStateReplaced(world, pos);
    }
}

