/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.satisfy.meadow.core.entity.WaterBuffaloEntity;

public class WaterBuffaloModel
extends QuadrupedModel<WaterBuffaloEntity> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leg0;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;

    public WaterBuffaloModel(ModelPart root) {
        super(root, true, 16.0f, 4.0f, 2.25f, 2.0f, 24);
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.leg0 = root.getChild("left_hind_leg");
        this.leg1 = root.getChild("right_hind_leg");
        this.leg2 = root.getChild("left_front_leg");
        this.leg3 = root.getChild("right_front_leg");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition body = modelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 25).addBox(-7.0f, -4.0f, -5.0f, 14.0f, 12.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-7.0f, -16.0f, -5.0f, 14.0f, 12.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)2.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = modelPartData.addOrReplaceChild("head", CubeListBuilder.create().texOffs(33, 32).addBox(-4.0f, -2.3393f, -7.0f, 8.0f, 8.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.3393f, (float)-14.0f));
        PartDefinition horn_right_top_r1 = head.addOrReplaceChild("horn_right_top_r1", CubeListBuilder.create().texOffs(20, 47).mirror().addBox(0.5f, -3.25f, -1.5f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(38, 25).mirror().addBox(-5.5f, -0.25f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)6.7271f, (float)-2.5991f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition horn_left_top_r1 = head.addOrReplaceChild("horn_left_top_r1", CubeListBuilder.create().texOffs(20, 47).addBox(-2.5f, -3.25f, -1.5f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(38, 25).addBox(-2.5f, -0.25f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.7271f, (float)-2.5991f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition snout_r1 = head.addOrReplaceChild("snout_r1", CubeListBuilder.create().texOffs(41, 0).addBox(-2.5f, -2.0f, -2.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.6607f, (float)-8.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition head_r1 = head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-0.4f, -1.5f, -2.0f, 1.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)1.1607f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition head_r2 = head.addOrReplaceChild("head_r2", CubeListBuilder.create().texOffs(0, 25).addBox(-0.6f, -1.5f, -2.0f, 1.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)1.1607f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.48f));
        PartDefinition left_hind_leg = modelPartData.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(0, 47).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 14.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.5f, (float)10.0f, (float)7.5f));
        PartDefinition right_hind_leg = modelPartData.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(0, 47).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 14.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.5f, (float)10.0f, (float)7.5f));
        PartDefinition left_front_leg = modelPartData.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 47).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 14.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.5f, (float)10.0f, (float)-10.5f));
        PartDefinition right_front_leg = modelPartData.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 47).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 14.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.5f, (float)10.0f, (float)-10.5f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j, int k) {
        List<ModelPart> partsToScale = this.getPartsToScale();
        for (ModelPart part : partsToScale) {
            part.render(poseStack, vertexConsumer, i, j, k);
        }
    }

    public List<ModelPart> getPartsToScale() {
        ArrayList<ModelPart> parts = new ArrayList<ModelPart>();
        parts.add(this.head);
        parts.add(this.body);
        parts.add(this.leg0);
        parts.add(this.leg1);
        parts.add(this.leg2);
        parts.add(this.leg3);
        return parts;
    }
}

