/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.satisfy.meadow.Meadow;
import org.jetbrains.annotations.NotNull;

public class FurLeggingsModel<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Meadow.identifier("fur_leggings"), "main");
    private final ModelPart body;
    private final ModelPart right_leg;
    private final ModelPart left_leg;

    public FurLeggingsModel(ModelPart root) {
        this.body = root.getChild("body");
        this.right_leg = root.getChild("right_leg");
        this.left_leg = root.getChild("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(3, 35).addBox(-4.0f, 9.0f, -2.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.325f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(16, 48).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(29, 39).addBox(-0.8f, -3.0f, -3.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(16, 48).mirror().addBox(-2.0f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.2f)).mirror(false), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int k) {
        poseStack.pushPose();
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, k);
        this.right_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, k);
        this.left_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, k);
        poseStack.popPose();
    }

    public void setupAnim(@NotNull T entity, float f, float g, float h, float i, float j) {
    }

    public void copyLegs(ModelPart rightLegModel, ModelPart leftLegModel) {
        this.right_leg.copyFrom(rightLegModel);
        this.left_leg.copyFrom(leftLegModel);
    }
}

