/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.core.item;

import com.berksire.furniture.core.registry.TagRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class TrashBagItem
extends Item {
    private static final int COOLDOWN_TICKS = 1200;
    private static final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();

    public TrashBagItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (world.isClientSide || user.isCrouching()) {
            return super.use(world, user, hand);
        }
        UUID userUUID = user.getUUID();
        long currentTime = world.getGameTime();
        if (!user.isCreative() && cooldowns.containsKey(userUUID) && currentTime - cooldowns.get(userUUID) < 1200L) {
            user.displayClientMessage((Component)Component.translatable((String)"tooltip.furniture.trash_bag.cooldown").withStyle(ChatFormatting.RED), true);
            return InteractionResultHolder.fail((Object)user.getItemInHand(hand));
        }
        ItemStack itemStack = user.getItemInHand(hand);
        Random random = new Random();
        List<Item> items = BuiltInRegistries.ITEM.stream().filter(item -> {
            String itemName = BuiltInRegistries.ITEM.getKey(item).getPath();
            return !item.builtInRegistryHolder().is(TagRegistry.TRASH_BAG_BLACKLIST) && !itemName.contains("book") && !itemName.contains("command_block") && !itemName.contains("creative") && !itemName.contains("debug") && !itemName.contains("diamond") && !itemName.contains("egg") && !itemName.contains("ender") && !itemName.contains("map") && !itemName.contains("netherite") && !itemName.contains("netherstar") && !itemName.contains("ore") && !itemName.contains("shulker") && !itemName.contains("spawn_egg") && !itemName.contains("spawn_keg") && !itemName.contains("worldshaper") && !itemName.contains("_head") && !itemName.contains("dragon") && !itemName.contains("light");
        }).toList();
        Item randomItem = items.get(random.nextInt(items.size()));
        ItemStack spawnedItem = new ItemStack((ItemLike)randomItem);
        world.addFreshEntity((Entity)new ItemEntity(world, user.getX(), user.getY(), user.getZ(), spawnedItem));
        if (!user.isCreative()) {
            itemStack.shrink(1);
            cooldowns.put(userUUID, currentTime);
        }
        world.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.BUNDLE_INSERT, SoundSource.PLAYERS, 1.0f, 1.0f);
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.translatable((String)"tooltip.furniture.trash_bag").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}));
    }
}

