/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.core.block;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TelescopeBlock
extends Block {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public TelescopeBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, FACING});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return state.getValue(HALF) == DoubleBlockHalf.UPPER ? this.getTopShape() : this.getBottomShape();
    }

    private VoxelShape getTopShape() {
        return Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape[])new VoxelShape[0]);
    }

    private VoxelShape getBottomShape() {
        return Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), (VoxelShape[])new VoxelShape[0]);
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos newPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        if (!(direction.getAxis() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (direction == Direction.UP) || newState.is((Block)this) && newState.getValue(HALF) != half)) {
            return Blocks.AIR.defaultBlockState();
        }
        return half == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, newState, world, pos, newPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        Direction direction = context.getHorizontalDirection().getOpposite();
        return pos.getY() < world.getMaxBuildHeight() - 1 && world.getBlockState(pos.above()).canBeReplaced(context) ? (BlockState)Objects.requireNonNull(super.getStateForPlacement(context)).setValue((Property)FACING, (Comparable)direction) : null;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockPos abovePos = pos.above();
        world.setBlock(abovePos, (BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))), 3);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (state.getValue(HALF) != DoubleBlockHalf.UPPER) {
            return super.canSurvive(state, world, pos);
        }
        BlockState belowState = world.getBlockState(pos.below());
        return belowState.is((Block)this) && belowState.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide) {
            if (player.isCreative()) {
                TelescopeBlock.preventCreativeDropFromBottomPart(world, pos, state, player);
            } else {
                TelescopeBlock.dropResources((BlockState)state, (Level)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
        super.playerDestroy(world, player, pos, Blocks.AIR.defaultBlockState(), blockEntity, stack);
    }

    protected static void preventCreativeDropFromBottomPart(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos belowPos;
        BlockState belowState;
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        if (half == DoubleBlockHalf.UPPER && (belowState = world.getBlockState(belowPos = pos.below())).is(state.getBlock()) && belowState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            BlockState newState = belowState.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            world.setBlock(belowPos, newState, 35);
            world.levelEvent(player, 2001, belowPos, Block.getId((BlockState)belowState));
        }
    }

    public long getSeed(BlockState state, BlockPos pos) {
        return Mth.getSeed((int)pos.getX(), (int)pos.below(state.getValue(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).getY(), (int)pos.getZ());
    }
}

