/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.core.block;

import com.berksire.furniture.core.util.FurnitureUtil;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class StreetLanternBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<FurnitureUtil.VerticalConnectingType> TYPE = FurnitureUtil.VerticalConnectingType.VERTICAL_CONNECTING_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final IntegerProperty BULBS = IntegerProperty.create((String)"bulbs", (int)0, (int)1);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    private static final Supplier<VoxelShape> SINGLE_SHAPE_SUPPLIER = StreetLanternBlock::makeSingleShape;
    private static final Supplier<VoxelShape> DOUBLE_SHAPE_SUPPLIER = StreetLanternBlock::makeDoubleShape;
    private static final Supplier<VoxelShape> MIDDLE_SHAPE_SUPPLIER = StreetLanternBlock::makeMiddleShape;
    private static final Supplier<VoxelShape> BOTTOM_SHAPE_SUPPLIER = StreetLanternBlock::makeBottomShape;
    public static final Map<Direction, VoxelShape> SINGLE_SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, SINGLE_SHAPE_SUPPLIER.get()));
        }
    });
    public static final Map<Direction, VoxelShape> DOUBLE_SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, DOUBLE_SHAPE_SUPPLIER.get()));
        }
    });
    public static final Map<Direction, VoxelShape> MIDDLE_SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, MIDDLE_SHAPE_SUPPLIER.get()));
        }
    });
    public static final Map<Direction, VoxelShape> BOTTOM_SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, BOTTOM_SHAPE_SUPPLIER.get()));
        }
    });
    public static final MapCodec<StreetLanternBlock> CODEC = StreetLanternBlock.simpleCodec(StreetLanternBlock::new);

    public StreetLanternBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)FurnitureUtil.VerticalConnectingType.NONE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BULBS, (Comparable)Integer.valueOf(0))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, TYPE, WATERLOGGED, BULBS, LIT});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos clickedPos = context.getClickedPos();
        BlockPos belowPos = clickedPos.below();
        BlockState belowBlockState = context.getLevel().getBlockState(belowPos);
        if (!(belowBlockState.is((Block)this) || belowBlockState.getBlock() instanceof WallBlock || belowBlockState.getBlock() instanceof FenceBlock || belowBlockState.isFaceSturdy((BlockGetter)context.getLevel(), belowPos, Direction.UP))) {
            return null;
        }
        BlockState blockState = context.getLevel().getBlockState(clickedPos);
        if (blockState.is((Block)this) && (blockState.getValue(TYPE) == FurnitureUtil.VerticalConnectingType.TOP || blockState.getValue(TYPE) == FurnitureUtil.VerticalConnectingType.NONE)) {
            return (BlockState)blockState.setValue((Property)BULBS, (Comparable)Integer.valueOf(Math.min(1, (Integer)blockState.getValue((Property)BULBS) + 1)));
        }
        boolean flag = context.getLevel().getFluidState(clickedPos).getType() == Fluids.WATER;
        Direction direction = context.getHorizontalDirection().getOpposite();
        blockState = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
        blockState = (BlockState)blockState.setValue(TYPE, (Comparable)((Object)this.getType(blockState, context.getLevel().getBlockState(clickedPos.above()), context.getLevel().getBlockState(clickedPos.below()))));
        return (BlockState)blockState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos belowPos = pos.below();
        BlockState belowState = world.getBlockState(belowPos);
        return belowState.is((Block)this) || belowState.getBlock() instanceof WallBlock || belowState.getBlock() instanceof FenceBlock || belowState.isFaceSturdy((BlockGetter)world, belowPos, Direction.UP);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.isClientSide) {
            return;
        }
        FurnitureUtil.VerticalConnectingType type = this.getType(state, world.getBlockState(pos.above()), world.getBlockState(pos.below()));
        if (state.getValue(TYPE) != type) {
            state = (BlockState)state.setValue(TYPE, (Comparable)((Object)type));
        }
        world.setBlock(pos, state, 3);
    }

    public FurnitureUtil.VerticalConnectingType getType(BlockState state, BlockState above, BlockState below) {
        boolean shapeBelowSame;
        boolean shapeAboveSame = above.getBlock() == state.getBlock();
        boolean bl = shapeBelowSame = below.getBlock() == state.getBlock();
        if (shapeAboveSame && shapeBelowSame) {
            return FurnitureUtil.VerticalConnectingType.MIDDLE;
        }
        if (shapeAboveSame) {
            return FurnitureUtil.VerticalConnectingType.BOTTOM;
        }
        if (shapeBelowSame) {
            return FurnitureUtil.VerticalConnectingType.TOP;
        }
        return FurnitureUtil.VerticalConnectingType.NONE;
    }

    private static VoxelShape makeDoubleShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.5625, (double)0.3125, (double)0.375, (double)1.0, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.5625, (double)0.3125, (double)1.0, (double)1.0, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.5, (double)0.375, (double)0.3125, (double)0.5625, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.5, (double)0.375, (double)0.9375, (double)0.5625, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.125, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.125, (double)0.4375, (double)0.5625, (double)0.375, (double)0.5625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.25, (double)0.5, (double)0.875, (double)0.5, (double)0.5), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeBottomShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeSingleShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.5, (double)0.3125, (double)0.6875, (double)0.9375, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.4375, (double)0.375, (double)0.625, (double)0.5, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.125, (double)0.4375, (double)0.5625, (double)0.4375, (double)0.5625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.125, (double)0.625), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeMiddleShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)1.0, (double)0.625), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        FurnitureUtil.VerticalConnectingType type = (FurnitureUtil.VerticalConnectingType)((Object)state.getValue(TYPE));
        if ((Integer)state.getValue((Property)BULBS) == 1) {
            return DOUBLE_SHAPE.get(direction);
        }
        return switch (type) {
            case FurnitureUtil.VerticalConnectingType.MIDDLE -> MIDDLE_SHAPE.get(direction);
            case FurnitureUtil.VerticalConnectingType.BOTTOM -> BOTTOM_SHAPE.get(direction);
            default -> SINGLE_SHAPE.get(direction);
        };
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return useContext.isSecondaryUseActive() && useContext.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)BULBS) < 1 || super.canBeReplaced(state, useContext);
    }

    public static boolean canProvideLight(BlockState state) {
        return (Boolean)state.getValue((Property)LIT) != false && (state.getValue(TYPE) == FurnitureUtil.VerticalConnectingType.TOP || state.getValue(TYPE) == FurnitureUtil.VerticalConnectingType.NONE);
    }

    public static int vanillaLightLevel(BlockState state) {
        return (Boolean)state.getValue((Property)LIT) != false ? 15 : 0;
    }
}

