/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.core.block;

import com.berksire.furniture.core.block.entity.GramophoneBlockEntity;
import com.berksire.furniture.core.registry.EntityTypeRegistry;
import com.berksire.furniture.core.util.FurnitureUtil;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GramophoneBlock
extends BaseEntityBlock {
    public static final BooleanProperty HAS_RECORD = BlockStateProperties.HAS_RECORD;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final BooleanProperty REPEAT = BooleanProperty.create((String)"repeat");
    private static final VoxelShape SHAPE_LOWER = GramophoneBlock.makeLowerShape();
    private static final VoxelShape SHAPE_UPPER = GramophoneBlock.makeUpperShape();
    public static final Map<Direction, VoxelShape> SHAPE_LOWER_MAP = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, SHAPE_LOWER));
        }
    });
    public static final Map<Direction, VoxelShape> SHAPE_UPPER_MAP = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, SHAPE_UPPER));
        }
    });
    public static final MapCodec<GramophoneBlock> CODEC = GramophoneBlock.simpleCodec(GramophoneBlock::new);

    public GramophoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HAS_RECORD, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)REPEAT, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    private static VoxelShape makeLowerShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.75, (double)0.3125, (double)0.875, (double)1.0, (double)0.375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.875, (double)0.375, (double)0.75, (double)1.0, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.5, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.5, (double)0.8125, (double)0.5625, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeUpperShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.3125, (double)0.875, (double)0.5, (double)0.375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)0.375, (double)0.75, (double)0.375, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.6875, (double)0.625, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        BlockPos abovePos = blockPos.above();
        level.setBlock(abovePos, (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)FACING, (Comparable)((Direction)blockState.getValue((Property)FACING)))).setValue((Property)HAS_RECORD, (Comparable)((Boolean)blockState.getValue((Property)HAS_RECORD)))).setValue((Property)REPEAT, (Comparable)((Boolean)blockState.getValue((Property)REPEAT))), 3);
        super.setPlacedBy(level, blockPos, blockState, livingEntity, itemStack);
    }

    public void onRemove(BlockState blockState, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (!blockState.is(newState.getBlock())) {
            BlockPos otherPos;
            BlockState otherState;
            DoubleBlockHalf half = (DoubleBlockHalf)blockState.getValue(HALF);
            BlockPos basePos = half == DoubleBlockHalf.UPPER ? blockPos.below() : blockPos;
            BlockEntity baseBe = level.getBlockEntity(basePos);
            if (baseBe instanceof GramophoneBlockEntity) {
                GramophoneBlockEntity gram = (GramophoneBlockEntity)baseBe;
                gram.stopPlayingOnRemove();
                level.levelEvent(1011, basePos, 0);
                gram.popOutRecord();
                level.removeBlockEntity(basePos);
            }
            if ((otherState = level.getBlockState(otherPos = half == DoubleBlockHalf.LOWER ? blockPos.above() : blockPos.below())).is((Block)this) && otherState.getValue(HALF) != half) {
                level.setBlock(otherPos, Blocks.AIR.defaultBlockState(), 35);
                level.levelEvent(2001, otherPos, Block.getId((BlockState)otherState));
                level.removeBlockEntity(otherPos);
            }
        }
        super.onRemove(blockState, level, blockPos, newState, isMoving);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (state.getValue(HALF) != DoubleBlockHalf.UPPER) {
            return super.canSurvive(state, world, pos);
        }
        BlockState belowState = world.getBlockState(pos.below());
        return belowState.is((Block)this) && belowState.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        return pos.getY() < world.getMaxBuildHeight() - 1 && world.getBlockState(pos.above()).canBeReplaced(context) ? (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER) : null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HAS_RECORD, FACING, HALF, REPEAT});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return state.getValue(HALF) == DoubleBlockHalf.UPPER ? SHAPE_UPPER_MAP.get(state.getValue((Property)FACING)) : SHAPE_LOWER_MAP.get(state.getValue((Property)FACING));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return GramophoneBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.GRAMOPHONE_BLOCK_ENTITY.get()), (level1, pos, state, be) -> GramophoneBlockEntity.playRecordTick(level1, state, be));
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new GramophoneBlockEntity(blockPos, blockState);
    }

    public boolean isSignalSource(BlockState blockState) {
        return true;
    }

    public int getSignal(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        GramophoneBlockEntity discPlayerBlockEntity;
        BlockEntity blockEntity = blockGetter.getBlockEntity(blockPos);
        if (blockEntity instanceof GramophoneBlockEntity && (discPlayerBlockEntity = (GramophoneBlockEntity)blockEntity).isRecordPlaying()) {
            return 15;
        }
        return 0;
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos blockPos) {
        BlockEntity var5 = level.getBlockEntity(blockPos);
        if (var5 instanceof JukeboxBlockEntity) {
            JukeboxBlockEntity jukeboxBlockEntity = (JukeboxBlockEntity)var5;
            return jukeboxBlockEntity.getComparatorOutput();
        }
        return 0;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockPos basePos = state.getValue(HALF) == DoubleBlockHalf.UPPER ? pos.below() : pos;
        BlockState baseState = level.getBlockState(basePos);
        if (!baseState.is((Block)this)) {
            return InteractionResult.PASS;
        }
        if (player.isShiftKeyDown()) {
            BlockEntity be;
            if (((Boolean)baseState.getValue((Property)HAS_RECORD)).booleanValue() && (be = level.getBlockEntity(basePos)) instanceof GramophoneBlockEntity) {
                GramophoneBlockEntity gram = (GramophoneBlockEntity)be;
                if (!level.isClientSide) {
                    gram.popOutRecord();
                    BlockPos otherPos = basePos.above();
                    BlockState otherState = level.getBlockState(otherPos);
                    level.setBlock(basePos, (BlockState)baseState.setValue((Property)HAS_RECORD, (Comparable)Boolean.valueOf(false)), 3);
                    if (otherState.is((Block)this)) {
                        level.setBlock(otherPos, (BlockState)otherState.setValue((Property)HAS_RECORD, (Comparable)Boolean.valueOf(false)), 3);
                    }
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return InteractionResult.PASS;
        }
        BlockEntity be = level.getBlockEntity(basePos);
        if (be instanceof GramophoneBlockEntity) {
            GramophoneBlockEntity gram = (GramophoneBlockEntity)be;
            if (!level.isClientSide) {
                boolean next = !gram.isRepeat();
                gram.setRepeat(next);
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.furniture.repeat_mode", (Object[])new Object[]{Component.translatable((String)(next ? "tooltip.furniture.on" : "tooltip.furniture.off"))}), true);
                BlockPos otherPos = basePos.above();
                BlockState otherState = level.getBlockState(otherPos);
                level.setBlock(basePos, (BlockState)baseState.setValue((Property)REPEAT, (Comparable)Boolean.valueOf(next)), 3);
                if (otherState.is((Block)this)) {
                    level.setBlock(otherPos, (BlockState)otherState.setValue((Property)REPEAT, (Comparable)Boolean.valueOf(next)), 3);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity be;
        BlockPos basePos = state.getValue(HALF) == DoubleBlockHalf.UPPER ? pos.below() : pos;
        BlockState baseState = level.getBlockState(basePos);
        if (!baseState.is((Block)this)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (((Boolean)baseState.getValue((Property)HAS_RECORD)).booleanValue()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        JukeboxPlayable playable = (JukeboxPlayable)stack.get(DataComponents.JUKEBOX_PLAYABLE);
        if (playable == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide && (be = level.getBlockEntity(basePos)) instanceof GramophoneBlockEntity) {
            GramophoneBlockEntity gram = (GramophoneBlockEntity)be;
            ItemStack inserted = stack.copy();
            inserted.setCount(1);
            gram.setRecord(inserted);
            stack.shrink(1);
            BlockPos otherPos = basePos.above();
            BlockState otherState = level.getBlockState(otherPos);
            level.setBlock(basePos, (BlockState)baseState.setValue((Property)HAS_RECORD, (Comparable)Boolean.valueOf(true)), 3);
            if (otherState.is((Block)this)) {
                level.setBlock(otherPos, (BlockState)otherState.setValue((Property)HAS_RECORD, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }
}

