/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client.render;

import com.berksire.furniture.client.model.GrandfatherClockModel;
import com.berksire.furniture.core.block.GrandfatherClockBlock;
import com.berksire.furniture.core.block.entity.GrandfatherClockBlockEntity;
import com.berksire.furniture.core.util.FurnitureIdentifier;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class GrandfatherClockRenderer
implements BlockEntityRenderer<GrandfatherClockBlockEntity> {
    private static final Map<GrandfatherClockBlock.WoodType, ResourceLocation> TEXTURES = new EnumMap<GrandfatherClockBlock.WoodType, ResourceLocation>(GrandfatherClockBlock.WoodType.class);
    private final GrandfatherClockModel<Entity> model;

    public GrandfatherClockRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(GrandfatherClockModel.LAYER_LOCATION);
        this.model = new GrandfatherClockModel(root);
    }

    public void render(GrandfatherClockBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        BlockState blockstate = blockEntity.getBlockState();
        poseStack.pushPose();
        poseStack.translate(0.5, 1.5, 0.5);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        Direction direction = (Direction)blockstate.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        float rotation = direction.getOpposite().toYRot();
        poseStack.mulPose(new Quaternionf().rotateYXZ((float)Math.toRadians(rotation), 0.0f, 0.0f));
        long totalTime = System.currentTimeMillis();
        float smoothTime = (float)(totalTime % 60000L) / 50.0f;
        this.model.pendulum.zRot = (float)Math.sin((double)smoothTime * Math.PI / 30.0) * 0.15f;
        long gameTime = Objects.requireNonNull(blockEntity.getLevel()).getDayTime() % 24000L;
        int hours = (int)((gameTime / 1000L + 6L) % 24L);
        int minutes = (int)(gameTime % 1000L * 60L / 1000L);
        this.model.minutes.zRot = (float)((double)minutes * Math.PI / 30.0);
        this.model.hours.zRot = (float)((double)hours * Math.PI / 6.0);
        GrandfatherClockBlock.WoodType woodType = ((GrandfatherClockBlock)blockstate.getBlock()).getWoodType();
        ResourceLocation texture = TEXTURES.get((Object)woodType);
        if (texture == null) {
            texture = TEXTURES.get((Object)GrandfatherClockBlock.WoodType.OAK);
        }
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)texture));
        this.model.renderToBuffer(poseStack, vertexConsumer, combinedLight, combinedOverlay);
        poseStack.popPose();
    }

    static {
        TEXTURES.put(GrandfatherClockBlock.WoodType.OAK, FurnitureIdentifier.parseIdentifier("textures/entity/oak_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.SPRUCE, FurnitureIdentifier.parseIdentifier("textures/entity/spruce_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.BIRCH, FurnitureIdentifier.parseIdentifier("textures/entity/birch_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.JUNGLE, FurnitureIdentifier.parseIdentifier("textures/entity/jungle_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.ACACIA, FurnitureIdentifier.parseIdentifier("textures/entity/acacia_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.DARK_OAK, FurnitureIdentifier.parseIdentifier("textures/entity/dark_oak_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.MANGROVE, FurnitureIdentifier.parseIdentifier("textures/entity/mangrove_grandfatherclock.png"));
        TEXTURES.put(GrandfatherClockBlock.WoodType.CHERRY, FurnitureIdentifier.parseIdentifier("textures/entity/cherry_grandfatherclock.png"));
    }
}

