/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ColorRGBA;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.beachparty.core.block.BeachChairBlock;
import net.satisfy.beachparty.core.block.BeachGoalBlock;
import net.satisfy.beachparty.core.block.BeachParasolBlock;
import net.satisfy.beachparty.core.block.BeachSunLounger;
import net.satisfy.beachparty.core.block.BeachTowelBlock;
import net.satisfy.beachparty.core.block.CocktailBlock;
import net.satisfy.beachparty.core.block.CompletionistBannerBlock;
import net.satisfy.beachparty.core.block.CompletionistWallBannerBlock;
import net.satisfy.beachparty.core.block.HangingCoconutBlock;
import net.satisfy.beachparty.core.block.HoodedBeachChair;
import net.satisfy.beachparty.core.block.MessageInABottleBlock;
import net.satisfy.beachparty.core.block.MiniFridgeBlock;
import net.satisfy.beachparty.core.block.PalmBarBlock;
import net.satisfy.beachparty.core.block.PalmBarStoolBlock;
import net.satisfy.beachparty.core.block.PalmCabinetBlock;
import net.satisfy.beachparty.core.block.PalmCeilingHangingSignBlock;
import net.satisfy.beachparty.core.block.PalmChairBlock;
import net.satisfy.beachparty.core.block.PalmGlassBlock;
import net.satisfy.beachparty.core.block.PalmGlassPaneBlock;
import net.satisfy.beachparty.core.block.PalmLeavesBlock;
import net.satisfy.beachparty.core.block.PalmSproutBlock;
import net.satisfy.beachparty.core.block.PalmStandingSignBlock;
import net.satisfy.beachparty.core.block.PalmTableBlock;
import net.satisfy.beachparty.core.block.PalmWallHangingSignBlock;
import net.satisfy.beachparty.core.block.PalmWallSignBlock;
import net.satisfy.beachparty.core.block.RadioBlock;
import net.satisfy.beachparty.core.block.SandBucketBlock;
import net.satisfy.beachparty.core.block.SeashellBlock;
import net.satisfy.beachparty.core.block.TallPalmTorchBlock;
import net.satisfy.beachparty.core.block.WetHayBaleBlock;
import net.satisfy.beachparty.core.entity.PalmBoatEntity;
import net.satisfy.beachparty.core.item.BeachBallItem;
import net.satisfy.beachparty.core.item.CoconutItem;
import net.satisfy.beachparty.core.item.DrinkBlockItem;
import net.satisfy.beachparty.core.item.DyeableBeachpartyArmorItem;
import net.satisfy.beachparty.core.item.MessageInABottleItem;
import net.satisfy.beachparty.core.item.PalmBoatItem;
import net.satisfy.beachparty.core.item.PoolNoodleItem;
import net.satisfy.beachparty.core.item.SandBucketItem;
import net.satisfy.beachparty.core.item.SeashellItem;
import net.satisfy.beachparty.core.item.TrinketsArmorItem;
import net.satisfy.beachparty.core.registry.ArmorMaterialRegistry;
import net.satisfy.beachparty.core.registry.SoundEventRegistry;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;
import net.satisfy.beachparty.core.util.BeachpartyUtil;
import net.satisfy.beachparty.core.util.BeachpartyWoodType;

public class ObjectRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"beachparty", (ResourceKey)Registries.ITEM);
    public static final Registrar<Item> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"beachparty", (ResourceKey)Registries.BLOCK);
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final RegistrySupplier<Item> COCONUT_OPEN = ObjectRegistry.registerItem("coconut_open", () -> new Item(ObjectRegistry.getSettings().food(Foods.CARROT)));
    public static final RegistrySupplier<Item> RAW_MUSSEL_MEAT = ObjectRegistry.registerItem("raw_mussel_meat", () -> new Item(ObjectRegistry.getSettings().food(Foods.POTATO)));
    public static final RegistrySupplier<Item> COOKED_MUSSEL_MEAT = ObjectRegistry.registerItem("cooked_mussel_meat", () -> new Item(ObjectRegistry.getSettings().food(Foods.BAKED_POTATO)));
    public static final RegistrySupplier<Item> BEACH_HAT = ObjectRegistry.registerItem("beach_hat", () -> new TrinketsArmorItem((Holder<ArmorMaterial>)BuiltInRegistries.ARMOR_MATERIAL.wrapAsHolder((Object)ArmorMaterialRegistry.BEACH_HAT), ArmorItem.Type.HELMET, ObjectRegistry.getSettings().rarity(Rarity.EPIC), BeachpartyIdentifier.identifier("textures/models/armor/beach_hat.png")));
    public static final RegistrySupplier<Item> SUNGLASSES = ObjectRegistry.registerItem("sunglasses", () -> new TrinketsArmorItem((Holder<ArmorMaterial>)BuiltInRegistries.ARMOR_MATERIAL.wrapAsHolder((Object)ArmorMaterialRegistry.SUNGLASSES), ArmorItem.Type.HELMET, ObjectRegistry.getSettings().rarity(Rarity.RARE), BeachpartyIdentifier.identifier("textures/models/armor/sunglasses.png")));
    public static final RegistrySupplier<Item> RUBBER_RING_BLUE = ObjectRegistry.registerItem("rubber_ring_blue", () -> new TrinketsArmorItem((Holder<ArmorMaterial>)BuiltInRegistries.ARMOR_MATERIAL.wrapAsHolder((Object)ArmorMaterialRegistry.RING), ArmorItem.Type.CHESTPLATE, ObjectRegistry.getSettings().rarity(Rarity.UNCOMMON), BeachpartyIdentifier.identifier("textures/models/armor/rubber_ring_blue.png")));
    public static final RegistrySupplier<Item> RUBBER_RING_PINK = ObjectRegistry.registerItem("rubber_ring_pink", () -> new TrinketsArmorItem((Holder<ArmorMaterial>)BuiltInRegistries.ARMOR_MATERIAL.wrapAsHolder((Object)ArmorMaterialRegistry.RING), ArmorItem.Type.CHESTPLATE, ObjectRegistry.getSettings().rarity(Rarity.UNCOMMON), BeachpartyIdentifier.identifier("textures/models/armor/rubber_ring_pink.png")));
    public static final RegistrySupplier<Item> RUBBER_RING_STRIPPED = ObjectRegistry.registerItem("rubber_ring_stripped", () -> new TrinketsArmorItem((Holder<ArmorMaterial>)BuiltInRegistries.ARMOR_MATERIAL.wrapAsHolder((Object)ArmorMaterialRegistry.RING), ArmorItem.Type.CHESTPLATE, ObjectRegistry.getSettings().rarity(Rarity.UNCOMMON), BeachpartyIdentifier.identifier("textures/models/armor/rubber_ring_stripped.png")));
    public static final RegistrySupplier<Item> RUBBER_RING_PELICAN = ObjectRegistry.registerItem("rubber_ring_pelican", () -> new TrinketsArmorItem((Holder<ArmorMaterial>)BuiltInRegistries.ARMOR_MATERIAL.wrapAsHolder((Object)ArmorMaterialRegistry.RING), ArmorItem.Type.CHESTPLATE, ObjectRegistry.getSettings().rarity(Rarity.RARE), BeachpartyIdentifier.identifier("textures/models/armor/rubber_ring_pelican.png")));
    public static final RegistrySupplier<Item> RUBBER_RING_AXOLOTL = ObjectRegistry.registerItem("rubber_ring_axolotl", () -> new TrinketsArmorItem((Holder<ArmorMaterial>)BuiltInRegistries.ARMOR_MATERIAL.wrapAsHolder((Object)ArmorMaterialRegistry.RING), ArmorItem.Type.CHESTPLATE, ObjectRegistry.getSettings().rarity(Rarity.RARE), BeachpartyIdentifier.identifier("textures/models/armor/rubber_ring_axolotl.png")));
    public static final RegistrySupplier<Item> POOL_NOODLE = ObjectRegistry.registerItem("pool_noodle", () -> new PoolNoodleItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> TRUNKS = ObjectRegistry.registerItem("trunks", () -> new DyeableBeachpartyArmorItem(ArmorMaterialRegistry.TRUNKS, ArmorItem.Type.LEGGINGS, 0xFF0F0F, ObjectRegistry.getSettings().rarity(Rarity.UNCOMMON), BeachpartyIdentifier.identifier("textures/models/armor/trunks.png")));
    public static final RegistrySupplier<Item> BIKINI = ObjectRegistry.registerItem("bikini", () -> new DyeableBeachpartyArmorItem(ArmorMaterialRegistry.BIKINI, ArmorItem.Type.CHESTPLATE, 987135, ObjectRegistry.getSettings().rarity(Rarity.UNCOMMON), BeachpartyIdentifier.identifier("textures/models/armor/bikini.png")));
    public static final RegistrySupplier<Item> CROCS = ObjectRegistry.registerItem("crocs", () -> new DyeableBeachpartyArmorItem(ArmorMaterialRegistry.CROCS, ArmorItem.Type.BOOTS, 1048335, ObjectRegistry.getSettings().rarity(Rarity.EPIC), BeachpartyIdentifier.identifier("textures/models/armor/crocs.png")));
    public static final RegistrySupplier<Item> SWIM_WINGS = ObjectRegistry.registerItem("swim_wings", () -> new DyeableBeachpartyArmorItem(ArmorMaterialRegistry.SWIM_WINGS, ArmorItem.Type.CHESTPLATE, 16734208, ObjectRegistry.getSettings(), BeachpartyIdentifier.identifier("textures/models/armor/swim_wings.png")));
    public static final RegistrySupplier<Block> WET_HAY_BLOCK = ObjectRegistry.registerWithItem("wet_hay_block", () -> new WetHayBaleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HAY_BLOCK)));
    public static final RegistrySupplier<Block> THATCH = ObjectRegistry.registerWithItem("thatch", () -> new HayBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HAY_BLOCK)));
    public static final RegistrySupplier<Block> THATCH_STAIRS = ObjectRegistry.registerWithItem("thatch_stairs", () -> new StairBlock(((Block)THATCH.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)THATCH.get())).sound(SoundType.GRASS)));
    public static final RegistrySupplier<Block> THATCH_SLAB = ObjectRegistry.registerWithItem("thatch_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HAY_BLOCK)));
    public static final RegistrySupplier<Block> PALM_LEAVES = ObjectRegistry.registerWithItem("palm_leaves", () -> new PalmLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES)));
    public static final Supplier<SaplingBlock> PALM_SPROUT = ObjectRegistry.registerWithItem("palm_sprout", PalmSproutBlock::new);
    public static final RegistrySupplier<Block> STRIPPED_PALM_LOG = ObjectRegistry.registerWithItem("stripped_palm_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS).strength(2.0f).sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> STRIPPED_PALM_WOOD = ObjectRegistry.registerWithItem("stripped_palm_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS).strength(2.0f).sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> PALM_LOG = ObjectRegistry.registerWithItem("palm_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS).strength(2.0f).sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> PALM_WOOD = ObjectRegistry.registerWithItem("palm_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS).strength(2.0f).sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> PALM_PLANKS = ObjectRegistry.registerWithItem("palm_planks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS)));
    public static final RegistrySupplier<Block> PALM_FLOORBOARD = ObjectRegistry.registerWithItem("palm_floorboard", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS)));
    public static final RegistrySupplier<Block> PALM_STAIRS = ObjectRegistry.registerWithItem("palm_stairs", () -> new StairBlock(((Block)PALM_PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)PALM_PLANKS.get()))));
    public static final RegistrySupplier<Block> PALM_SLAB = ObjectRegistry.registerWithItem("palm_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS).strength(2.0f).sound(SoundType.WOOD).explosionResistance(3.0f)));
    public static final RegistrySupplier<Block> PALM_FENCE = ObjectRegistry.registerWithItem("palm_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE)));
    public static final RegistrySupplier<Block> PALM_FENCE_GATE = ObjectRegistry.registerWithItem("palm_fence_gate", () -> new FenceGateBlock(WoodType.BAMBOO, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE)));
    public static final RegistrySupplier<Block> PALM_BUTTON = ObjectRegistry.registerWithItem("palm_button", () -> ObjectRegistry.woodenButton(FeatureFlags.VANILLA));
    public static final RegistrySupplier<Block> PALM_PRESSURE_PLATE = ObjectRegistry.registerWithItem("palm_pressure_plate", () -> new PressurePlateBlock(BlockSetType.BAMBOO, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE)));
    public static final RegistrySupplier<Block> PALM_DOOR = ObjectRegistry.registerWithItem("palm_door", () -> new DoorBlock(BlockSetType.BAMBOO, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR)));
    public static final RegistrySupplier<Block> PALM_TRAPDOOR = ObjectRegistry.registerWithItem("palm_trapdoor", () -> new TrapDoorBlock(BlockSetType.BAMBOO, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR)));
    public static final RegistrySupplier<Block> PALM_GLASS = ObjectRegistry.registerWithItem("palm_glass", () -> new PalmGlassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)));
    public static final RegistrySupplier<Block> PALM_GLASS_PANE = ObjectRegistry.registerWithItem("palm_glass_pane", () -> new PalmGlassPaneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS_PANE)));
    public static final RegistrySupplier<Block> PALM_TABLE = ObjectRegistry.registerWithItem("palm_table", () -> new PalmTableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS)));
    public static final RegistrySupplier<Block> PALM_BAR = ObjectRegistry.registerWithItem("palm_bar", () -> new PalmBarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS)));
    public static final RegistrySupplier<Block> PALM_CABINET = ObjectRegistry.registerWithItem("palm_cabinet", () -> new PalmCabinetBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS), () -> SoundEvents.BAMBOO_WOOD_TRAPDOOR_OPEN, () -> SoundEvents.BAMBOO_WOOD_TRAPDOOR_CLOSE));
    public static final RegistrySupplier<Block> PALM_CHAIR = ObjectRegistry.registerWithItem("palm_chair", () -> new PalmChairBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS).pushReaction(PushReaction.IGNORE)));
    public static final RegistrySupplier<Block> BEACH_CHAIR = ObjectRegistry.registerWithItem("beach_chair", () -> new BeachChairBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS)));
    public static final RegistrySupplier<Block> HOODED_BEACH_CHAIR = ObjectRegistry.registerWithItem("hooded_beach_chair", () -> new HoodedBeachChair(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS)));
    public static final RegistrySupplier<Block> BEACH_SUN_LOUNGER = ObjectRegistry.registerWithItem("beach_sun_lounger", () -> new BeachSunLounger(DyeColor.WHITE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS).pushReaction(PushReaction.IGNORE).instabreak().mapColor(DyeColor.WHITE)));
    public static final RegistrySupplier<Block> PALM_BAR_STOOL = ObjectRegistry.registerWithItem("palm_bar_stool", () -> new PalmBarStoolBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS)));
    public static final RegistrySupplier<Block> BEACH_PARASOL = ObjectRegistry.registerWithItem("beach_parasol", () -> new BeachParasolBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS)));
    public static final RegistrySupplier<Block> BEACH_TOWEL = ObjectRegistry.registerWithItem("beach_towel", () -> new BeachTowelBlock(DyeColor.WHITE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL).pushReaction(PushReaction.IGNORE).instabreak().mapColor(DyeColor.WHITE)));
    public static final RegistrySupplier<Block> MINI_FRIDGE = ObjectRegistry.registerWithItem("mini_fridge", () -> new MiniFridgeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).sound(SoundType.COPPER)));
    public static final RegistrySupplier<Block> RADIO = ObjectRegistry.registerWithItem("radio", () -> new RadioBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS)));
    public static final RegistrySupplier<Block> MESSAGE_IN_A_BOTTLE = ObjectRegistry.registerWithoutItem("message_in_a_bottle", () -> new MessageInABottleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0)));
    public static final RegistrySupplier<Item> MESSAGE_IN_A_BOTTLE_ITEM = ObjectRegistry.registerItem("message_in_a_bottle", () -> new MessageInABottleItem((Block)MESSAGE_IN_A_BOTTLE.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> SEASHELL_BLOCK = ObjectRegistry.registerWithoutItem("seashell_block", () -> new SeashellBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DECORATED_POT).instabreak().noCollission()));
    public static final RegistrySupplier<Item> SEASHELL = ObjectRegistry.registerItem("seashell", () -> new SeashellItem((Block)SEASHELL_BLOCK.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> SAND_BUCKET_BLOCK_FILLED = ObjectRegistry.registerWithoutItem("sand_bucket_block_filled", () -> new SandBucketBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DECORATED_POT)));
    public static final RegistrySupplier<Item> SAND_BUCKET_FILLED = ObjectRegistry.registerItem("sand_bucket_filled", () -> new SandBucketItem((Block)SAND_BUCKET_BLOCK_FILLED.get(), ObjectRegistry.getSettings().stacksTo(1)));
    public static final RegistrySupplier<Block> SAND_BUCKET_BLOCK_EMPTY = ObjectRegistry.registerWithoutItem("sand_bucket_block_empty", () -> new SandBucketBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHER_WART)));
    public static final RegistrySupplier<Item> SAND_BUCKET_EMPTY = ObjectRegistry.registerItem("sand_bucket_empty", () -> new SandBucketItem((Block)SAND_BUCKET_BLOCK_EMPTY.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> SANDCASTLE = ObjectRegistry.registerWithoutItem("sandcastle", () -> new SandBucketBlock.SandCastleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND)));
    public static final RegistrySupplier<Block> SAND_PILE = ObjectRegistry.registerWithoutItem("sand_pile", () -> new SandBucketBlock.SandPileBlock(new ColorRGBA(14406560), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).mapColor(MapColor.SAND)));
    public static final RegistrySupplier<Item> COCONUT = ObjectRegistry.registerItem("coconut", () -> new CoconutItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> COCONUT_COCKTAIL = ObjectRegistry.registerCocktail("coconut_cocktail", () -> new CocktailBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).sound(SoundType.WOOD).noOcclusion().instabreak(), (MobEffect)MobEffects.DAMAGE_BOOST.value(), 600, () -> CocktailBlock.COCONUT_COCKTAIL_SHAPE), (MobEffect)MobEffects.DAMAGE_BOOST.value());
    public static final RegistrySupplier<Block> SWEETBERRIES_COCKTAIL = ObjectRegistry.registerCocktail("sweetberries_cocktail", (MobEffect)MobEffects.ABSORPTION.value(), CocktailBlock.SWEETBERRIES_COCKTAIL_SHAPE);
    public static final RegistrySupplier<Block> COCOA_COCKTAIL = ObjectRegistry.registerCocktail("cocoa_cocktail", (MobEffect)MobEffects.REGENERATION.value(), CocktailBlock.COCOA_COCKTAIL_SHAPE);
    public static final RegistrySupplier<Block> PUMPKIN_COCKTAIL = ObjectRegistry.registerCocktail("pumpkin_cocktail", (MobEffect)MobEffects.FIRE_RESISTANCE.value(), CocktailBlock.PUMPKIN_COCKTAIL_SHAPE);
    public static final RegistrySupplier<Block> HONEY_COCKTAIL = ObjectRegistry.registerCocktail("honey_cocktail", (MobEffect)MobEffects.DIG_SPEED.value(), CocktailBlock.HONEY_COCKTAIL_SHAPE);
    public static final RegistrySupplier<Block> MELON_COCKTAIL = ObjectRegistry.registerCocktail("melon_cocktail", (MobEffect)MobEffects.LUCK.value(), CocktailBlock.MELON_COCKTAIL_SHAPE);
    public static final RegistrySupplier<Item> BEACH_BALL = ObjectRegistry.registerItem("beach_ball", () -> new BeachBallItem(new Item.Properties()));
    public static final RegistrySupplier<Block> BEACH_GOAL = ObjectRegistry.registerWithItem("beach_goal", () -> new BeachGoalBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_PLANKS)));
    public static final RegistrySupplier<Block> PALM_TORCH = ObjectRegistry.registerWithoutItem("palm_torch", () -> new TorchBlock(ParticleTypes.FLAME, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCH).noCollission().instabreak().lightLevel(state -> 14).sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> PALM_WALL_TORCH = ObjectRegistry.registerWithoutItem("palm_wall_torch", () -> new WallTorchBlock(ParticleTypes.FLAME, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCH).noCollission().instabreak().lightLevel(state -> 14).sound(SoundType.WOOD).dropsLike((Block)PALM_TORCH.get())));
    public static final RegistrySupplier<Item> PALM_TORCH_ITEM = ObjectRegistry.registerItem("palm_torch_item", () -> new StandingAndWallBlockItem((Block)PALM_TORCH.get(), (Block)PALM_WALL_TORCH.get(), ObjectRegistry.getSettings(), Direction.DOWN));
    public static final RegistrySupplier<Block> TALL_PALM_TORCH = ObjectRegistry.registerWithItem("tall_palm_torch", () -> new TallPalmTorchBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCH).noCollission().instabreak().lightLevel(state -> 14).sound(SoundType.WOOD), ParticleTypes.FLAME));
    public static final RegistrySupplier<Block> HANGING_COCONUT = ObjectRegistry.registerWithoutItem("hanging_coconut", () -> new HangingCoconutBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO)));
    public static final RegistrySupplier<Block> SANDWAVES = ObjectRegistry.registerWithItem("sandwaves", () -> new ColoredFallingBlock(new ColorRGBA(14406560), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).mapColor(MapColor.SAND).strength(0.5f).sound(SoundType.SAND)));
    public static final RegistrySupplier<Block> PALM_SIGN = ObjectRegistry.registerWithoutItem("palm_sign", () -> new PalmStandingSignBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SIGN), BeachpartyWoodType.PALM));
    public static final RegistrySupplier<Block> PALM_WALL_SIGN = ObjectRegistry.registerWithoutItem("palm_wall_sign", () -> new PalmWallSignBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_SIGN), BeachpartyWoodType.PALM));
    public static final RegistrySupplier<Block> PALM_HANGING_SIGN = ObjectRegistry.registerWithoutItem("palm_hanging_sign", () -> new PalmCeilingHangingSignBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_HANGING_SIGN), BeachpartyWoodType.PALM));
    public static final RegistrySupplier<Block> PALM_WALL_HANGING_SIGN = ObjectRegistry.registerWithoutItem("palm_wall_hanging_sign", () -> new PalmWallHangingSignBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_HANGING_SIGN), BeachpartyWoodType.PALM));
    public static final RegistrySupplier<Item> PALM_SIGN_ITEM = ITEMS.register("palm_sign", () -> new SignItem(new Item.Properties().stacksTo(16), (Block)PALM_SIGN.get(), (Block)PALM_WALL_SIGN.get()));
    public static final RegistrySupplier<Item> PALM_HANGING_SIGN_ITEM = ITEMS.register("palm_hanging_sign", () -> new HangingSignItem((Block)PALM_HANGING_SIGN.get(), (Block)PALM_WALL_HANGING_SIGN.get(), new Item.Properties().stacksTo(16)));
    public static final RegistrySupplier<Item> PALM_BOAT = ITEMS.register("palm_boat", () -> new PalmBoatItem(false, PalmBoatEntity.Type.PALM, new Item.Properties().stacksTo(1)));
    public static final RegistrySupplier<Item> PALM_CHEST_BOAT = ITEMS.register("palm_chest_boat", () -> new PalmBoatItem(true, PalmBoatEntity.Type.PALM, new Item.Properties().stacksTo(1)));
    public static final RegistrySupplier<Item> FLOATY_BOAT = ITEMS.register("floaty_boat", () -> new PalmBoatItem(false, PalmBoatEntity.Type.FLOATY, new Item.Properties().stacksTo(1)));
    public static final RegistrySupplier<Item> FLOATY_CHEST_BOAT = ITEMS.register("floaty_chest_boat", () -> new PalmBoatItem(true, PalmBoatEntity.Type.FLOATY, new Item.Properties().stacksTo(1)));
    public static final RegistrySupplier<Block> BEACHPARTY_BANNER = ObjectRegistry.registerWithItem("beachparty_banner", () -> new CompletionistBannerBlock(BlockBehaviour.Properties.of().strength(1.0f).instrument(NoteBlockInstrument.BASS).noCollission().sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> BEACHPARTY_WALL_BANNER = ObjectRegistry.registerWithoutItem("beachparty_wall_banner", () -> new CompletionistWallBannerBlock(BlockBehaviour.Properties.of().strength(1.0f).instrument(NoteBlockInstrument.BASS).noCollission().sound(SoundType.WOOD)));
    public static final RegistrySupplier<Item> OVERGROWN_DISC = ObjectRegistry.registerItem("overgrown_disc", () -> new Item(ObjectRegistry.getSettings().stacksTo(1).jukeboxPlayable(SoundEventRegistry.OVER_THE_RAINBOW).rarity(Rarity.RARE)));
    public static final RegistrySupplier<Item> MUSIC_DISC_BEACHPARTY = ObjectRegistry.registerItem("music_disc_beachparty", () -> new Item(ObjectRegistry.getSettings().stacksTo(1).jukeboxPlayable(SoundEventRegistry.BEACHPARTY).rarity(Rarity.RARE)));
    public static final RegistrySupplier<Item> MUSIC_DISC_CARIBBEAN_BEACH = ObjectRegistry.registerItem("music_disc_caribbean_beach", () -> new Item(ObjectRegistry.getSettings().stacksTo(1).rarity(Rarity.RARE).jukeboxPlayable(SoundEventRegistry.CARIBBEAN_BEACH)));
    public static final RegistrySupplier<Item> MUSIC_DISC_PRIDELANDS = ObjectRegistry.registerItem("music_disc_pridelands", () -> new Item(ObjectRegistry.getSettings().stacksTo(1).rarity(Rarity.RARE).jukeboxPlayable(SoundEventRegistry.PRIDELANDS)));
    public static final RegistrySupplier<Item> MUSIC_DISC_VOCALISTA = ObjectRegistry.registerItem("music_disc_vocalista", () -> new Item(ObjectRegistry.getSettings().stacksTo(1).rarity(Rarity.RARE).jukeboxPlayable(SoundEventRegistry.VOCALISTA)));
    public static final RegistrySupplier<Item> MUSIC_DISC_WILD_VEINS = ObjectRegistry.registerItem("music_disc_wild_veins", () -> new Item(ObjectRegistry.getSettings().stacksTo(1).rarity(Rarity.RARE).jukeboxPlayable(SoundEventRegistry.WILD_VEINS)));

    static Item.Properties getSettings() {
        return ObjectRegistry.getSettings(settings -> {});
    }

    private static Item.Properties getSettings(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties();
        consumer.accept(settings);
        return settings;
    }

    private static FoodProperties cocktailFoodComponent(MobEffect effect) {
        FoodProperties.Builder component = new FoodProperties.Builder().nutrition(1).saturationModifier(1.0f);
        if (effect != null) {
            component.effect(new MobEffectInstance(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect), 900), 1.0f);
        }
        return component.build();
    }

    public static void init() {
        ITEMS.register();
        BLOCKS.register();
    }

    private static ButtonBlock woodenButton(FeatureFlag ... featureFlags) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY);
        if (featureFlags.length > 0) {
            properties = properties.requiredFeatures(featureFlags);
        }
        return new ButtonBlock(BlockSetType.BAMBOO, 30, properties);
    }

    private static RegistrySupplier<Block> registerCocktail(String name, MobEffect effect, VoxelShape shape) {
        return ObjectRegistry.registerCocktail(name, () -> new CocktailBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).noOcclusion().instabreak(), effect, 600, () -> shape), effect);
    }

    private static <T extends Block> RegistrySupplier<T> registerCocktail(String name, Supplier<T> block, MobEffect effect) {
        RegistrySupplier toReturn = ObjectRegistry.registerWithoutItem(name, block);
        ObjectRegistry.registerItem(name, () -> new DrinkBlockItem((Block)toReturn.get(), ObjectRegistry.getSettings(s -> s.food(ObjectRegistry.cocktailFoodComponent(effect)))));
        return toReturn;
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block) {
        return BeachpartyUtil.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, BeachpartyIdentifier.identifier(name), block);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return BeachpartyUtil.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, BeachpartyIdentifier.identifier(path), block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String path, Supplier<T> itemSupplier) {
        return BeachpartyUtil.registerItem(ITEMS, ITEM_REGISTRAR, BeachpartyIdentifier.identifier(path), itemSupplier);
    }
}

