/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.registry;

import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;

public class ArmorMaterialRegistry {
    private static final int ENCHANTMENT_VALUE = 15;
    private static final Holder<SoundEvent> EQUIP_SOUND = SoundEvents.ARMOR_EQUIP_LEATHER;
    private static final float TOUGHNESS = 0.0f;
    private static final float KNOCKBACK_RESISTANCE = 0.0f;
    public static final ArmorMaterial TRUNKS = ArmorMaterialRegistry.createMaterial("trunks", Ingredient.of((ItemLike[])new ItemLike[]{Items.STRING}), true);
    public static final ArmorMaterial BIKINI = ArmorMaterialRegistry.createMaterial("bikini", Ingredient.of((ItemLike[])new ItemLike[]{Items.STRING}), true);
    public static final ArmorMaterial RING = ArmorMaterialRegistry.createMaterial("ring", Ingredient.of((ItemLike[])new ItemLike[]{Items.DRIED_KELP}), false);
    public static final ArmorMaterial BEACH_HAT = ArmorMaterialRegistry.createMaterial("beach_hat", Ingredient.of((ItemLike[])new ItemLike[]{Items.WHEAT}), false);
    public static final ArmorMaterial SUNGLASSES = ArmorMaterialRegistry.createMaterial("sunglasses", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.BLACK_STAINED_GLASS_PANE.asItem()}), false);
    public static final ArmorMaterial SWIM_WINGS = ArmorMaterialRegistry.createMaterial("swim_wings", Ingredient.of((ItemLike[])new ItemLike[]{Items.DRIED_KELP}), true);
    public static final ArmorMaterial CROCS = ArmorMaterialRegistry.createMaterial("crocs", Ingredient.of((ItemLike[])new ItemLike[]{Items.DRIED_KELP}), true);

    private static ArmorMaterial createMaterial(String name, Ingredient repairIngredient, boolean dyeable) {
        return ArmorMaterialRegistry.register(ArmorMaterialRegistry.slots(1, 1, 1, 1, 1), 15, EQUIP_SOUND, 0.0f, 0.0f, () -> repairIngredient, ArmorMaterialRegistry.layers(name, dyeable));
    }

    private static EnumMap<ArmorItem.Type, Integer> slots(int boots, int leggings, int chestplate, int helmet, int body) {
        EnumMap<ArmorItem.Type, Integer> map = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        map.put(ArmorItem.Type.BOOTS, boots);
        map.put(ArmorItem.Type.LEGGINGS, leggings);
        map.put(ArmorItem.Type.CHESTPLATE, chestplate);
        map.put(ArmorItem.Type.HELMET, helmet);
        map.put(ArmorItem.Type.BODY, body);
        return map;
    }

    private static List<ArmorMaterial.Layer> layers(String name, boolean dyeable) {
        ResourceLocation base = BeachpartyIdentifier.identifier(name);
        return List.of(new ArmorMaterial.Layer(base, "", dyeable));
    }

    private static ArmorMaterial register(EnumMap<ArmorItem.Type, Integer> health, int enchantValue, Holder<SoundEvent> equipSound, float toughness, float knockback, Supplier<Ingredient> repair, List<ArmorMaterial.Layer> layers) {
        EnumMap<ArmorItem.Type, Integer> copy = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        copy.putAll(health);
        return new ArmorMaterial(copy, enchantValue, equipSound, repair, layers, toughness, knockback);
    }
}

