/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.mixin;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PotionItem.class})
public class PotionItemMixin {
    @Inject(at={@At(value="HEAD")}, method={"useOn(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;"}, cancellable=true)
    public void onWaterUse(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockState state = world.getBlockState(pos);
        if (context.getClickedFace() != Direction.DOWN && (state.getBlock() == Blocks.SAND || state.getBlock() == Blocks.GRAVEL) && Objects.requireNonNull((PotionContents)stack.get(DataComponents.POTION_CONTENTS)).is(Potions.WATER)) {
            world.playSound(null, pos, SoundEvents.GENERIC_SPLASH, SoundSource.PLAYERS, 1.0f, 1.0f);
            assert (player != null);
            player.setItemInHand(context.getHand(), ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            if (!world.isClientSide) {
                ServerLevel serverWorld = (ServerLevel)world;
                for (int i = 0; i < 5; ++i) {
                    serverWorld.sendParticles((ParticleOptions)ParticleTypes.SPLASH, (double)pos.getX() + world.random.nextDouble(), (double)(pos.getY() + 1), (double)pos.getZ() + world.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                }
            }
            world.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
            world.setBlockAndUpdate(pos, state.getBlock() == Blocks.GRAVEL ? Blocks.SAND.defaultBlockState() : ((Block)ObjectRegistry.SANDWAVES.get()).defaultBlockState());
            cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)world.isClientSide));
            return;
        }
        if (context.getClickedFace() != Direction.DOWN && state.getBlock() == Blocks.HAY_BLOCK && Objects.requireNonNull((PotionContents)stack.get(DataComponents.POTION_CONTENTS)).is(Potions.WATER)) {
            world.playSound(null, pos, SoundEvents.GENERIC_SPLASH, SoundSource.PLAYERS, 1.0f, 1.0f);
            assert (player != null);
            player.setItemInHand(context.getHand(), ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            if (!world.isClientSide) {
                ServerLevel serverWorld = (ServerLevel)world;
                for (int i = 0; i < 5; ++i) {
                    serverWorld.sendParticles((ParticleOptions)ParticleTypes.SPLASH, (double)pos.getX() + world.random.nextDouble(), (double)(pos.getY() + 1), (double)pos.getZ() + world.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                }
            }
            world.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
            world.setBlockAndUpdate(pos, ((Block)ObjectRegistry.WET_HAY_BLOCK.get()).defaultBlockState());
            cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)world.isClientSide));
        }
    }
}

