/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.beachparty.core.block.entity.WetHayBaleBlockEntity;
import org.jetbrains.annotations.NotNull;

public class WetHayBaleBlock
extends RotatedPillarBlock
implements EntityBlock {
    public WetHayBaleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WetHayBaleBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide() ? null : (lvl, pos, blockState, te) -> {
            if (te instanceof WetHayBaleBlockEntity) {
                WetHayBaleBlockEntity wetHayBaleBlockEntity = (WetHayBaleBlockEntity)te;
                WetHayBaleBlockEntity.tick((ServerLevel)lvl, pos, blockState, wetHayBaleBlockEntity);
            }
        };
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.CLAY_BALL)) {
            BlockEntity blockEntity2 = level.getBlockEntity(pos);
            if (blockEntity2 instanceof WetHayBaleBlockEntity) {
                WetHayBaleBlockEntity be = (WetHayBaleBlockEntity)blockEntity2;
                be.preventDrying();
                if (!player.isCreative()) {
                    itemStack.shrink(1);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        } else if (((PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).is(Potions.WATER) && (blockEntity = level.getBlockEntity(pos)) instanceof WetHayBaleBlockEntity) {
            WetHayBaleBlockEntity be = (WetHayBaleBlockEntity)blockEntity;
            be.removeProtection();
            if (!player.isCreative()) {
                itemStack.shrink(1);
                player.setItemInHand(hand, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(itemStack, state, level, pos, player, hand, hit);
    }
}

