/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ColorRGBA;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.util.BeachpartyUtil;
import net.satisfy.beachparty.core.util.SandCastleManager;
import org.jetbrains.annotations.NotNull;

public class SandBucketBlock
extends HorizontalDirectionalBlock {
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> SandBucketBlock.box((double)4.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)12.0);
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(direction, BeachpartyUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });
    public static final MapCodec<SandBucketBlock> CODEC = SandBucketBlock.simpleCodec(SandBucketBlock::new);

    public SandBucketBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.getValue((Property)FACING));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        Block emptySandBucketBlock = (Block)ObjectRegistry.SAND_BUCKET_BLOCK_EMPTY.get();
        Block sandBucketBlock = (Block)ObjectRegistry.SAND_BUCKET_BLOCK_FILLED.get();
        if (blockState.getBlock() == emptySandBucketBlock && itemStack.getItem() == Items.SAND) {
            itemStack.shrink(1);
            level.setBlockAndUpdate(blockPos, (BlockState)sandBucketBlock.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)blockState.getValue((Property)FACING))));
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        SandCastleManager.registerSandCastle(pos);
        super.setPlacedBy(world, pos, state, placer, itemStack);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        SandCastleManager.unregisterSandCastle(pos);
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public static class SandPileBlock
    extends ColoredFallingBlock {
        private static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0);

        public SandPileBlock(ColorRGBA colorRGBA, BlockBehaviour.Properties settings) {
            super(colorRGBA, settings);
        }

        @NotNull
        public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            return SHAPE;
        }

        public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
            if (entity instanceof LivingEntity && entity.getType() != EntityType.TURTLE) {
                entity.makeStuckInBlock(state, new Vec3(0.8, 0.75, 0.8));
            }
        }
    }

    public static class SandCastleBlock
    extends Block {
        public static final BooleanProperty TALL_TOWER;
        public static final VoxelShape TALL_TOWER_SHAPE;
        public static final BooleanProperty RIGHT_TOWER;
        public static final VoxelShape RIGHT_TOWER_SHAPE;
        public static final BooleanProperty TOP_TOWER;
        public static final VoxelShape TOP_TOWER_SHAPE;
        public static final BooleanProperty LEFT_TOWER;
        public static final VoxelShape LEFT_TOWER_SHAPE;
        public static final BooleanProperty PETRIFIED;
        private static final VoxelShape BASE_SHAPE;

        public SandCastleBlock(BlockBehaviour.Properties settings) {
            super(settings.randomTicks());
            this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)TALL_TOWER, (Comparable)Boolean.valueOf(false))).setValue((Property)RIGHT_TOWER, (Comparable)Boolean.valueOf(false))).setValue((Property)TOP_TOWER, (Comparable)Boolean.valueOf(false))).setValue((Property)LEFT_TOWER, (Comparable)Boolean.valueOf(false))).setValue((Property)PETRIFIED, (Comparable)Boolean.valueOf(false)));
        }

        @NotNull
        public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            VoxelShape shape = Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[0]);
            if (((Boolean)state.getValue((Property)TALL_TOWER)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)TALL_TOWER_SHAPE);
            }
            if (((Boolean)state.getValue((Property)RIGHT_TOWER)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)RIGHT_TOWER_SHAPE);
            }
            if (((Boolean)state.getValue((Property)LEFT_TOWER)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)LEFT_TOWER_SHAPE);
            }
            if (((Boolean)state.getValue((Property)TOP_TOWER)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)TOP_TOWER_SHAPE);
            }
            return shape;
        }

        @NotNull
        protected ItemInteractionResult useItemOn(ItemStack handStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
            if (((PotionContents)handStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).is(Potions.WATER) && !((Boolean)state.getValue((Property)PETRIFIED)).booleanValue()) {
                if (!player.getAbilities().instabuild) {
                    handStack.shrink(1);
                }
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PETRIFIED, (Comparable)Boolean.valueOf(true)));
                if (world.isClientSide) {
                    int i;
                    BlockState smoothSandState = Blocks.SMOOTH_SANDSTONE.defaultBlockState();
                    for (i = 0; i < 8; ++i) {
                        world.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, smoothSandState), (double)pos.getX() + 0.5 + (world.random.nextDouble() - 0.5) * 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5 + (world.random.nextDouble() - 0.5) * 0.5, 0.0, 0.1, 0.0);
                    }
                    for (i = 0; i < 6; ++i) {
                        world.addParticle((ParticleOptions)ParticleTypes.SPLASH, (double)pos.getX() + 0.5 + (world.random.nextDouble() - 0.5) * 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5 + (world.random.nextDouble() - 0.5) * 0.5, 0.0, 0.1, 0.0);
                    }
                }
                return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
            }
            if (handStack.getItem() == ObjectRegistry.SAND_BUCKET_FILLED.get() && !this.hasAllTowers(state)) {
                BooleanProperty tower = this.getTowerHitPos(hit);
                if (!((Boolean)state.getValue((Property)tower)).booleanValue()) {
                    world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)tower, (Comparable)Boolean.valueOf(true)));
                    this.exchangeStack(handStack, player, new ItemStack((ItemLike)ObjectRegistry.SAND_BUCKET_EMPTY.get()));
                    if (world.isClientSide) {
                        for (int i = 0; i < 8; ++i) {
                            world.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SAND.defaultBlockState()), (double)pos.getX() + 0.5 + (world.random.nextDouble() - 0.5) * 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5 + (world.random.nextDouble() - 0.5) * 0.5, 0.0, 0.1, 0.0);
                        }
                        world.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.SAND_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    }
                    return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
                }
            } else if (handStack.getItem() == ObjectRegistry.SAND_BUCKET_EMPTY.get()) {
                if (this.hasNoTowers(state)) {
                    world.destroyBlock(pos, false);
                    this.exchangeStack(handStack, player, new ItemStack((ItemLike)ObjectRegistry.SAND_BUCKET_FILLED.get()));
                    if (world.isClientSide) {
                        for (int i = 0; i < 6; ++i) {
                            world.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SAND.defaultBlockState()), (double)pos.getX() + 0.5 + (world.random.nextDouble() - 0.5) * 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5 + (world.random.nextDouble() - 0.5) * 0.5, 0.0, 0.1, 0.0);
                        }
                        world.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.SAND_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    }
                    return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
                }
                BooleanProperty tower = this.getTowerHitPos(hit);
                if (((Boolean)state.getValue((Property)tower)).booleanValue()) {
                    world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)tower, (Comparable)Boolean.valueOf(false)));
                    this.exchangeStack(handStack, player, new ItemStack((ItemLike)ObjectRegistry.SAND_BUCKET_FILLED.get()));
                    if (world.isClientSide) {
                        for (int i = 0; i < 6; ++i) {
                            world.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SAND.defaultBlockState()), (double)pos.getX() + 0.5 + (world.random.nextDouble() - 0.5) * 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5 + (world.random.nextDouble() - 0.5) * 0.5, 0.0, 0.1, 0.0);
                        }
                        world.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.SAND_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    }
                    return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
                }
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }

        public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
            if (!((Boolean)state.getValue((Property)PETRIFIED)).booleanValue()) {
                world.setBlockAndUpdate(pos, ((Block)ObjectRegistry.SAND_PILE.get()).defaultBlockState());
            } else if (entity.getType() == EntityType.ZOMBIE) {
                world.destroyBlock(pos, true);
            }
        }

        public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
            if (!((Boolean)state.getValue((Property)PETRIFIED)).booleanValue() && (world.isRainingAt(pos) || world.isRainingAt(pos.above()))) {
                world.setBlockAndUpdate(pos, ((Block)ObjectRegistry.SAND_PILE.get()).defaultBlockState());
                return;
            }
            if (!state.canSurvive((LevelReader)world, pos)) {
                world.destroyBlock(pos, true);
            }
        }

        private void exchangeStack(ItemStack handStack, Player player, ItemStack possibleReturnStack) {
            ItemStack returnStack;
            ItemStack itemStack = returnStack = !player.getAbilities().instabuild ? possibleReturnStack : handStack;
            if (player.isCreative()) {
                if (!player.getInventory().contains(returnStack)) {
                    player.getInventory().add(returnStack);
                }
                return;
            }
            Inventory inventory = player.getInventory();
            int slot = inventory.findSlotMatchingItem(handStack);
            handStack.shrink(1);
            if (player.getInventory().getItem(slot).isEmpty()) {
                if (!inventory.add(slot, returnStack)) {
                    player.drop(returnStack, false);
                }
            } else if (!inventory.add(returnStack)) {
                player.drop(returnStack, false);
            }
        }

        private BooleanProperty getTowerHitPos(BlockHitResult hitResult) {
            double x = hitResult.getLocation().x();
            double z = hitResult.getLocation().z();
            double relX = x - (double)hitResult.getBlockPos().getX();
            double relZ = z - (double)hitResult.getBlockPos().getZ();
            if (relX >= 0.5 && relZ >= 0.5) {
                return TALL_TOWER;
            }
            if (relX < 0.5 && relZ >= 0.5) {
                return RIGHT_TOWER;
            }
            if (relX >= 0.5 && relZ < 0.5) {
                return LEFT_TOWER;
            }
            return TOP_TOWER;
        }

        private boolean hasAllTowers(BlockState state) {
            return (Boolean)state.getValue((Property)TALL_TOWER) != false && (Boolean)state.getValue((Property)RIGHT_TOWER) != false && (Boolean)state.getValue((Property)TOP_TOWER) != false && (Boolean)state.getValue((Property)LEFT_TOWER) != false;
        }

        private boolean hasNoTowers(BlockState state) {
            return (Boolean)state.getValue((Property)TALL_TOWER) == false && (Boolean)state.getValue((Property)RIGHT_TOWER) == false && (Boolean)state.getValue((Property)TOP_TOWER) == false && (Boolean)state.getValue((Property)LEFT_TOWER) == false;
        }

        @NotNull
        public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
            if (!state.canSurvive((LevelReader)world, pos)) {
                world.scheduleTick(pos, (Block)this, 1);
            }
            return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
        }

        public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
            BlockPos blockPos = pos.below();
            return world.getBlockState(blockPos).isFaceSturdy((BlockGetter)world, blockPos, Direction.UP);
        }

        @NotNull
        public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
            return new ItemStack((ItemLike)ObjectRegistry.SAND_BUCKET_FILLED.get());
        }

        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            builder.add(new Property[]{TALL_TOWER, RIGHT_TOWER, TOP_TOWER, LEFT_TOWER, PETRIFIED});
        }

        static {
            TALL_TOWER_SHAPE = Block.box((double)11.0, (double)0.0, (double)11.0, (double)15.0, (double)15.0, (double)15.0);
            RIGHT_TOWER_SHAPE = Block.box((double)1.0, (double)1.0, (double)11.0, (double)5.0, (double)12.0, (double)15.0);
            TOP_TOWER_SHAPE = Block.box((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0);
            LEFT_TOWER_SHAPE = Block.box((double)11.0, (double)1.0, (double)1.0, (double)15.0, (double)12.0, (double)5.0);
            BASE_SHAPE = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0));
            TALL_TOWER = BooleanProperty.create((String)"tall");
            RIGHT_TOWER = BooleanProperty.create((String)"right");
            TOP_TOWER = BooleanProperty.create((String)"top");
            LEFT_TOWER = BooleanProperty.create((String)"left");
            PETRIFIED = BooleanProperty.create((String)"petrified");
        }
    }
}

