/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.beachparty.core.block.LineConnectingBlock;
import net.satisfy.beachparty.core.util.BeachpartyUtil;
import org.jetbrains.annotations.NotNull;

public class HoodedBeachChair
extends LineConnectingBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = EnumProperty.create((String)"half", DoubleBlockHalf.class);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final Supplier<VoxelShape> topRightShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.8125, (double)0.0, (double)0.9375, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.75, (double)0.75, (double)0.9375, (double)0.9375, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.875, (double)0.8125, (double)0.0625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.874375, (double)0.0, (double)0.0, (double)0.936875, (double)0.8125, (double)0.75), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    private static final Supplier<VoxelShape> topLeftShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.8125, (double)0.0, (double)1.0, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.75, (double)0.75, (double)1.0, (double)0.9375, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.0, (double)1.0, (double)0.8125, (double)0.0625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.063125, (double)0.0, (double)0.0, (double)0.125625, (double)0.8125, (double)0.75), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    public static final Map<Direction, VoxelShape> TOP_RIGHT_SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            VoxelShape shape = direction == Direction.NORTH || direction == Direction.SOUTH ? topLeftShapeSupplier.get() : topRightShapeSupplier.get();
            map.put(direction, BeachpartyUtil.rotateShape(Direction.SOUTH, direction, shape));
        }
    });
    public static final Map<Direction, VoxelShape> TOP_LEFT_SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            VoxelShape shape = direction == Direction.NORTH || direction == Direction.SOUTH ? topRightShapeSupplier.get() : topLeftShapeSupplier.get();
            map.put(direction, BeachpartyUtil.rotateShape(Direction.SOUTH, direction, shape));
        }
    });
    private static final Supplier<VoxelShape> topMiddleShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.8125, (double)0.0, (double)1.0, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.75, (double)0.75, (double)1.0, (double)0.9375, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.8125, (double)0.0625), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    public static final Map<Direction, VoxelShape> TOP_MIDDLE_SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, BeachpartyUtil.rotateShape(Direction.SOUTH, direction, topMiddleShapeSupplier.get()));
        }
    });
    private static final Supplier<VoxelShape> bottomRightShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.0, (double)0.1875, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.25, (double)0.875, (double)0.375, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.375, (double)0.25, (double)0.875, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    private static final Supplier<VoxelShape> bottomLeftShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.1875, (double)0.125, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.25, (double)1.0, (double)0.375, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.375, (double)0.25, (double)1.0, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    public static final Map<Direction, VoxelShape> BOTTOM_RIGHT_SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            VoxelShape shape = direction == Direction.NORTH || direction == Direction.SOUTH ? bottomLeftShapeSupplier.get() : bottomRightShapeSupplier.get();
            map.put(direction, BeachpartyUtil.rotateShape(Direction.SOUTH, direction, shape));
        }
    });
    public static final Map<Direction, VoxelShape> BOTTOM_LEFT_SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            VoxelShape shape = direction == Direction.NORTH || direction == Direction.SOUTH ? bottomRightShapeSupplier.get() : bottomLeftShapeSupplier.get();
            map.put(direction, BeachpartyUtil.rotateShape(Direction.SOUTH, direction, shape));
        }
    });
    private static final Supplier<VoxelShape> bottomMiddleShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.25, (double)1.0, (double)0.375, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.375, (double)0.25, (double)1.0, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    public static final Map<Direction, VoxelShape> BOTTOM_MIDDLE_SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, BeachpartyUtil.rotateShape(Direction.SOUTH, direction, bottomMiddleShapeSupplier.get()));
        }
    });
    private static final Supplier<VoxelShape> topShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.8125, (double)0.0, (double)0.9375, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.75, (double)0.75, (double)0.9375, (double)0.9375, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875625, (double)0.0, (double)0.0, (double)0.938125, (double)0.8125, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.0, (double)0.875, (double)0.8125, (double)0.0625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.063125, (double)0.0, (double)0.0, (double)0.125625, (double)0.8125, (double)0.75), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    public static final Map<Direction, VoxelShape> TOP_SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, BeachpartyUtil.rotateShape(Direction.SOUTH, direction, topShapeSupplier.get()));
        }
    });
    private static final Supplier<VoxelShape> bottomShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.0, (double)0.1875, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.1875, (double)0.125, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.25, (double)0.875, (double)0.375, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.375, (double)0.25, (double)0.875, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.4375, (double)0.125, (double)0.875, (double)1.0, (double)0.1875), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    public static final Map<Direction, VoxelShape> BOTTOM_SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, BeachpartyUtil.rotateShape(Direction.SOUTH, direction, bottomShapeSupplier.get()));
        }
    });

    public HoodedBeachChair(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)TYPE, (Comparable)((Object)BeachpartyUtil.LineConnectingType.NONE)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF});
    }

    @Override
    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        BlockPos upperPos = pos.above();
        BlockState upperState = (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER);
        world.setBlock(upperPos, upperState, 3);
        this.updateTypeProperty(world, pos, state);
        this.updateTypeProperty(world, upperPos, upperState);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        DoubleBlockHalf half;
        BlockPos otherPos;
        BlockState otherState;
        if (!moved && state.getBlock() != newState.getBlock() && (otherState = world.getBlockState(otherPos = (half = (DoubleBlockHalf)state.getValue(HALF)) == DoubleBlockHalf.LOWER ? pos.above() : pos.below())).getBlock() == this && otherState.getValue(HALF) != half) {
            world.setBlock(otherPos, Blocks.AIR.defaultBlockState(), 35);
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        DoubleBlockHalf half = (DoubleBlockHalf)blockState.getValue(HALF);
        BlockPos basePos = half == DoubleBlockHalf.LOWER ? blockPos : blockPos.below();
        return BeachpartyUtil.onUse(level, player, interactionHand, new BlockHitResult(blockHitResult.getLocation(), blockHitResult.getDirection(), basePos, blockHitResult.isInside()), 0.2);
    }

    public long getSeed(BlockState state, BlockPos pos) {
        BlockPos basePos = state.getValue(HALF) == DoubleBlockHalf.LOWER ? pos : pos.below();
        return basePos.asLong();
    }

    @Override
    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Override
    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Override
    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.isClientSide) {
            return;
        }
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        BlockPos basePos = half == DoubleBlockHalf.LOWER ? pos : pos.below();
        BlockState baseState = world.getBlockState(basePos);
        this.updateTypeProperty(world, basePos, baseState);
        BlockPos otherPos = basePos.above();
        BlockState otherState = world.getBlockState(otherPos);
        if (otherState.getBlock() == this) {
            world.setBlock(otherPos, (BlockState)otherState.setValue((Property)TYPE, (Comparable)((Object)((BeachpartyUtil.LineConnectingType)((Object)baseState.getValue((Property)TYPE))))), 3);
        }
    }

    private void updateTypeProperty(Level world, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BeachpartyUtil.LineConnectingType type = this.getType(state, world, pos, facing);
        if (state.getValue((Property)TYPE) != type) {
            world.setBlock(pos, (BlockState)state.setValue((Property)TYPE, (Comparable)((Object)type)), 3);
        }
    }

    private BeachpartyUtil.LineConnectingType getType(BlockState state, Level world, BlockPos pos, Direction facing) {
        BlockPos leftPos;
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        BlockPos rightPos = switch (facing) {
            case Direction.EAST -> {
                leftPos = pos.relative(Direction.SOUTH);
                yield pos.relative(Direction.NORTH);
            }
            case Direction.SOUTH -> {
                leftPos = pos.relative(Direction.EAST);
                yield pos.relative(Direction.WEST);
            }
            case Direction.WEST -> {
                leftPos = pos.relative(Direction.NORTH);
                yield pos.relative(Direction.SOUTH);
            }
            default -> {
                leftPos = pos.relative(Direction.WEST);
                yield pos.relative(Direction.EAST);
            }
        };
        if (half == DoubleBlockHalf.UPPER) {
            leftPos = leftPos.above();
            rightPos = rightPos.above();
        }
        BlockState leftState = world.getBlockState(leftPos);
        BlockState rightState = world.getBlockState(rightPos);
        return this.determineType(state, leftState, rightState);
    }

    private BeachpartyUtil.LineConnectingType determineType(BlockState state, BlockState leftState, BlockState rightState) {
        boolean connectLeft = this.isConnectable(state, leftState);
        boolean connectRight = this.isConnectable(state, rightState);
        if (connectLeft && connectRight) {
            return BeachpartyUtil.LineConnectingType.MIDDLE;
        }
        if (connectLeft) {
            return BeachpartyUtil.LineConnectingType.RIGHT;
        }
        if (connectRight) {
            return BeachpartyUtil.LineConnectingType.LEFT;
        }
        return BeachpartyUtil.LineConnectingType.NONE;
    }

    @Override
    protected boolean isConnectable(BlockState selfState, BlockState otherState) {
        if (otherState.getBlock() != this) {
            return false;
        }
        return selfState.getValue((Property)FACING) == otherState.getValue((Property)FACING) && selfState.getValue(HALF) == otherState.getValue(HALF);
    }

    public void destroy(LevelAccessor world, BlockPos pos, BlockState state) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        BlockPos otherPos = half == DoubleBlockHalf.LOWER ? pos.above() : pos.below();
        BlockState otherState = world.getBlockState(otherPos);
        if (otherState.getBlock() == this && otherState.getValue(HALF) != half) {
            world.destroyBlock(otherPos, false);
        }
        if (half == DoubleBlockHalf.UPPER && world instanceof Level) {
            Level level = (Level)world;
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.asItem()));
        }
        super.destroy(world, pos, state);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        BeachpartyUtil.LineConnectingType type = (BeachpartyUtil.LineConnectingType)((Object)state.getValue((Property)TYPE));
        if (half == DoubleBlockHalf.UPPER) {
            return switch (type) {
                case BeachpartyUtil.LineConnectingType.RIGHT -> TOP_RIGHT_SHAPE.get(direction);
                case BeachpartyUtil.LineConnectingType.LEFT -> TOP_LEFT_SHAPE.get(direction);
                case BeachpartyUtil.LineConnectingType.MIDDLE -> TOP_MIDDLE_SHAPE.get(direction);
                default -> TOP_SHAPE.get(direction);
            };
        }
        return switch (type) {
            case BeachpartyUtil.LineConnectingType.RIGHT -> BOTTOM_RIGHT_SHAPE.get(direction);
            case BeachpartyUtil.LineConnectingType.LEFT -> BOTTOM_LEFT_SHAPE.get(direction);
            case BeachpartyUtil.LineConnectingType.MIDDLE -> BOTTOM_MIDDLE_SHAPE.get(direction);
            default -> BOTTOM_SHAPE.get(direction);
        };
    }
}

