/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.client.NotificationToast;
import dev.latvian.mods.kubejs.color.KubeColor;
import dev.latvian.mods.kubejs.color.SimpleColor;
import dev.latvian.mods.kubejs.util.IconKJS;
import dev.latvian.mods.kubejs.util.TimeJS;
import java.time.Duration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public record NotificationToastData(Duration duration, Component text, IconKJS icon, int iconSize, KubeColor outlineColor, KubeColor borderColor, KubeColor backgroundColor, boolean textShadow) {
    public static final Duration DEFAULT_DURATION = Duration.ofSeconds(5L);
    public static final KubeColor DEFAULT_BORDER_COLOR = new SimpleColor(4663636);
    public static final KubeColor DEFAULT_BACKGROUND_COLOR = new SimpleColor(2364213);
    public static final MapCodec<NotificationToastData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TimeJS.DURATION.optionalFieldOf("duration", (Object)DEFAULT_DURATION).forGetter(NotificationToastData::duration), (App)ComponentSerialization.CODEC.optionalFieldOf("text", (Object)Component.empty()).forGetter(NotificationToastData::text), (App)IconKJS.CODEC.optionalFieldOf("icon", (Object)IconKJS.NONE).forGetter(NotificationToastData::icon), (App)Codec.INT.optionalFieldOf("icon_size", (Object)16).forGetter(NotificationToastData::iconSize), (App)KubeColor.CODEC.optionalFieldOf("outline_color", (Object)SimpleColor.BLACK).forGetter(NotificationToastData::outlineColor), (App)KubeColor.CODEC.optionalFieldOf("border_color", (Object)DEFAULT_BORDER_COLOR).forGetter(NotificationToastData::borderColor), (App)KubeColor.CODEC.optionalFieldOf("background_color", (Object)DEFAULT_BACKGROUND_COLOR).forGetter(NotificationToastData::backgroundColor), (App)Codec.BOOL.optionalFieldOf("text_shadow", (Object)false).forGetter(NotificationToastData::textShadow)).apply((Applicative)instance, NotificationToastData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, NotificationToastData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, NotificationToastData>(){

        public NotificationToastData decode(RegistryFriendlyByteBuf buf) {
            Duration duration = (Duration)TimeJS.DURATION_STREAM.decode((Object)buf);
            Component text = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf);
            IconKJS icon = (IconKJS)IconKJS.STREAM_CODEC.decode((Object)buf);
            Integer iconSize = (Integer)ByteBufCodecs.VAR_INT.decode((Object)buf);
            KubeColor outlineColor = (KubeColor)KubeColor.STREAM_CODEC.decode((Object)buf);
            KubeColor borderColor = (KubeColor)KubeColor.STREAM_CODEC.decode((Object)buf);
            KubeColor backgroundColor = (KubeColor)KubeColor.STREAM_CODEC.decode((Object)buf);
            Boolean textShadow = (Boolean)ByteBufCodecs.BOOL.decode((Object)buf);
            return new NotificationToastData(duration, text, icon, iconSize, outlineColor, borderColor, backgroundColor, textShadow);
        }

        public void encode(RegistryFriendlyByteBuf buf, NotificationToastData data) {
            TimeJS.DURATION_STREAM.encode((Object)buf, (Object)data.duration());
            ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)data.text());
            IconKJS.STREAM_CODEC.encode((Object)buf, (Object)data.icon());
            ByteBufCodecs.VAR_INT.encode((Object)buf, (Object)data.iconSize());
            KubeColor.STREAM_CODEC.encode((Object)buf, (Object)data.outlineColor());
            KubeColor.STREAM_CODEC.encode((Object)buf, (Object)data.borderColor());
            KubeColor.STREAM_CODEC.encode((Object)buf, (Object)data.backgroundColor());
            ByteBufCodecs.BOOL.encode((Object)buf, (Object)data.textShadow());
        }
    };

    public static NotificationToastData ofText(Component text) {
        return new NotificationToastData(DEFAULT_DURATION, text, IconKJS.NONE, 16, SimpleColor.BLACK, DEFAULT_BORDER_COLOR, DEFAULT_BACKGROUND_COLOR, false);
    }

    public static NotificationToastData ofTitle(Component title, @Nullable Component text) {
        return text == null ? NotificationToastData.ofText(title) : NotificationToastData.ofText((Component)Component.empty().append(title).append("\n").append(text));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void show() {
        Minecraft mc = Minecraft.getInstance();
        mc.getToasts().addToast((Toast)new NotificationToast(mc, this));
    }
}

