/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.filter;

import dev.latvian.mods.kubejs.core.RecipeLikeKJS;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.recipe.RecipesKubeEvent;
import dev.latvian.mods.kubejs.recipe.filter.AndFilter;
import dev.latvian.mods.kubejs.recipe.filter.ConstantFilter;
import dev.latvian.mods.kubejs.recipe.filter.GroupFilter;
import dev.latvian.mods.kubejs.recipe.filter.IDFilter;
import dev.latvian.mods.kubejs.recipe.filter.InputFilter;
import dev.latvian.mods.kubejs.recipe.filter.ModFilter;
import dev.latvian.mods.kubejs.recipe.filter.NotFilter;
import dev.latvian.mods.kubejs.recipe.filter.OrFilter;
import dev.latvian.mods.kubejs.recipe.filter.OutputFilter;
import dev.latvian.mods.kubejs.recipe.filter.RecipeFilterParseEvent;
import dev.latvian.mods.kubejs.recipe.filter.RegexIDFilter;
import dev.latvian.mods.kubejs.recipe.filter.TypeFilter;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.RegExpKJS;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface RecipeFilter {
    public boolean test(Context var1, RecipeLikeKJS var2);

    public static RecipeFilter of(Context cx, @Nullable Object o) {
        if (o == null || o == ConstantFilter.TRUE) {
            return ConstantFilter.TRUE;
        }
        if (o == ConstantFilter.FALSE) {
            return ConstantFilter.FALSE;
        }
        if (o instanceof CharSequence || o instanceof NativeRegExp || o instanceof Pattern) {
            String s = o.toString();
            if (s.equals("*")) {
                return ConstantFilter.TRUE;
            }
            if (s.equals("-")) {
                return ConstantFilter.FALSE;
            }
            Pattern r = RegExpKJS.wrap(s);
            return r == null ? new IDFilter(ID.mc(s)) : RegexIDFilter.of(r);
        }
        if (o instanceof BaseFunction) {
            BaseFunction func = (BaseFunction)o;
            return (RecipeFilter)cx.createInterfaceAdapter(TypeInfo.of(RecipeFilter.class), (ScriptableObject)func);
        }
        List<?> list = ListJS.orSelf(o);
        if (list.isEmpty()) {
            return ConstantFilter.FALSE;
        }
        if (list.size() > 1) {
            OrFilter predicate = new OrFilter();
            for (Object o1 : list) {
                RecipeFilter p = RecipeFilter.of(cx, o1);
                if (p == ConstantFilter.TRUE) {
                    return ConstantFilter.TRUE;
                }
                if (p == ConstantFilter.FALSE) continue;
                predicate.list.add(p);
            }
            return predicate.list.isEmpty() ? ConstantFilter.FALSE : (predicate.list.size() == 1 ? predicate.list.getFirst() : predicate);
        }
        Map<?, ?> map = MapJS.of(list.getFirst());
        if (map == null || map.isEmpty()) {
            return ConstantFilter.TRUE;
        }
        AndFilter predicate = new AndFilter();
        if (map.get("or") != null) {
            predicate.list.add(RecipeFilter.of(cx, map.get("or")));
        }
        if (map.get("not") != null) {
            predicate.list.add(new NotFilter(RecipeFilter.of(cx, map.get("not"))));
        }
        try {
            Object output;
            Object input;
            Object mod;
            Object group;
            Object type;
            Object id = map.get("id");
            if (id != null) {
                Pattern pattern = RegExpKJS.wrap(id);
                predicate.list.add(pattern == null ? new IDFilter(ID.mc(id)) : RegexIDFilter.of(pattern));
            }
            if ((type = map.get("type")) != null) {
                predicate.list.add(new TypeFilter(ID.mc(type)));
            }
            if ((group = map.get("group")) != null) {
                predicate.list.add(new GroupFilter(group.toString()));
            }
            if ((mod = map.get("mod")) != null) {
                predicate.list.add(new ModFilter(mod.toString()));
            }
            if ((input = map.get("input")) != null) {
                ReplacementMatchInfo m = ReplacementMatchInfo.wrap(cx, input, (TypeInfo)ReplacementMatchInfo.TYPE_INFO);
                if (m != ReplacementMatchInfo.NONE) {
                    predicate.list.add(new InputFilter(m));
                } else {
                    throw Context.reportRuntimeError((String)("Unable to parse recipe input filter `" + String.valueOf(input) + "`"), (Context)cx);
                }
            }
            if ((output = map.get("output")) != null) {
                ReplacementMatchInfo m = ReplacementMatchInfo.wrap(cx, output, (TypeInfo)ReplacementMatchInfo.TYPE_INFO);
                if (m != ReplacementMatchInfo.NONE) {
                    predicate.list.add(new OutputFilter(m));
                } else {
                    throw Context.reportRuntimeError((String)("Unable to parse recipe output filter `" + String.valueOf(output) + "`"), (Context)cx);
                }
            }
            NeoForge.EVENT_BUS.post((Event)new RecipeFilterParseEvent(cx, predicate.list, map));
            if (predicate.list.isEmpty() && !map.isEmpty()) {
                throw Context.reportRuntimeError((String)("Unable to parse recipe filter " + String.valueOf(map)), (Context)cx);
            }
            return predicate.list.isEmpty() ? ConstantFilter.TRUE : (predicate.list.size() == 1 ? predicate.list.getFirst() : predicate);
        }
        catch (KubeRuntimeException rex) {
            ConsoleJS.getCurrent(cx).warn("", rex, RecipesKubeEvent.POST_SKIP_ERROR);
            return ConstantFilter.FALSE;
        }
    }
}

