/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.mixin;

import io.github.lucaargolo.kibe.blockentity.DehumidifierBlockEntity;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={LevelRenderer.class})
public class WorldRendererMixin {
    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getHeight(Lnet/minecraft/world/level/levelgen/Heightmap$Types;II)I"), method={"renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V"})
    private int onRenderWeather(Level world, Heightmap.Types heightmap, int x, int z) {
        if (DehumidifierBlockEntity.Companion.isBeingDehumidified(new ChunkPos(new BlockPos(x, 0, z)))) {
            return 512;
        }
        return world.getHeight(heightmap, x, z);
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/level/LevelReader;getHeightmapPos(Lnet/minecraft/world/level/levelgen/Heightmap$Types;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/BlockPos;"), method={"tickRain(Lnet/minecraft/client/Camera;)V"})
    private BlockPos onTickRainSplashing(LevelReader world, Heightmap.Types heightmap, BlockPos pos) {
        if (DehumidifierBlockEntity.Companion.isBeingDehumidified(new ChunkPos(pos))) {
            return new BlockPos(pos.getX(), 512, pos.getZ());
        }
        return world.getHeightmapPos(heightmap, pos);
    }
}

